/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization.jackson;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.DynamicAccess;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.ExtensionIdProvider;
import akka.annotation.InternalStableApi;
import akka.event.LoggingAdapter;
import akka.serialization.jackson.JacksonObjectMapperFactory;
import akka.serialization.jackson.JacksonObjectMapperProvider;
import akka.util.ccompat.package;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class JacksonObjectMapperProvider$
implements ExtensionId<JacksonObjectMapperProvider>,
ExtensionIdProvider {
    public static final JacksonObjectMapperProvider$ MODULE$ = new JacksonObjectMapperProvider$();

    static {
        ExtensionId.$init$((ExtensionId)MODULE$);
    }

    public Extension apply(ActorSystem system) {
        return ExtensionId.apply$((ExtensionId)this, (ActorSystem)system);
    }

    public Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)this, (ClassicActorSystemProvider)system);
    }

    public final int hashCode() {
        return ExtensionId.hashCode$((ExtensionId)this);
    }

    public final boolean equals(Object other) {
        return ExtensionId.equals$((ExtensionId)this, (Object)other);
    }

    public JacksonObjectMapperProvider get(ActorSystem system) {
        return (JacksonObjectMapperProvider)ExtensionId.get$((ExtensionId)this, (ActorSystem)system);
    }

    public JacksonObjectMapperProvider get(ClassicActorSystemProvider system) {
        return (JacksonObjectMapperProvider)ExtensionId.get$((ExtensionId)this, (ClassicActorSystemProvider)system);
    }

    public JacksonObjectMapperProvider$ lookup() {
        return this;
    }

    public JacksonObjectMapperProvider createExtension(ExtendedActorSystem system) {
        return new JacksonObjectMapperProvider(system);
    }

    public Config configForBinding(String bindingName, Config systemConfig) {
        String basePath = "akka.serialization.jackson";
        Config baseConf = systemConfig.getConfig("akka.serialization.jackson");
        return systemConfig.hasPath(new StringBuilder(1).append(basePath).append(".").append(bindingName).toString()) ? systemConfig.getConfig(new StringBuilder(1).append(basePath).append(".").append(bindingName).toString()).withFallback((ConfigMergeable)baseConf) : baseConf;
    }

    private JsonFactory createJsonFactory(String bindingName, JacksonObjectMapperFactory objectMapperFactory, Config config, Option<JsonFactory> baseJsonFactory) {
        JsonFactory jsonFactory;
        Option<JsonFactory> option = baseJsonFactory;
        if (option instanceof Some) {
            JsonFactory factory;
            Some some = (Some)option;
            jsonFactory = factory = (JsonFactory)some.value();
        } else if (None$.MODULE$.equals(option)) {
            jsonFactory = new JsonFactoryBuilder().build();
        } else {
            throw new MatchError(option);
        }
        JsonFactory jsonFactory2 = jsonFactory;
        Seq configuredStreamReadFeatures = (Seq)this.features(config, "stream-read-features").map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamReadFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<StreamReadFeature, Object>> streamReadFeatures = objectMapperFactory.overrideConfiguredStreamReadFeatures(bindingName, (Seq<Tuple2<StreamReadFeature, Object>>)configuredStreamReadFeatures);
        streamReadFeatures.foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StreamReadFeature feature = (StreamReadFeature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            JsonFactory jsonFactory = jsonFactory2.configure(feature.mappedFeature(), value);
            return jsonFactory;
        });
        Seq configuredStreamWriteFeatures = (Seq)this.features(config, "stream-write-features").map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamWriteFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<StreamWriteFeature, Object>> streamWriteFeatures = objectMapperFactory.overrideConfiguredStreamWriteFeatures(bindingName, (Seq<Tuple2<StreamWriteFeature, Object>>)configuredStreamWriteFeatures);
        streamWriteFeatures.foreach((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StreamWriteFeature feature = (StreamWriteFeature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            JsonFactory jsonFactory = jsonFactory2.configure(feature.mappedFeature(), value);
            return jsonFactory;
        });
        Seq configuredJsonReadFeatures = (Seq)this.features(config, "json-read-features").map((Function1 & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JsonReadFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<JsonReadFeature, Object>> jsonReadFeatures = objectMapperFactory.overrideConfiguredJsonReadFeatures(bindingName, (Seq<Tuple2<JsonReadFeature, Object>>)configuredJsonReadFeatures);
        jsonReadFeatures.foreach((Function1 & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            JsonReadFeature feature = (JsonReadFeature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            JsonFactory jsonFactory = jsonFactory2.configure(feature.mappedFeature(), value);
            return jsonFactory;
        });
        Seq configuredJsonWriteFeatures = (Seq)this.features(config, "json-write-features").map((Function1 & Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JsonWriteFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<JsonWriteFeature, Object>> jsonWriteFeatures = objectMapperFactory.overrideConfiguredJsonWriteFeatures(bindingName, (Seq<Tuple2<JsonWriteFeature, Object>>)configuredJsonWriteFeatures);
        jsonWriteFeatures.foreach((Function1 & Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            JsonWriteFeature feature = (JsonWriteFeature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            JsonFactory jsonFactory = jsonFactory2.configure(feature.mappedFeature(), value);
            return jsonFactory;
        });
        return jsonFactory2;
    }

    private void configureObjectMapperFeatures(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config) {
        Seq configuredSerializationFeatures = (Seq)this.features(config, "serialization-features").map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SerializationFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<SerializationFeature, Object>> serializationFeatures = objectMapperFactory.overrideConfiguredSerializationFeatures(bindingName, (Seq<Tuple2<SerializationFeature, Object>>)configuredSerializationFeatures);
        serializationFeatures.foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SerializationFeature feature = (SerializationFeature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            ObjectMapper objectMapper = objectMapper.configure(feature, value);
            return objectMapper;
        });
        Seq configuredDeserializationFeatures = (Seq)this.features(config, "deserialization-features").map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeserializationFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<DeserializationFeature, Object>> deserializationFeatures = objectMapperFactory.overrideConfiguredDeserializationFeatures(bindingName, (Seq<Tuple2<DeserializationFeature, Object>>)configuredDeserializationFeatures);
        deserializationFeatures.foreach((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DeserializationFeature feature = (DeserializationFeature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            ObjectMapper objectMapper = objectMapper.configure(feature, value);
            return objectMapper;
        });
        Seq configuredMapperFeatures = (Seq)this.features(config, "mapper-features").map((Function1 & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MapperFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<MapperFeature, Object>> mapperFeatures = objectMapperFactory.overrideConfiguredMapperFeatures(bindingName, (Seq<Tuple2<MapperFeature, Object>>)configuredMapperFeatures);
        mapperFeatures.foreach((Function1 & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MapperFeature feature = (MapperFeature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            ObjectMapper objectMapper = objectMapper.configure(feature, value);
            return objectMapper;
        });
        Seq configuredJsonParserFeatures = (Seq)this.features(config, "json-parser-features").map((Function1 & Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JsonParser.Feature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<JsonParser.Feature, Object>> jsonParserFeatures = objectMapperFactory.overrideConfiguredJsonParserFeatures(bindingName, (Seq<Tuple2<JsonParser.Feature, Object>>)configuredJsonParserFeatures);
        jsonParserFeatures.foreach((Function1 & Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            JsonParser.Feature feature = (JsonParser.Feature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            ObjectMapper objectMapper = objectMapper.configure(feature, value);
            return objectMapper;
        });
        Seq configuredJsonGeneratorFeatures = (Seq)this.features(config, "json-generator-features").map((Function1 & Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String enumName = (String)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JsonGenerator.Feature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            return tuple22;
        });
        Seq<Tuple2<JsonGenerator.Feature, Object>> jsonGeneratorFeatures = objectMapperFactory.overrideConfiguredJsonGeneratorFeatures(bindingName, (Seq<Tuple2<JsonGenerator.Feature, Object>>)configuredJsonGeneratorFeatures);
        jsonGeneratorFeatures.foreach((Function1 & Serializable)x0$10 -> {
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            JsonGenerator.Feature feature = (JsonGenerator.Feature)tuple2._1();
            boolean value = tuple2._2$mcZ$sp();
            ObjectMapper objectMapper = objectMapper.configure(feature, value);
            return objectMapper;
        });
    }

    private void configureObjectVisibility(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config) {
        Seq configuredVisibility = (Seq)this.configPairs(config, "visibility").map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String property = (String)tuple2._1();
            String visibility = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyAccessor.valueOf((String)property)), (Object)JsonAutoDetect.Visibility.valueOf((String)visibility));
            return tuple22;
        });
        Seq<Tuple2<PropertyAccessor, JsonAutoDetect.Visibility>> visibility = objectMapperFactory.overrideConfiguredVisibility(bindingName, (Seq<Tuple2<PropertyAccessor, JsonAutoDetect.Visibility>>)configuredVisibility);
        visibility.foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PropertyAccessor property = (PropertyAccessor)tuple2._1();
            JsonAutoDetect.Visibility visibility = (JsonAutoDetect.Visibility)tuple2._2();
            ObjectMapper objectMapper = objectMapper.setVisibility(property, visibility);
            return objectMapper;
        });
    }

    private void configureObjectMapperModules(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config, DynamicAccess dynamicAccess, Option<LoggingAdapter> log) {
        Buffer configuredModules = package.JavaConverters$.MODULE$.ListHasAsScala(config.getStringList("jackson-modules")).asScala();
        Buffer modules1 = (Buffer)configuredModules.flatMap((Function1 & Serializable)fqcn -> {
            None$ none$;
            if (MODULE$.isModuleEnabled((String)fqcn, dynamicAccess)) {
                Some some;
                Try try_ = dynamicAccess.createInstanceFor(fqcn, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(Module.class));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Module m = (Module)success.value();
                    some = new Some((Object)m);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    log.foreach((Function1 & Serializable)x$1 -> {
                        x$1.error(e, new StringBuilder(133).append(new StringBuilder(45).append("Could not load configured Jackson module [").append(fqcn).append("], ").toString()).append("please verify classpath dependencies or amend the configuration ").append("[akka.serialization.jackson-modules]. Continuing without this module.").toString());
                        return BoxedUnit.UNIT;
                    });
                    some = None$.MODULE$;
                } else {
                    throw new MatchError((Object)try_);
                }
                none$ = some;
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        List modules2 = ((IterableOnceOps)modules1.map((Function1 & Serializable)module -> module instanceof ParameterNamesModule ? new ParameterNamesModule(JsonCreator.Mode.PROPERTIES) : module)).toList();
        Seq<Module> modules3 = objectMapperFactory.overrideConfiguredModules(bindingName, (Seq<Module>)modules2);
        modules3.foreach((Function1 & Serializable)module -> {
            JacksonObjectMapperProvider$.$anonfun$configureObjectMapperModules$4(objectMapper, log, module);
            return BoxedUnit.UNIT;
        });
    }

    @InternalStableApi
    public ObjectMapper createObjectMapper(String bindingName, Option<JsonFactory> jsonFactory, JacksonObjectMapperFactory objectMapperFactory, Config config, DynamicAccess dynamicAccess, Option<LoggingAdapter> log) {
        JsonFactory configuredJsonFactory = this.createJsonFactory(bindingName, objectMapperFactory, config, jsonFactory);
        ObjectMapper mapper = objectMapperFactory.newObjectMapper(bindingName, configuredJsonFactory);
        this.configureObjectMapperFeatures(bindingName, mapper, objectMapperFactory, config);
        this.configureObjectMapperModules(bindingName, mapper, objectMapperFactory, config, dynamicAccess, log);
        this.configureObjectVisibility(bindingName, mapper, objectMapperFactory, config);
        return mapper;
    }

    private boolean isModuleEnabled(String fqcn, DynamicAccess dynamicAccess) {
        boolean bl;
        block4: {
            String string = fqcn;
            switch (string == null ? 0 : string.hashCode()) {
                case -1364328776: {
                    if (!"akka.serialization.jackson.AkkaStreamJacksonModule".equals(string)) break;
                    bl = dynamicAccess.classIsOnClasspath("akka.stream.Graph");
                    break block4;
                }
                case 737944956: {
                    if (!"akka.serialization.jackson.AkkaTypedJacksonModule".equals(string)) break;
                    bl = dynamicAccess.classIsOnClasspath("akka.actor.typed.ActorRef");
                    break block4;
                }
            }
            bl = true;
        }
        return bl;
    }

    private Seq<Tuple2<String, Object>> features(Config config, String section) {
        Config cfg = config.getConfig(section);
        return ((IterableOnceOps)package.JavaConverters$.MODULE$.SetHasAsScala(cfg.root().keySet()).asScala().map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)BoxesRunTime.boxToBoolean((boolean)cfg.getBoolean(key))))).toList();
    }

    private Seq<Tuple2<String, String>> configPairs(Config config, String section) {
        Config cfg = config.getConfig(section);
        return ((IterableOnceOps)package.JavaConverters$.MODULE$.SetHasAsScala(cfg.root().keySet()).asScala().map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)cfg.getString(key)))).toList();
    }

    public static final /* synthetic */ void $anonfun$configureObjectMapperModules$4(ObjectMapper objectMapper$3, Option log$1, Module module) {
        objectMapper$3.registerModule(module);
        log$1.foreach((Function1 & Serializable)x$2 -> {
            x$2.debug("Registered Jackson module [{}]", (Object)module.getClass().getName());
            return BoxedUnit.UNIT;
        });
    }

    private JacksonObjectMapperProvider$() {
    }
}

