/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Drops up or down messages according to user-defined filters")
public class DROP
extends Protocol {
    protected final List<Predicate<Message>> down_filters = new ArrayList<Predicate<Message>>();
    protected final List<Predicate<Message>> up_filters = new ArrayList<Predicate<Message>>();

    public DROP addDownFilter(Predicate<Message> filter) {
        this.down_filters.add(filter);
        return this;
    }

    public DROP addUpFilter(Predicate<Message> filter) {
        this.up_filters.add(filter);
        return this;
    }

    public DROP removeDownFilter(Predicate<Message> filter) {
        this.down_filters.remove(filter);
        return this;
    }

    public DROP removeUpFilter(Predicate<Message> filter) {
        this.up_filters.remove(filter);
        return this;
    }

    public DROP clearUpFilters() {
        this.up_filters.clear();
        return this;
    }

    public DROP clearDownFilters() {
        this.down_filters.clear();
        return this;
    }

    @Override
    public Object down(Message msg) {
        for (Predicate<Message> pred : this.down_filters) {
            if (!pred.test(msg)) continue;
            this.dropped(msg, true);
            return null;
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        for (Predicate<Message> pred : this.up_filters) {
            if (!pred.test(msg)) continue;
            this.dropped(msg, false);
            return null;
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        block0: while (it.hasNext()) {
            Message msg = it.next();
            for (Predicate<Message> pred : this.up_filters) {
                if (!pred.test(msg)) continue;
                this.dropped(msg, false);
                it.remove();
                continue block0;
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void dropped(Message msg, boolean down2) {
        this.log.trace("dropped msg %s hdrs: %s\n", down2 ? "to " + String.valueOf(msg.getDest()) : "from " + String.valueOf(msg.getSrc()), msg.printHeaders());
    }
}

