/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.MessageFactory;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.Fragmentation;
import org.jgroups.protocols.TP;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.ByteArray;
import org.jgroups.util.FastArray;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Range;
import org.jgroups.util.Util;

public class FRAG2
extends Fragmentation {
    protected final ConcurrentMap<Address, ConcurrentMap<Long, FragEntry>> fragment_list = Util.createConcurrentMap(11);
    protected final Predicate<Message> HAS_FRAG_HEADER = msg -> msg.getHeader(this.id) != null;
    protected int curr_id = 1;
    protected final List<Address> members = new ArrayList<Address>(11);
    protected MessageFactory msg_factory;
    protected final AverageMinMax avg_size_down = new AverageMinMax();
    protected final AverageMinMax avg_size_up = new AverageMinMax();

    @ManagedAttribute(description="min/avg/max size (in bytes) for messages sent down that needed to be fragmented")
    public String getAvgSizeDown() {
        return this.avg_size_down.toString();
    }

    @ManagedAttribute(description="min/avg/max size (in bytes) of messages re-assembled from fragments")
    public String getAvgSizeUp() {
        return this.avg_size_up.toString();
    }

    synchronized int getNextId() {
        return this.curr_id++;
    }

    @Override
    public void init() throws Exception {
        int max_bundle_size;
        super.init();
        int old_frag_size = this.frag_size;
        if (this.frag_size <= 0) {
            throw new Exception("frag_size=" + old_frag_size + ", new frag_size=" + this.frag_size + ": new frag_size is invalid");
        }
        TP transport = this.getTransport();
        if (transport != null && this.frag_size >= (max_bundle_size = transport.getBundler().getMaxSize())) {
            throw new IllegalArgumentException("frag_size (" + this.frag_size + ") has to be < TP.max_bundle_size (" + max_bundle_size + ")");
        }
        this.msg_factory = transport.getMessageFactory();
        HashMap<String, Integer> info = new HashMap<String, Integer>(1);
        info.put("frag_size", this.frag_size);
        this.down_prot.down(new Event(56, info));
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.avg_size_down.clear();
        this.avg_size_up.clear();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        return super.down(evt);
    }

    @Override
    public Object down(Message msg) {
        long size = msg.getLength();
        if (size > (long)this.frag_size) {
            this.fragment(msg);
            this.avg_size_down.add(size);
            return null;
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        FragHeader hdr = (FragHeader)msg.getHeader(this.id);
        if (hdr != null) {
            Message assembled_msg = this.unfragment(msg, hdr);
            if (assembled_msg != null) {
                assembled_msg.setSrc(msg.getSrc());
                this.up_prot.up(assembled_msg);
                this.avg_size_up.add(assembled_msg.getLength());
            }
            return null;
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        FastArray.FastIterator it = (FastArray.FastIterator)batch.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            FragHeader hdr = (FragHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            Message assembled_msg = this.unfragment(msg, hdr);
            if (assembled_msg != null) {
                assembled_msg.setSrc(batch.sender());
                it.replace(assembled_msg);
                this.avg_size_up.add(assembled_msg.getLength());
                continue;
            }
            it.remove();
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleViewChange(View view) {
        List<Address> new_mbrs = view.getMembers();
        List<Address> left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
        this.members.clear();
        this.members.addAll(new_mbrs);
        for (Address mbr : left_mbrs) {
            this.fragment_list.remove(mbr);
            this.log.trace("%s: removed %s from fragmentation table", this.local_addr, mbr);
        }
    }

    @ManagedOperation(description="removes all fragments sent by mbr")
    public void clearFragmentsFor(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.fragment_list.remove(mbr);
        this.log.trace("%s: removed %s from fragmentation table", this.local_addr, mbr);
    }

    @ManagedOperation(description="Removes all entries from the fragmentation table. Dangerous: this might remove fragments that are still needed to assemble an entire message")
    public void clearAllFragments() {
        this.fragment_list.clear();
    }

    protected void fragment(Message msg) {
        try {
            byte[] byArray;
            boolean serialize = !msg.hasArray();
            ByteArray tmp = null;
            if (serialize) {
                tmp = Util.messageToBuffer(msg);
                byArray = tmp.getArray();
            } else {
                byArray = msg.getArray();
            }
            byte[] buffer = byArray;
            int offset = serialize ? tmp.getOffset() : msg.getOffset();
            int length = serialize ? tmp.getLength() : msg.getLength();
            List<Range> fragments = Util.computeFragOffsets(offset, length, this.frag_size);
            int num_frags = fragments.size();
            this.num_frags_sent.add(num_frags);
            if (this.log.isTraceEnabled()) {
                Address dest = msg.getDest();
                this.log.trace("%s: fragmenting message to %s (size=%d) into %d fragment(s) [frag_size=%d]", this.local_addr, dest != null ? dest : "<all>", msg.getLength(), num_frags, this.frag_size);
            }
            long frag_id = this.getNextId();
            for (int i = 0; i < num_frags; ++i) {
                Range r = fragments.get(i);
                Message frag_msg = null;
                frag_msg = serialize ? new BytesMessage(msg.getDest()).setFlag(msg.getFlags(true), true).setFlag(msg.getFlags(false), false) : msg.copy(false, i == 0);
                frag_msg.setArray(buffer, (int)r.low, (int)r.high);
                FragHeader hdr = new FragHeader(frag_id, i, num_frags).needsDeserialization(serialize);
                frag_msg.putHeader(this.id, hdr);
                this.down_prot.down(frag_msg);
            }
        }
        catch (Exception e) {
            this.log.error("%s: fragmentation failure: %s", this.local_addr, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message unfragment(Message msg, FragHeader hdr) {
        ConcurrentMap tmp;
        Address sender = msg.getSrc();
        Message assembled_msg = null;
        ConcurrentMap<Long, FragEntry> frag_table = (ConcurrentMap<Long, FragEntry>)this.fragment_list.get(sender);
        if (frag_table == null && (tmp = this.fragment_list.putIfAbsent(sender, frag_table = Util.createConcurrentMap(16, 0.075f, 16))) != null) {
            frag_table = tmp;
        }
        this.num_frags_received.increment();
        FragEntry entry = (FragEntry)frag_table.get(hdr.id);
        if (entry == null) {
            entry = new FragEntry(hdr.num_frags, hdr.needs_deserialization, this.msg_factory);
            FragEntry tmp2 = frag_table.putIfAbsent(hdr.id, entry);
            if (tmp2 != null) {
                entry = tmp2;
            }
        }
        Lock lock = entry.lock;
        lock.lock();
        try {
            entry.set(hdr.frag_id, msg);
            if (entry.isComplete()) {
                assembled_msg = this.assembleMessage(entry.fragments, entry.needs_deserialization, hdr);
                frag_table.remove(hdr.id);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s: unfragmented message from %s (size=%d) from %d fragments", this.local_addr, sender, assembled_msg.getLength(), entry.number_of_frags_recvd);
                }
            }
        }
        catch (Exception ex) {
            this.log.error("%s: failed unfragmenting message: %s", this.local_addr, ex);
        }
        finally {
            lock.unlock();
        }
        return assembled_msg;
    }

    protected Message assembleMessage(Message[] fragments, boolean needs_deserialization, FragHeader hdr) throws Exception {
        int combined_length = 0;
        int index = 0;
        for (Message fragment : fragments) {
            combined_length += fragment.getLength();
        }
        byte[] combined_buffer = new byte[combined_length];
        Message retval = fragments[0].copy(false, true);
        for (int i = 0; i < fragments.length; ++i) {
            Message fragment;
            fragment = fragments[i];
            fragments[i] = null;
            byte[] tmp = fragment.getArray();
            int length = fragment.getLength();
            int offset = fragment.getOffset();
            System.arraycopy(tmp, offset, combined_buffer, index, length);
            index += length;
        }
        if (needs_deserialization) {
            retval = Util.messageFromBuffer(combined_buffer, 0, combined_buffer.length, this.msg_factory);
        } else {
            retval.setArray(combined_buffer, 0, combined_buffer.length);
        }
        return retval;
    }

    protected static class FragEntry {
        protected final Message[] fragments;
        protected int number_of_frags_recvd;
        protected final boolean needs_deserialization;
        protected final MessageFactory msg_factory;
        protected final Lock lock = new ReentrantLock();

        protected FragEntry(int tot_frags, boolean needs_deserialization, MessageFactory mf) {
            this.fragments = new Message[tot_frags];
            this.needs_deserialization = needs_deserialization;
            this.msg_factory = mf;
        }

        public void set(int frag_id, Message frag) {
            if (this.fragments[frag_id] == null) {
                this.fragments[frag_id] = frag;
                ++this.number_of_frags_recvd;
            }
        }

        public boolean isComplete() {
            if (this.number_of_frags_recvd < this.fragments.length) {
                return false;
            }
            for (Message msg : this.fragments) {
                if (msg != null) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return String.format("[tot_frags=%d, number_of_frags_recvd=%d]", this.fragments.length, this.number_of_frags_recvd);
        }
    }
}

