/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp.credentials;

import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ProjectCredentials;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;

class ServiceAccountPkcs8GcpCredentialFactory
extends GcpCredentialFactory {
    private final String projectId;
    private final String clientId;
    private final String clientEmail;
    private final String privateKeyPkcs8;
    private final String privateKeyId;
    private final Collection<String> scopes;
    private final HttpTransportFactory transportFactory;
    private final URI tokenServerUri;
    private final String serviceAccountUser;

    ServiceAccountPkcs8GcpCredentialFactory(String projectId, String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri, String serviceAccountUser) {
        this.projectId = projectId;
        this.clientId = clientId;
        this.clientEmail = clientEmail;
        this.privateKeyPkcs8 = privateKeyPkcs8;
        this.privateKeyId = privateKeyId;
        this.scopes = scopes;
        this.transportFactory = transportFactory;
        this.tokenServerUri = tokenServerUri;
        this.serviceAccountUser = serviceAccountUser;
    }

    @Override
    protected ProjectCredentials doCreate() {
        try {
            ServiceAccountCredentials serviceAccountCredentials = ServiceAccountCredentials.fromPkcs8((String)this.clientId, (String)this.clientEmail, (String)this.privateKeyPkcs8, (String)this.privateKeyId, this.scopes, (HttpTransportFactory)this.transportFactory, (URI)this.tokenServerUri, (String)this.serviceAccountUser);
            return new ProjectCredentials((Credentials)serviceAccountCredentials, this.projectId, this.clientEmail);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load private key for clientEmail " + this.clientEmail, e);
        }
    }

    @Override
    public String info() {
        return "PKCS8 key for clientEmail " + this.clientEmail;
    }
}

