/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import java.net.URI;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AwsEc2Authentication;
import org.springframework.vault.authentication.AwsEc2AuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.web.client.RestOperations;

public class AwsEc2ClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public AwsEc2ClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.AWS_EC2);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        VaultEnvironmentProperties.AwsEc2Properties awsEc2 = vaultProperties.getAwsEc2();
        AwsEc2AuthenticationOptions.Nonce nonce = StringUtils.hasText((String)awsEc2.getNonce()) ? AwsEc2AuthenticationOptions.Nonce.provided((char[])awsEc2.getNonce().toCharArray()) : AwsEc2AuthenticationOptions.Nonce.generated();
        AwsEc2AuthenticationOptions authenticationOptions = AwsEc2AuthenticationOptions.builder().role(awsEc2.getRole()).path(awsEc2.getAwsEc2Path()).nonce(nonce).identityDocumentUri(URI.create(awsEc2.getIdentityDocument())).build();
        return new AwsEc2Authentication(authenticationOptions, vaultRestOperations, externalRestOperations);
    }
}

