/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.deployit.plugin.api.services.ArtifactTransformerException;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.configuration.TransactionalStitchService;
import com.xebialabs.deployit.plugin.stitch.model.Processor;
import com.xebialabs.deployit.plugin.stitch.model.processor.MacroProcessor;
import com.xebialabs.deployit.plugin.stitch.model.processor.RuleProcessor;
import com.xebialabs.deployit.plugin.stitch.service.ChangeSet;
import com.xebialabs.deployit.plugin.stitch.service.DryRunProcessors;
import com.xebialabs.deployit.plugin.stitch.service.DryRunProcessors$;
import com.xebialabs.deployit.plugin.stitch.service.RuleProcessorService;
import com.xebialabs.deployit.plugin.stitch.service.RuleProcessorService$;
import com.xebialabs.deployit.plugin.stitch.service.engine.DefaultStitchEngine$;
import com.xebialabs.deployit.plugin.stitch.service.engine.ProcessorDiffPreview;
import com.xebialabs.deployit.plugin.stitch.service.engine.StitchEngine;
import com.xebialabs.deployit.plugin.stitch.service.engine.TransformPreview;
import com.xebialabs.deployit.plugin.stitch.service.engine.context.DeploymentContext;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.FormatResolver;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.input.InputAdapterRegistry;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.input.adapter.InputAdapter;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.output.OutputConsumerRegistry;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.output.consumer.OutputConsumer;
import com.xebialabs.deployit.plugin.stitch.service.engine.pipeline.ExecutionOutput;
import com.xebialabs.deployit.plugin.stitch.service.engine.pipeline.PipelineExecutor;
import com.xebialabs.deployit.plugin.stitch.service.engine.pipeline.VerboseExecutionOutput;
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.ObjectMapperFactory;
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.InputContextBuilder$;
import com.xebialabs.deployit.plugin.stitch.service.util.InputStreamUtils$;
import com.xebialabs.deployit.plugin.stitch.service.util.PipelineContextUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;

@Service(value="stitchEngine")
@Autowired
@TransactionalStitchService
@ScalaSignature(bytes="\u0006\u0005\r}q!B\u0013'\u0011\u0003)d!B\u001c'\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%\tA\u0011\u0005\u0007\u0017\u0006\u0001\u000b\u0011B\"\t\u000f1\u000b!\u0019!C\u0001\u0005\"1Q*\u0001Q\u0001\n\rCqAT\u0001C\u0002\u0013\u0005!\t\u0003\u0004P\u0003\u0001\u0006Ia\u0011\u0005\b!\u0006\u0011\r\u0011\"\u0001C\u0011\u0019\t\u0016\u0001)A\u0005\u0007\"9!+\u0001b\u0001\n\u0003\u0011\u0005BB*\u0002A\u0003%1\tC\u0004U\u0003\t\u0007I\u0011\u0001\"\t\rU\u000b\u0001\u0015!\u0003D\u0011\u001d1\u0016A1A\u0005\u0002\tCaaV\u0001!\u0002\u0013\u0019e\u0001B\u001c'\u0001aC\u0001\u0002Z\t\u0003\u0002\u0003\u0006I!\u001a\u0005\t[F\u0011\t\u0011)A\u0005]\"AA/\u0005B\u0001B\u0003%Q\u000f\u0003\u0005z#\t\u0005\t\u0015!\u0003{\u0011!q\u0018C!A!\u0002\u0013y\bBCA\u0006#\t\u0005\t\u0015!\u0003\u0002\u000e!1q(\u0005C\u0001\u00033Aq!!\u000b\u0012\t\u0003\nY\u0003C\u0005\u0002NF\t\n\u0011\"\u0001\u0002P\"9\u0011Q]\t\u0005\n\u0005\u001d\bb\u0002B\u0001#\u0011%!1\u0001\u0005\b\u00057\tB\u0011\u0002B\u000f\u0011\u001d\u0011I%\u0005C\u0005\u0005\u0017B\u0011Ba&\u0012#\u0003%IA!'\t\u0013\tu\u0015#%A\u0005\n\t}\u0005b\u0002B%#\u0011\u0005#q\u0015\u0005\b\u0005[\u000bB\u0011\tBX\u0011\u001d\u0011y,\u0005C!\u0005\u0003DqA!5\u0012\t\u0003\u0012\u0019.A\nEK\u001a\fW\u000f\u001c;Ti&$8\r[#oO&tWM\u0003\u0002(Q\u00051QM\\4j]\u0016T!!\u000b\u0016\u0002\u000fM,'O^5dK*\u00111\u0006L\u0001\u0007gRLGo\u00195\u000b\u00055r\u0013A\u00029mk\u001eLgN\u0003\u00020a\u0005AA-\u001a9m_fLGO\u0003\u00022e\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002g\u0005\u00191m\\7\u0004\u0001A\u0011a'A\u0007\u0002M\t\u0019B)\u001a4bk2$8\u000b^5uG\",enZ5oKN\u0011\u0011!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0014aI*uSR\u001c\u0007.\u00128hS:,\u0017I\u001d;jM\u0006\u001cG\u000f\u0016:b]N4wN]7fe:\u000bW.Z\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0005Y\u0006twMC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)+%AB*ue&tw-\u0001\u0013Ti&$8\r[#oO&tW-\u0011:uS\u001a\f7\r\u001e+sC:\u001chm\u001c:nKJt\u0015-\\3!\u0003\t\u0002&/\u001a)s_\u000e,7o]5oOR\u0013\u0018M\\:g_Jl\u0017\r^5p]\u001ac\u0017mZ&fs\u0006\u0019\u0003K]3Qe>\u001cWm]:j]\u001e$&/\u00198tM>\u0014X.\u0019;j_:4E.Y4LKf\u0004\u0013a\t)pgR\u0004&o\\2fgNLgn\u001a+sC:\u001chm\u001c:nCRLwN\u001c$mC\u001e\\U-_\u0001%!>\u001cH\u000f\u0015:pG\u0016\u001c8/\u001b8h)J\fgn\u001d4pe6\fG/[8o\r2\fwmS3zA\u0005\t\u0012J\u001c<pG\u0006$\u0018n\u001c8OC6,7*Z=\u0002%%sgo\\2bi&|gNT1nK.+\u0017\u0010I\u0001\u0015\t\u0016\u0004Hn\\=nK:$8i\u001c8uKb$h+\u0019:\u0002+\u0011+\u0007\u000f\\8z[\u0016tGoQ8oi\u0016DHOV1sA\u0005\u0001\u0002K]3Qe>\u001cWm]:j]\u001e4\u0016M]\u0001\u0012!J,\u0007K]8dKN\u001c\u0018N\\4WCJ\u0004\u0013!\u0005)pgR\u0004&o\\2fgNLgn\u001a,be\u0006\u0011\u0002k\\:u!J|7-Z:tS:<g+\u0019:!'\u0011\t\u0012(\u0017/\u0011\u0005YR\u0016BA.'\u00051\u0019F/\u001b;dQ\u0016sw-\u001b8f!\ti&-D\u0001_\u0015\ty\u0006-A\u0003tY\u001a$$NC\u0001b\u0003!9'/\u001b>{Y\u0016$\u0017BA2_\u0005\u001daunZ4j]\u001e\fA#\u001b8qkR\fE-\u00199uKJ\u0014VmZ5tiJL\bC\u00014l\u001b\u00059'B\u00015j\u0003\u0015Ig\u000e];u\u0015\tQg%\u0001\u0004g_Jl\u0017\r^\u0005\u0003Y\u001e\u0014A#\u00138qkR\fE-\u00199uKJ\u0014VmZ5tiJL\u0018AF8viB,HoQ8ogVlWM\u001d*fO&\u001cHO]=\u0011\u0005=\u0014X\"\u00019\u000b\u0005EL\u0017AB8viB,H/\u0003\u0002ta\n1r*\u001e;qkR\u001cuN\\:v[\u0016\u0014(+Z4jgR\u0014\u00180\u0001\bg_Jl\u0017\r\u001e*fg>dg/\u001a:\u0011\u0005Y<X\"A5\n\u0005aL'A\u0004$pe6\fGOU3t_24XM]\u0001\u0015eVdW\r\u0015:pG\u0016\u001c8o\u001c:TKJ4\u0018nY3\u0011\u0005mdX\"\u0001\u0015\n\u0005uD#\u0001\u0006*vY\u0016\u0004&o\\2fgN|'oU3sm&\u001cW-\u0001\tqSB,G.\u001b8f\u000bb,7-\u001e;peB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006\u0019\n\u0001\u0002]5qK2Lg.Z\u0005\u0005\u0003\u0013\t\u0019A\u0001\tQSB,G.\u001b8f\u000bb,7-\u001e;pe\u0006YQ.\u00199qKJ,F/\u001b7t!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nM\u0005I\u0001O]8dKN\u001cxN]\u0005\u0005\u0003/\t\tBA\nPE*,7\r^'baB,'OR1di>\u0014\u0018\u0010\u0006\b\u0002\u001c\u0005u\u0011qDA\u0011\u0003G\t)#a\n\u0011\u0005Y\n\u0002\"\u00023\u0019\u0001\u0004)\u0007\"B7\u0019\u0001\u0004q\u0007\"\u0002;\u0019\u0001\u0004)\b\"B=\u0019\u0001\u0004Q\b\"\u0002@\u0019\u0001\u0004y\bbBA\u00061\u0001\u0007\u0011QB\u0001\raJ|7-Z:t%VdWm\u001d\u000b\r\u0003[\ti)!(\u0002(\u0006M\u00161\u0019\u000b\u0007\u0003_\ti'! \u0011\u000fi\n\t$!\u000e\u0002Z%\u0019\u00111G\u001e\u0003\rQ+\b\u000f\\33!\u0019\t9$a\u0012\u0002N9!\u0011\u0011HA\"\u001d\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA i\u00051AH]8pizJ\u0011\u0001P\u0005\u0004\u0003\u000bZ\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\nYE\u0001\u0003MSN$(bAA#wA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T)\nQ!\\8eK2LA!a\u0016\u0002R\tI\u0001K]8dKN\u001cxN\u001d\t\t\u00037\n\u0019'!\u001b\u0002j9!\u0011QLA0!\r\tYdO\u0005\u0004\u0003CZ\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002f\u0005\u001d$aA'ba*\u0019\u0011\u0011M\u001e\u0011\t\u0005m\u00131N\u0005\u0004\u0015\u0006\u001d\u0004bBA83\u0001\u000f\u0011\u0011O\u0001\rS:\u0004X\u000f^!eCB$XM\u001d\t\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011qO4\u0002\u000f\u0005$\u0017\r\u001d;fe&!\u00111PA;\u00051Ie\u000e];u\u0003\u0012\f\u0007\u000f^3s\u0011\u001d\ty(\u0007a\u0002\u0003\u0003\u000bab\\;uaV$8i\u001c8tk6,'\u000f\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9\t]\u0001\tG>t7/^7fe&!\u00111RAC\u00059yU\u000f\u001e9vi\u000e{gn];nKJDq!a$\u001a\u0001\u0004\t\t*\u0001\u0004t_V\u00148-\u001a\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*\u0019\u0011qS$\u0002\u0005%|\u0017\u0002BAN\u0003+\u00131\"\u00138qkR\u001cFO]3b[\"9\u0011qT\rA\u0002\u0005\u0005\u0016a\u00033fgRLg.\u0019;j_:\u0004B!a%\u0002$&!\u0011QUAK\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d\tI+\u0007a\u0001\u0003W\u000bq\u0002]5qK2Lg.Z\"p]R,\u0007\u0010\u001e\t\t\u00037\n\u0019'!\u001b\u0002.B\u0019!(a,\n\u0007\u0005E6HA\u0002B]fD\u0011\"!.\u001a!\u0003\u0005\r!a.\u0002\u0013\rD\u0017M\\4f'\u0016$\b#\u0002\u001e\u0002:\u0006u\u0016bAA^w\t1q\n\u001d;j_:\u00042a_A`\u0013\r\t\t\r\u000b\u0002\n\u0007\"\fgnZ3TKRD\u0011\"!2\u001a!\u0003\u0005\r!a2\u0002\u001f\u0005$Gm\u00148Qe>\u001cWm]:peN\u00042a_Ae\u0013\r\tY\r\u000b\u0002\u0011\tJL(+\u001e8Qe>\u001cWm]:peN\fa\u0003\u001d:pG\u0016\u001c8OU;mKN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003#TC!a.\u0002T.\u0012\u0011Q\u001b\t\u0005\u0003/\f\t/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003%)hn\u00195fG.,GMC\u0002\u0002`n\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019/!7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0012hKRLe\u000e];u'>,(oY3CCN,Gm\u00148Qe\u0016\u0004&o\\2fgNLgn\u001a\u000b\u0007\u0003S\fi0a@\u0011\t\u0005-\u0018\u0011`\u0007\u0003\u0003[TA!a<\u0002r\u0006AA-\u0019;bE&tGM\u0003\u0003\u0002t\u0006U\u0018a\u00026bG.\u001cxN\u001c\u0006\u0004\u0003o\u0014\u0014!\u00034bgR,'\u000f_7m\u0013\u0011\tY0!<\u0003\u0011)\u001bxN\u001c(pI\u0016Dq!!+\u001c\u0001\u0004\tY\u000b\u0003\u0004i7\u0001\u0007\u0011\u0011^\u0001\u0016O\u0016$h)\u001b8bYB\u0013xnY3tg>\u0014H*[:u))\u0011)A!\u0005\u0003\u0014\tU!q\u0003\t\u0007\u0003o\t9Ea\u0002\u0011\t\t%!QB\u0007\u0003\u0005\u0017QA!a\u0005\u0002R%!!q\u0002B\u0006\u00055\u0011V\u000f\\3Qe>\u001cWm]:pe\"9\u0011\u0011\u0016\u000fA\u0002\u0005-\u0006bBAc9\u0001\u0007!Q\u0001\u0005\u0007Qr\u0001\r!!;\t\u000f\teA\u00041\u0001\u0003\u0006\u0005\u0011R\r_5ti&tw\r\u0015:pG\u0016\u001c8o\u001c:t\u0003i\u0001(o\\2fgN\u0014V\u000f\\3t/&$\bN\u0011:fC.\u0004x.\u001b8u)9\u0011yBa\u000b\u0003.\tE\"Q\u0007B\u001c\u0005\u000f\"bA!\t\u0003(\t%\u0002c\u0001\u001e\u0003$%\u0019!QE\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003_j\u00029AA9\u0011\u001d\ty(\ba\u0002\u0003\u0003Cq!a$\u001e\u0001\u0004\t\t\nC\u0004\u00030u\u0001\r!!)\u0002-A\u0014XM^5pkN$&/\u00198tM>\u0014X.\u0019;j_:DqAa\r\u001e\u0001\u0004\t\t+A\u000bdkJ\u0014XM\u001c;Ue\u0006t7OZ8s[\u0006$\u0018n\u001c8\t\u000f\u0005%V\u00041\u0001\u0002,\"9!\u0011H\u000fA\u0002\tm\u0012a\u00059s_\u000e,7o]8s\u0005J,\u0017m\u001b9pS:$\b\u0003\u0002B\u001f\u0005\u0007j!Aa\u0010\u000b\u0007\t\u0005s)\u0001\u0003vi&d\u0017\u0002\u0002B#\u0005\u007f\u0011A!V+J\t\"9\u0011QW\u000fA\u0002\u0005]\u0016!\u0003;sC:\u001chm\u001c:n+\u0011\u0011iEa\u0015\u0015!\t=#q\fB1\u0005S\u0012yH!#\u0003\u0014\nU\u0005\u0003\u0002B)\u0005'b\u0001\u0001B\u0004\u0003Vy\u0011\rAa\u0016\u0003\u0003Q\u000bBA!\u0017\u0002.B\u0019!Ha\u0017\n\u0007\tu3HA\u0004O_RD\u0017N\\4\t\u000f\u0005=e\u00041\u0001\u0002\u0012\"9!1\r\u0010A\u0002\t\u0015\u0014!\u0006;sC:\u001chm\u001c:nCRLwN\\\"p]R,\u0007\u0010\u001e\t\t\u0005{\u00119'!\u001b\u0002.&!\u0011Q\rB \u0011\u001d\u0011YG\ba\u0001\u0005[\nQB]3ukJt\u0007*\u00198eY\u0016\u0014\bc\u0003\u001e\u0003p\tM\u0014QGA-\u0005\u001fJ1A!\u001d<\u0005%1UO\\2uS>t7\u0007E\u0003;\u0005k\u0012I(C\u0002\u0003xm\u0012Q!\u0011:sCf\u00042A\u000fB>\u0013\r\u0011ih\u000f\u0002\u0005\u0005f$X\rC\u0004\u0003\u0002z\u0001\rAa!\u0002\u001dI,G/\u001e:o\u001fJLw-\u001b8bYB9!H!\"\u0003t\t=\u0013b\u0001BDw\tIa)\u001e8di&|g.\r\u0005\b\u0005\u0017s\u0002\u0019\u0001BG\u0003Q!WMZ1vYR\u0014Vm];mi\"\u000bg\u000e\u001a7feB)!Ha$\u0003P%\u0019!\u0011S\u001e\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\"CA[=A\u0005\t\u0019AA\\\u0011%\t)M\bI\u0001\u0002\u0004\t9-A\nue\u0006t7OZ8s[\u0012\"WMZ1vYR$c'\u0006\u0003\u0002P\nmEa\u0002B+?\t\u0007!qK\u0001\u0014iJ\fgn\u001d4pe6$C-\u001a4bk2$HeN\u000b\u0005\u0005C\u0013)+\u0006\u0002\u0003$*\"\u0011qYAj\t\u001d\u0011)\u0006\tb\u0001\u0005/\"b!!%\u0003*\n-\u0006bBAHC\u0001\u0007\u0011\u0011\u0013\u0005\b\u0005G\n\u0003\u0019\u0001B3\u0003A\u0001(/\u001a<jK^$&/\u00198tM>\u0014X\u000e\u0006\u0006\u00032\n]&\u0011\u0018B^\u0005{\u00032A\u000eBZ\u0013\r\u0011)L\n\u0002\u0011)J\fgn\u001d4pe6\u0004&/\u001a<jK^Dq!a$#\u0001\u0004\t\t\nC\u0004\u0003d\t\u0002\rA!\u001a\t\u0013\u0005U&\u0005%AA\u0002\u0005]\u0006\"CAcEA\u0005\t\u0019AAd\u0003Q\u0001(/\u001a<jK^\u0004&o\\2fgN|'\u000fR5gMRQ!1\u0019Be\u0005\u0017\u0014iMa4\u0011\u0007Y\u0012)-C\u0002\u0003H\u001a\u0012A\u0003\u0015:pG\u0016\u001c8o\u001c:ES\u001a4\u0007K]3wS\u0016<\bbBAHG\u0001\u0007\u0011\u0011\u0013\u0005\b\u0005G\u001a\u0003\u0019\u0001B3\u0011\u001d\u0011Id\ta\u0001\u0005wA\u0011\"!.$!\u0003\u0005\r!a.\u0002+A\u0014XM^5foJ+H.Z:Fm\u0006dW/\u0019;peR1\u0011Q\u0007Bk\u0005/Dq!a$%\u0001\u0004\t\t\nC\u0004\u0003d\u0011\u0002\rA!\u001a)\u0007E\u0011Y\u000e\u0005\u0003\u0003^\n-XB\u0001Bp\u0015\u0011\u0011\tOa9\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0015\u0011\u0011)Oa:\u0002\u0007)\u0004\u0018MC\u0002\u0003j*\n1\u0001Z1p\u0013\u0011\u0011iOa8\u00035Q\u0013\u0018M\\:bGRLwN\\1m'RLGo\u00195TKJ4\u0018nY3)\u0007E\u0011\t\u0010\u0005\u0003\u0003t\u000e\u001dQB\u0001B{\u0015\u0011\tyNa>\u000b\t\te(1`\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\u0011iPa@\u0002\u000b\t,\u0017M\\:\u000b\t\r\u000511A\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u00111QA\u0001\u0004_J<\u0017\u0002BB\u0005\u0005k\u0014\u0011\"Q;u_^L'/\u001a3)\u000fE\u0019ia!\u0007\u0004\u001cA!1qBB\u000b\u001b\t\u0019\tB\u0003\u0003\u0004\u0014\t}\u0018AC:uKJ,w\u000e^=qK&!1qCB\t\u0005\u001d\u0019VM\u001d<jG\u0016\fQA^1mk\u0016\f#a!\b\u0002\u0019M$\u0018\u000e^2i\u000b:<\u0017N\\3")
public class DefaultStitchEngine
implements StitchEngine,
Logging {
    private final InputAdapterRegistry inputAdapterRegistry;
    private final OutputConsumerRegistry outputConsumerRegistry;
    private final FormatResolver formatResolver;
    private final RuleProcessorService ruleProcessorService;
    private final PipelineExecutor pipelineExecutor;
    private final ObjectMapperFactory mapperUtils;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String PostProcessingVar() {
        return DefaultStitchEngine$.MODULE$.PostProcessingVar();
    }

    public static String PreProcessingVar() {
        return DefaultStitchEngine$.MODULE$.PreProcessingVar();
    }

    public static String DeploymentContextVar() {
        return DefaultStitchEngine$.MODULE$.DeploymentContextVar();
    }

    public static String InvocationNameKey() {
        return DefaultStitchEngine$.MODULE$.InvocationNameKey();
    }

    public static String PostProcessingTransformationFlagKey() {
        return DefaultStitchEngine$.MODULE$.PostProcessingTransformationFlagKey();
    }

    public static String PreProcessingTransformationFlagKey() {
        return DefaultStitchEngine$.MODULE$.PreProcessingTransformationFlagKey();
    }

    public static String StitchEngineArtifactTransformerName() {
        return DefaultStitchEngine$.MODULE$.StitchEngineArtifactTransformerName();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DryRunProcessors processRules$default$5() {
        return StitchEngine.processRules$default$5$(this);
    }

    @Override
    public Option<ChangeSet> previewTransform$default$3() {
        return StitchEngine.previewTransform$default$3$(this);
    }

    @Override
    public DryRunProcessors previewTransform$default$4() {
        return StitchEngine.previewTransform$default$4$(this);
    }

    @Override
    public Option<ChangeSet> previewProcessorDiff$default$4() {
        return StitchEngine.previewProcessorDiff$default$4$(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultStitchEngine defaultStitchEngine = this;
        synchronized (defaultStitchEngine) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public Tuple2<List<Processor>, scala.collection.immutable.Map<String, String>> processRules(InputStream source, OutputStream destination, scala.collection.immutable.Map<String, Object> pipelineContext, Option<ChangeSet> changeSet, DryRunProcessors addOnProcessors, InputAdapter inputAdapter, OutputConsumer outputConsumer) {
        this.logger().trace((Function0 & Serializable)() -> "Searching for stitch processor...");
        Tuple2<InputStream, InputStream> tuple2 = InputStreamUtils$.MODULE$.cloneInputStream(source);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InputStream clonedSource = (InputStream)tuple2._1();
        InputStream originalSource = (InputStream)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)clonedSource, (Object)originalSource);
        InputStream clonedSource2 = (InputStream)tuple22._1();
        InputStream originalSource2 = (InputStream)tuple22._2();
        Try try_ = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
            InputStream source = (InputStream)use.apply((Object)clonedSource2, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            InputStream managedOriginalSource = (InputStream)use.apply((Object)originalSource2, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            JsonNode input = inputAdapter.convert(source);
            Tuple3<DeploymentContext, Object, Object> tuple3 = PipelineContextUtils$.MODULE$.extractVariablesFromPipelineContext(pipelineContext);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            DeploymentContext deploymentContext = (DeploymentContext)tuple3._1();
            boolean preProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean postProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)deploymentContext, (Object)BoxesRunTime.boxToBoolean((boolean)preProcessing), (Object)BoxesRunTime.boxToBoolean((boolean)postProcessing));
            DeploymentContext deploymentContext2 = (DeploymentContext)tuple32._1();
            boolean preProcessing2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
            boolean postProcessing2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
            List<RuleProcessor> existingProcessors = $this.ruleProcessorService.getOrderedProcessorsForContext(InputContextBuilder$.MODULE$.build(input), pipelineContext, changeSet);
            List<RuleProcessor> processors = this.getFinalProcessorList(pipelineContext, addOnProcessors.ruleProcessors(), input, existingProcessors);
            this.logger().info((Function0 & Serializable)() -> "Total of " + processors.length() + " stitch processors will be applied to the input.");
            this.logger().debug((Function0 & Serializable)() -> "Stitch processors found: " + processors + ". Executing on input:\n" + input.toPrettyString() + ".");
            if (processors.isEmpty()) {
                Integer n;
                if (preProcessing2 || postProcessing2) {
                    this.logger().debug((Function0 & Serializable)() -> "Pre/post processing processors execution wasn't triggered, returning empty array as result.");
                    outputConsumer.write((JsonNode)$this.mapperUtils.mapper().createArrayNode(), destination);
                    n = BoxedUnit.UNIT;
                } else {
                    this.logger().debug((Function0 & Serializable)() -> "Processors execution wasn't triggered, leaving input unchanged");
                    n = BoxesRunTime.boxToInteger((int)IOUtils.copy((InputStream)managedOriginalSource, (OutputStream)destination));
                }
                return new Tuple2(processors, (Object)Predef$.MODULE$.Map().empty());
            }
            JsonNode x$1 = this.getInputSourceBasedOnPreProcessing(pipelineContext, input);
            List<RuleProcessor> x$2 = processors;
            DeploymentContext x$3 = deploymentContext2;
            scala.collection.immutable.Map<String, List<MacroProcessor>> x$4 = addOnProcessors.macroProcessors();
            scala.collection.mutable.Map<String, Object> x$5 = $this.pipelineExecutor.execute$default$4();
            ExecutionOutput executionResult = $this.pipelineExecutor.execute(x$1, x$2, x$3, x$5, x$4);
            this.logger().debug((Function0 & Serializable)() -> "Processors executed, finished with result:\n" + executionResult.result().toPrettyString());
            int errorSize = executionResult.processorErrors().size();
            this.logger().info((Function0 & Serializable)() -> "Total of " + (processors.length() - errorSize) + " stitch processors applied. Total of " + errorSize + " erred stitch processors.");
            outputConsumer.write(executionResult.result(), destination);
            return new Tuple2(processors, executionResult.processorErrors());
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple2 result = (Tuple2)success.value();
            return result;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public Option<ChangeSet> processRules$default$4() {
        return None$.MODULE$;
    }

    private JsonNode getInputSourceBasedOnPreProcessing(scala.collection.immutable.Map<String, Object> pipelineContext, JsonNode input) {
        Tuple3<DeploymentContext, Object, Object> tuple3 = PipelineContextUtils$.MODULE$.extractVariablesFromPipelineContext(pipelineContext);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        boolean preProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        boolean postProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(preProcessing, postProcessing);
        boolean preProcessing2 = sp2._1$mcZ$sp();
        boolean postProcessing2 = sp2._2$mcZ$sp();
        if (preProcessing2 || postProcessing2) {
            return this.mapperUtils.mapper().createArrayNode();
        }
        return input;
    }

    private List<RuleProcessor> getFinalProcessorList(scala.collection.immutable.Map<String, Object> pipelineContext, List<RuleProcessor> addOnProcessors, JsonNode input, List<RuleProcessor> existingProcessors) {
        List<RuleProcessor> list;
        List<RuleProcessor> list2 = addOnProcessors;
        if (list2 != null && (list = list2).nonEmpty()) {
            List<RuleProcessor> filterProcessor;
            List<RuleProcessor> list3 = filterProcessor = this.ruleProcessorService.getFilteredAddOnProcessors(InputContextBuilder$.MODULE$.build(input), pipelineContext, list);
            List finalProcessorList = existingProcessors.$colon$colon$colon(list3);
            return (List)finalProcessorList.sortBy((Function1 & Serializable)p -> new Tuple4(p.phase().getOrElse((Function0 & Serializable)() -> RuleProcessorService$.MODULE$.DefaultPhase()), p.weight().getOrElse((Function0 & Serializable)() -> RuleProcessorService$.MODULE$.DefaultWeight()), (Object)p.rule().name(), (Object)BoxesRunTime.boxToInteger((int)p.order())), Ordering$.MODULE$.Tuple4(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), (Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        }
        return existingProcessors;
    }

    private void processRulesWithBreakpoint(InputStream source, OutputStream previousTransformation, OutputStream currentTransformation, scala.collection.immutable.Map<String, Object> pipelineContext, UUID processorBreakpoint, Option<ChangeSet> changeSet, InputAdapter inputAdapter, OutputConsumer outputConsumer) {
        JsonNode input = inputAdapter.convert(source);
        Tuple3<DeploymentContext, Object, Object> tuple3 = PipelineContextUtils$.MODULE$.extractVariablesFromPipelineContext(pipelineContext);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        DeploymentContext deploymentContext = (DeploymentContext)tuple3._1();
        boolean preProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        Tuple2 tuple2 = new Tuple2((Object)deploymentContext, (Object)BoxesRunTime.boxToBoolean((boolean)preProcessing));
        DeploymentContext deploymentContext2 = (DeploymentContext)tuple2._1();
        boolean preProcessing2 = tuple2._2$mcZ$sp();
        List<RuleProcessor> existingProcessors = this.ruleProcessorService.getOrderedProcessorsForContext(InputContextBuilder$.MODULE$.build(input), pipelineContext, changeSet);
        List<RuleProcessor> processors = this.getFinalProcessorList(pipelineContext, (List<RuleProcessor>)package$.MODULE$.List().empty(), input, existingProcessors);
        int breakpointIndex = processors.indexWhere((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DefaultStitchEngine.$anonfun$processRulesWithBreakpoint$1(processorBreakpoint, x$5))) + 1;
        List<RuleProcessor> preBreakpointProcessors = preProcessing2 && ((Object)BoxesRunTime.boxToInteger((int)breakpointIndex)).equals(BoxesRunTime.boxToInteger((int)0)) ? processors : processors.take(breakpointIndex);
        this.logger().info((Function0 & Serializable)() -> "Total of " + preBreakpointProcessors.length() + " out of " + processors.length() + " stitch processors will be applied to the input to generate preview with processor breakpoint.");
        VerboseExecutionOutput executionResult = this.pipelineExecutor.verboseExecute(this.getInputSourceBasedOnPreProcessing(pipelineContext, input), preBreakpointProcessors, deploymentContext2, this.pipelineExecutor.verboseExecute$default$4(), this.pipelineExecutor.verboseExecute$default$5());
        outputConsumer.write(executionResult.input(), previousTransformation);
        outputConsumer.write(executionResult.result(), currentTransformation);
    }

    private <T> T transform(InputStream source, Map<String, Object> transformationContext, Function3<byte[], List<Processor>, scala.collection.immutable.Map<String, String>, T> returnHandler, Function1<byte[], T> returnOriginal, Function0<T> defaultResultHandler, Option<ChangeSet> changeSet, DryRunProcessors addOnProcessors) {
        if (source.available() > 0) {
            Try try_ = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                InputStream origin = (InputStream)use.apply((Object)source, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                return InputStreamUtils$.MODULE$.cloneInputStreamToString(origin);
            });
            if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Tuple2 result = (Tuple2)success.value();
            Tuple2 tuple2 = result;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream duplicateIS = (InputStream)tuple2._1();
            String originalDocument = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)duplicateIS, (Object)originalDocument);
            InputStream duplicateIS2 = (InputStream)tuple22._1();
            String originalDocument2 = (String)tuple22._2();
            boolean bl = false;
            Failure failure = null;
            Try try_2 = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                InputStream managedSource = (InputStream)use.apply((Object)duplicateIS2, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                String format = $this.formatResolver.resolve((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(transformationContext).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                InputAdapter inputAdapter = $this.inputAdapterRegistry.adapterFor(format);
                OutputConsumer outputConsumer = $this.outputConsumerRegistry.consumerFor(format);
                Tuple2<List<Processor>, scala.collection.immutable.Map<String, String>> tuple2 = this.processRules(managedSource, output, PipelineContextUtils$.MODULE$.getPipelineContext(transformationContext), changeSet, addOnProcessors, inputAdapter, outputConsumer);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                List processors = (List)tuple2._1();
                scala.collection.immutable.Map exceptions = (scala.collection.immutable.Map)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)processors, (Object)exceptions);
                List processors2 = (List)tuple22._1();
                scala.collection.immutable.Map exceptions2 = (scala.collection.immutable.Map)tuple22._2();
                return returnHandler.apply((Object)output.toByteArray(), (Object)processors2, (Object)exceptions2);
            });
            if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                Object result2 = success2.value();
                return (T)result2;
            }
            if (try_2 instanceof Failure) {
                bl = true;
                failure = (Failure)try_2;
                Throwable e = failure.exception();
                if (e instanceof ArtifactTransformerException) {
                    ArtifactTransformerException artifactTransformerException = (ArtifactTransformerException)e;
                    this.warn((Function0<Object>)(Function0 & Serializable)() -> "Transformation context was not valid: " + artifactTransformerException.message() + " - returning original input stream");
                    return (T)returnOriginal.apply((Object)originalDocument2.getBytes());
                }
            }
            if (bl) {
                Throwable e = failure.exception();
                this.warn((Function0<Object>)(Function0 & Serializable)() -> "Exception occurred during the stitch transformation with error message:\n " + e.getMessage() + " - returning non-transformed object", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw (Throwable)Option$.MODULE$.apply((Object)ExceptionUtils.getRootCause((Throwable)e)).getOrElse((Function0 & Serializable)() -> e);
            }
            throw new MatchError((Object)try_2);
        }
        this.warn((Function0<Object>)(Function0 & Serializable)() -> "InputStream is empty, transformation not applied - returning original input stream");
        return (T)defaultResultHandler.apply();
    }

    public InputStream transform(InputStream source, Map<String, Object> transformationContext) {
        return (InputStream)this.transform(source, transformationContext, (Function3 & Serializable)(output, x$8, x$9) -> new ByteArrayInputStream((byte[])output), (Function1 & Serializable)originalDocument -> new ByteArrayInputStream((byte[])originalDocument), (Function0 & Serializable)() -> source, this.transform$default$6(), this.transform$default$7());
    }

    private <T> Option<ChangeSet> transform$default$6() {
        return None$.MODULE$;
    }

    private <T> DryRunProcessors transform$default$7() {
        return new DryRunProcessors(DryRunProcessors$.MODULE$.apply$default$1(), DryRunProcessors$.MODULE$.apply$default$2());
    }

    @Override
    public TransformPreview previewTransform(InputStream source, Map<String, Object> transformationContext, Option<ChangeSet> changeSet, DryRunProcessors addOnProcessors) {
        return (TransformPreview)this.transform(source, transformationContext, (Function3 & Serializable)(output, processors, errorProcessors) -> new TransformPreview(new ByteArrayInputStream((byte[])output), (List<Processor>)processors, (scala.collection.immutable.Map<String, String>)errorProcessors), (Function1 & Serializable)originalDocument -> new TransformPreview(new ByteArrayInputStream((byte[])originalDocument), (List<Processor>)Nil$.MODULE$, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), (Function0 & Serializable)() -> new TransformPreview(source, (List<Processor>)Nil$.MODULE$, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), changeSet, addOnProcessors);
    }

    @Override
    public ProcessorDiffPreview previewProcessorDiff(InputStream source, Map<String, Object> transformationContext, UUID processorBreakpoint, Option<ChangeSet> changeSet) {
        Try try_ = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
            ByteArrayOutputStream previousOutput = (ByteArrayOutputStream)use.apply((Object)new ByteArrayOutputStream(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            ByteArrayOutputStream currentOutput = (ByteArrayOutputStream)use.apply((Object)new ByteArrayOutputStream(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            String format = $this.formatResolver.resolve((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(transformationContext).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            InputAdapter inputAdapter = $this.inputAdapterRegistry.adapterFor(format);
            OutputConsumer outputConsumer = $this.outputConsumerRegistry.consumerFor(format);
            this.processRulesWithBreakpoint(source, previousOutput, currentOutput, PipelineContextUtils$.MODULE$.getPipelineContext(transformationContext), processorBreakpoint, changeSet, inputAdapter, outputConsumer);
            return new ProcessorDiffPreview(new ByteArrayInputStream(previousOutput.toByteArray()), new ByteArrayInputStream(currentOutput.toByteArray()));
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ProcessorDiffPreview result = (ProcessorDiffPreview)success.value();
            return result;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Exception occurred during preview processing with error message " + e.getMessage() + " - returning non-transformed object");
            throw (Throwable)Option$.MODULE$.apply((Object)ExceptionUtils.getRootCause((Throwable)e)).getOrElse((Function0 & Serializable)() -> e);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public List<Processor> previewRulesEvaluator(InputStream source, Map<String, Object> transformationContext) {
        String format = this.formatResolver.resolve((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(transformationContext).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        InputAdapter inputAdapter = this.inputAdapterRegistry.adapterFor(format);
        return this.ruleProcessorService.getOrderedProcessorsForContext(InputContextBuilder$.MODULE$.build(inputAdapter, source), PipelineContextUtils$.MODULE$.getPipelineContext(transformationContext), this.ruleProcessorService.getOrderedProcessorsForContext$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$processRulesWithBreakpoint$1(UUID processorBreakpoint$1, RuleProcessor x$5) {
        UUID uUID = x$5.id();
        UUID uUID2 = processorBreakpoint$1;
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public DefaultStitchEngine(InputAdapterRegistry inputAdapterRegistry, OutputConsumerRegistry outputConsumerRegistry, FormatResolver formatResolver, RuleProcessorService ruleProcessorService, PipelineExecutor pipelineExecutor, ObjectMapperFactory mapperUtils) {
        this.inputAdapterRegistry = inputAdapterRegistry;
        this.outputConsumerRegistry = outputConsumerRegistry;
        this.formatResolver = formatResolver;
        this.ruleProcessorService = ruleProcessorService;
        this.pipelineExecutor = pipelineExecutor;
        this.mapperUtils = mapperUtils;
        Logging.$init$((Logging)this);
    }
}

