/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.akka.serialization.kryo;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.unsafe.UnsafeInput;
import com.esotericsoftware.kryo.unsafe.UnsafeOutput;
import java.io.NotSerializableException;
import java.nio.ByteBuffer;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005-e!\u0002\r\u001a\u0001e\u0019\u0003\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\t\u0011y\u0002!\u0011!Q\u0001\nUB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003B\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00115\u0003!Q1A\u0005\u0002!C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"Aa\u000b\u0001B\u0001B\u0003%q\u000bC\u0003^\u0001\u0011\u0005a\fC\u0003j\u0001\u0011\u0005\u0001\tC\u0003k\u0001\u0011\u00053\u000eC\u0003k\u0001\u0011\u0005C\u000fC\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002H!I\u0011Q\u000b\u0001C\u0002\u0013%\u0011q\u000b\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002Z!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003[\u0002A\u0011BA=\u0005UY%/_8TKJL\u0017\r\\5{KJ\u0014\u0015mY6f]\u0012T!AG\u000e\u0002\t-\u0014\u0018p\u001c\u0006\u00039u\tQb]3sS\u0006d\u0017N_1uS>t'B\u0001\u0010 \u0003\u0011\t7n[1\u000b\u0005\u0001\n\u0013!B1mi>|'\"\u0001\u0012\u0002\u0005%|7\u0003\u0002\u0001%UA\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#B\u0001\u000f.\u0015\u0005q\u0012BA\u0018-\u0005)\u0019VM]5bY&TXM\u001d\t\u0003WEJ!A\r\u0017\u0003)\tKH/\u001a\"vM\u001a,'oU3sS\u0006d\u0017N_3s\u0007\u0001)\u0012!\u000e\t\u0003mqj\u0011a\u000e\u0006\u00035aR!!\u000f\u001e\u0002!\u0015\u001cx\u000e^3sS\u000e\u001cxN\u001a;xCJ,'\"A\u001e\u0002\u0007\r|W.\u0003\u0002>o\t!1J]=p\u0003\u0015Y'/_8!\u0003)\u0011WO\u001a4feNK'0Z\u000b\u0002\u0003B\u0011QEQ\u0005\u0003\u0007\u001a\u00121!\u00138u\u0003-\u0011WO\u001a4feNK'0\u001a\u0011\u0002\u001b5\f\u0007PQ;gM\u0016\u00148+\u001b>f\u00039i\u0017\r\u001f\"vM\u001a,'oU5{K\u0002\nq\"\u001b8dYV$W-T1oS\u001a,7\u000f^\u000b\u0002\u0013B\u0011QES\u0005\u0003\u0017\u001a\u0012qAQ8pY\u0016\fg.\u0001\tj]\u000edW\u000fZ3NC:Lg-Z:uA\u0005IQo]3V]N\fg-Z\u0001\u000bkN,WK\\:bM\u0016\u0004\u0013AB:zgR,W\u000e\u0005\u0002R)6\t!K\u0003\u0002T[\u0005)\u0011m\u0019;pe&\u0011QK\u0015\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\u0004Y><\u0007C\u0001-\\\u001b\u0005I&B\u0001..\u0003\u0015)g/\u001a8u\u0013\ta\u0016L\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\rqJg.\u001b;?)\u0019yF-\u001a4hQR\u0019\u0001MY2\u0011\u0005\u0005\u0004Q\"A\r\t\u000b=k\u0001\u0019\u0001)\t\u000bYk\u0001\u0019A,\t\u000bii\u0001\u0019A\u001b\t\u000b}j\u0001\u0019A!\t\u000b\u0015k\u0001\u0019A!\t\u000b\u001dk\u0001\u0019A%\t\u000b5k\u0001\u0019A%\u0002\u0015%$WM\u001c;jM&,'/\u0001\u0005u_\nKg.\u0019:z)\ta'\u000fE\u0002&[>L!A\u001c\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0015\u0002\u0018BA9'\u0005\u0011\u0011\u0015\u0010^3\t\u000bM|\u0001\u0019\u0001\u0013\u0002\u0007=\u0014'\u000eF\u0002vqf\u0004\"!\n<\n\u0005]4#\u0001B+oSRDQa\u001d\tA\u0002\u0011BQA\u001f\tA\u0002m\f1AY;g!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0004]&|'BAA\u0001\u0003\u0011Q\u0017M^1\n\u0007\u0005\u0015QP\u0001\u0006CsR,')\u001e4gKJ\f!B\u001a:p[\nKg.\u0019:z)\u0015!\u00131BA\b\u0011\u0019\ti!\u0005a\u0001Y\u0006)!-\u001f;fg\"9\u0011\u0011C\tA\u0002\u0005M\u0011!B2mCjT\b#B\u0013\u0002\u0016\u0005e\u0011bAA\fM\t1q\n\u001d;j_:\u0004D!a\u0007\u00026A1\u0011QDA\u0016\u0003cqA!a\b\u0002(A\u0019\u0011\u0011\u0005\u0014\u000e\u0005\u0005\r\"bAA\u0013g\u00051AH]8pizJ1!!\u000b'\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\u0015\u0019E.Y:t\u0015\r\tIC\n\t\u0005\u0003g\t)\u0004\u0004\u0001\u0005\u0019\u0005]\u0012qBA\u0001\u0002\u0003\u0015\t!!\u000f\u0003\u0007}#\u0013'\u0005\u0003\u0002<\u0005\u0005\u0003cA\u0013\u0002>%\u0019\u0011q\b\u0014\u0003\u000f9{G\u000f[5oOB\u0019Q%a\u0011\n\u0007\u0005\u0015cEA\u0002B]f$R\u0001JA%\u0003\u0017BQA\u001f\nA\u0002mDq!!\u0014\u0013\u0001\u0004\ty%\u0001\u0005nC:Lg-Z:u!\u0011\ti\"!\u0015\n\t\u0005M\u0013q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0002\r=,H\u000f];u+\t\tI\u0006\u0005\u0003\u0002\\\u0005}SBAA/\u0015\t\u0011s'\u0003\u0003\u0002b\u0005u#AB(viB,H/A\u0004pkR\u0004X\u000f\u001e\u0011\u0002\u0013\u001d,GoT;uaV$H\u0003BA-\u0003SBa!a\u001b\u0016\u0001\u0004Y\u0018A\u00022vM\u001a,'/\u0001\u0005hKRLe\u000e];u)\u0011\t\t(a\u001e\u0011\t\u0005m\u00131O\u0005\u0005\u0003k\niFA\u0003J]B,H\u000f\u0003\u0004\u0002\u000eY\u0001\r\u0001\u001c\u000b\u0005\u0003c\nY\b\u0003\u0004\u0002l]\u0001\ra\u001f\u0015\u0004\u0001\u0005}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015U&\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0004\nY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public class KryoSerializerBackend
implements Serializer,
ByteBufferSerializer {
    private final Kryo kryo;
    private final int bufferSize;
    private final int maxBufferSize;
    private final boolean includeManifest;
    private final boolean useUnsafe;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Output output;

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public Kryo kryo() {
        return this.kryo;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public int maxBufferSize() {
        return this.maxBufferSize;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    public boolean useUnsafe() {
        return this.useUnsafe;
    }

    public int identifier() {
        return 12454323;
    }

    public byte[] toBinary(Object obj) {
        byte[] byArray;
        Output buffer = this.output();
        try {
            try {
                if (this.includeManifest()) {
                    this.kryo().writeObject(buffer, obj);
                } else {
                    this.kryo().writeClassAndObject(buffer, obj);
                }
                byArray = buffer.toBytes();
            }
            catch (Throwable throwable) {
                if (throwable instanceof StackOverflowError) {
                    StackOverflowError stackOverflowError = (StackOverflowError)throwable;
                    if (!this.kryo().getReferences()) {
                        this.log.error((Throwable)stackOverflowError, "Could not serialize class with potentially circular references: {}", obj);
                        throw new RuntimeException(new StringBuilder(62).append("Could not serialize class with potential circular references: ").append(obj).toString());
                    }
                }
                throw throwable;
            }
        }
        finally {
            buffer.reset();
        }
        return byArray;
    }

    public void toBinary(Object obj, ByteBuffer buf) {
        ByteBufferOutput buffer = new ByteBufferOutput(buf);
        try {
            if (this.includeManifest()) {
                this.kryo().writeObject((Output)buffer, obj);
            } else {
                this.kryo().writeClassAndObject((Output)buffer, obj);
            }
            buffer.toBytes();
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof StackOverflowError) {
                StackOverflowError stackOverflowError = (StackOverflowError)throwable;
                if (!this.kryo().getReferences()) {
                    this.log.error((Throwable)stackOverflowError, "Could not serialize class with potentially circular references: {}", obj);
                    throw new RuntimeException(new StringBuilder(62).append("Could not serialize class with potential circular references: ").append(obj).toString());
                }
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) {
        try (Input buffer = this.getInput(bytes);){
            Object object;
            if (this.includeManifest()) {
                if (!(clazz instanceof Some)) throw new RuntimeException("Object of unknown class cannot be deserialized");
                Class c = (Class)((Some)clazz).value();
                object = this.kryo().readObject(buffer, c);
                return object;
            } else {
                object = this.kryo().readClassAndObject(buffer);
            }
            return object;
        }
    }

    public Object fromBinary(ByteBuffer buf, String manifest) {
        ByteBufferInput buffer = new ByteBufferInput(buf);
        Try clazz = this.system.dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
        if (this.includeManifest()) {
            if (clazz instanceof Success) {
                Class c = (Class)((Success)clazz).value();
                return this.kryo().readObject((Input)buffer, c);
            }
            throw new RuntimeException("Object of unknown class cannot be deserialized");
        }
        return this.kryo().readClassAndObject((Input)buffer);
    }

    private Output output() {
        return this.output;
    }

    private Output getOutput(ByteBuffer buffer) {
        return new ByteBufferOutput(buffer);
    }

    private Input getInput(byte[] bytes) {
        if (this.useUnsafe()) {
            return new UnsafeInput(bytes);
        }
        return new Input(bytes);
    }

    private Input getInput(ByteBuffer buffer) {
        return new ByteBufferInput(buffer);
    }

    public KryoSerializerBackend(Kryo kryo, int bufferSize, int maxBufferSize, boolean includeManifest, boolean useUnsafe, ExtendedActorSystem system, LoggingAdapter log) {
        this.kryo = kryo;
        this.bufferSize = bufferSize;
        this.maxBufferSize = maxBufferSize;
        this.includeManifest = includeManifest;
        this.useUnsafe = useUnsafe;
        this.system = system;
        this.log = log;
        Serializer.$init$((Serializer)this);
        this.output = useUnsafe ? new UnsafeOutput(bufferSize, maxBufferSize) : new Output(bufferSize, maxBufferSize);
    }
}

