/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryMetadata;
import org.infinispan.persistence.sifs.FileProvider;

public class EntryRecord {
    private final EntryHeader header;
    private final byte[] key;
    private byte[] value;
    private EntryMetadata meta;
    private byte[] internalMetadata;

    EntryRecord(EntryHeader header, byte[] key) {
        this.header = header;
        this.key = key;
    }

    public EntryHeader getHeader() {
        return this.header;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getMetadata() {
        return this.meta == null ? null : this.meta.getBytes();
    }

    public byte[] getInternalMetadata() {
        return this.internalMetadata;
    }

    public byte[] getValue() {
        return this.value;
    }

    public long getCreated() {
        return this.meta == null ? -1L : this.meta.getCreated();
    }

    public long getLastUsed() {
        return this.meta == null ? -1L : this.meta.getLastUsed();
    }

    public String toString() {
        return "EntryRecord{header=" + this.header + ", key=" + Util.printArray((byte[])this.key) + ", value=" + Util.printArray((byte[])this.value) + ", meta=" + this.meta + ", internalMetadata=" + Util.printArray((byte[])this.internalMetadata) + "}";
    }

    public EntryRecord loadMetadataAndValue(FileProvider.Handle handle, int offset, boolean saveValue) throws IOException {
        this.loadMetadata(handle, offset);
        byte[] readValue = null;
        if (this.value == null) {
            readValue = EntryRecord.readValue(handle, this.header, offset);
            if (saveValue) {
                this.value = readValue;
            }
        }
        if (this.internalMetadata == null && this.header.internalMetadataLength() > 0) {
            this.internalMetadata = EntryRecord.readInternalMetadata(handle, this.header, offset);
        }
        if (this.value == null) {
            assert (!saveValue);
            assert (readValue != null);
            EntryRecord copyRecord = new EntryRecord(this.header, this.key);
            copyRecord.meta = this.meta;
            copyRecord.internalMetadata = this.internalMetadata;
            copyRecord.value = readValue;
            return copyRecord;
        }
        return this;
    }

    public EntryRecord loadMetadata(FileProvider.Handle handle, int offset) throws IOException {
        if (this.meta == null && this.header.metadataLength() > 0) {
            this.meta = EntryRecord.readMetadata(handle, this.header, offset);
        }
        return this;
    }

    public static EntryHeader readEntryHeader(FileProvider.Handle handle, long offset) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(27);
        if (EntryRecord.read(handle, header, offset, 27) < 0) {
            return null;
        }
        header.flip();
        try {
            return new EntryHeader(header);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Error reading from " + handle.getFileId() + ":" + offset, e);
        }
    }

    public static EntryHeader read10_1EntryHeader(FileProvider.Handle handle, long offset) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(24);
        if (EntryRecord.read(handle, header, offset, 24) < 0) {
            return null;
        }
        header.flip();
        try {
            return new EntryHeader(header, true);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Error reading from " + handle.getFileId() + ":" + offset, e);
        }
    }

    public static byte[] readKey(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        byte[] key = new byte[header.keyLength()];
        if (EntryRecord.read(handle, ByteBuffer.wrap(key), offset + (long)header.getHeaderLength(), header.keyLength()) < 0) {
            return null;
        }
        return key;
    }

    public static EntryMetadata readMetadata(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        assert (header.metadataLength() > 0);
        offset += (long)(header.getHeaderLength() + header.keyLength());
        int metaLength = header.metadataLength() - 16;
        assert (metaLength > 0);
        byte[] metadata = new byte[metaLength];
        if (EntryRecord.read(handle, ByteBuffer.wrap(metadata), offset, metaLength) < 0) {
            throw new IllegalStateException("End of file reached when reading metadata on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        if (EntryRecord.read(handle, buffer, offset += (long)metaLength, 16) < 0) {
            throw new IllegalStateException("End of file reached when reading timestamps on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        buffer.flip();
        return new EntryMetadata(metadata, buffer.getLong(), buffer.getLong());
    }

    public static byte[] readInternalMetadata(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        int length = header.internalMetadataLength();
        assert (length > 0);
        byte[] metadata = new byte[length];
        if (EntryRecord.read(handle, ByteBuffer.wrap(metadata), offset += (long)(header.getHeaderLength() + header.keyLength() + header.metadataLength() + header.valueLength()), length) < 0) {
            throw new IllegalStateException("End of file reached when reading internal metadata on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        return metadata;
    }

    public static byte[] readValue(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        assert (header.valueLength() > 0);
        byte[] value = new byte[header.valueLength()];
        if (EntryRecord.read(handle, ByteBuffer.wrap(value), offset + (long)header.getHeaderLength() + (long)header.keyLength() + (long)header.metadataLength(), header.valueLength()) < 0) {
            throw new IllegalStateException("End of file reached when reading metadata on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        return value;
    }

    private static int read(FileProvider.Handle handle, ByteBuffer buffer, long position, int length) throws IOException {
        int newRead;
        int read = 0;
        do {
            if ((newRead = handle.read(buffer, position + (long)read)) >= 0) continue;
            return -1;
        } while ((read += newRead) < length);
        return read;
    }

    public static void writeEntry(FileChannel fileChannel, ByteBuffer reusedBuffer, byte[] serializedKey, EntryMetadata metadata, byte[] serializedValue, byte[] serializedInternalMetadata, long seqId, long expiration) throws IOException {
        assert (reusedBuffer.limit() == 27);
        assert (reusedBuffer.position() == 0);
        EntryHeader.writeHeader(reusedBuffer, (short)serializedKey.length, metadata == null ? (short)0 : (short)metadata.length(), serializedValue == null ? 0 : serializedValue.length, serializedInternalMetadata == null ? (short)0 : (short)serializedInternalMetadata.length, seqId, expiration);
        reusedBuffer.flip();
        EntryRecord.write(fileChannel, reusedBuffer);
        reusedBuffer.position(0);
        EntryRecord.write(fileChannel, ByteBuffer.wrap(serializedKey));
        if (metadata != null) {
            EntryRecord.write(fileChannel, ByteBuffer.wrap(metadata.getBytes()));
            EntryRecord.writeTimestamps(fileChannel, reusedBuffer, metadata.getCreated(), metadata.getLastUsed());
        }
        if (serializedValue != null) {
            EntryRecord.write(fileChannel, ByteBuffer.wrap(serializedValue));
        }
        if (serializedInternalMetadata != null) {
            EntryRecord.write(fileChannel, ByteBuffer.wrap(serializedInternalMetadata));
        }
    }

    static void writeEntry(FileChannel fileChannel, ByteBuffer reusedBuffer, ByteBuffer serializedKey, ByteBuffer serializedMetadata, ByteBuffer serializedInternalMetadata, ByteBuffer serializedValue, long seqId, long expiration, long created, long lastUsed) throws IOException {
        assert (reusedBuffer.limit() == 27);
        assert (reusedBuffer.position() == 0);
        EntryHeader.writeHeader(reusedBuffer, (short)serializedKey.remaining(), EntryMetadata.size(serializedMetadata), serializedValue == null ? 0 : serializedValue.remaining(), serializedInternalMetadata == null ? (short)0 : (short)serializedInternalMetadata.remaining(), seqId, expiration);
        reusedBuffer.flip();
        EntryRecord.write(fileChannel, reusedBuffer);
        reusedBuffer.position(0);
        EntryRecord.write(fileChannel, serializedKey);
        if (serializedMetadata != null) {
            EntryRecord.write(fileChannel, serializedMetadata);
            EntryRecord.writeTimestamps(fileChannel, reusedBuffer, created, lastUsed);
        }
        if (serializedValue != null) {
            EntryRecord.write(fileChannel, serializedValue);
        }
        if (serializedInternalMetadata != null) {
            EntryRecord.write(fileChannel, serializedInternalMetadata);
        }
    }

    private static void writeTimestamps(FileChannel fileChannel, ByteBuffer reusedBuffer, long created, long lastUsed) throws IOException {
        assert (reusedBuffer.position() == 0);
        int previousLimit = reusedBuffer.limit();
        assert (previousLimit >= 16);
        reusedBuffer.putLong(created);
        reusedBuffer.putLong(lastUsed);
        reusedBuffer.flip();
        EntryRecord.write(fileChannel, reusedBuffer);
        reusedBuffer.position(0);
        reusedBuffer.limit(previousLimit);
    }

    private static void write(FileChannel fileChannel, ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            fileChannel.write(buffer);
        }
    }
}

