/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.orchestrator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrchestratorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(OrchestratorRegistry.class);
    private static Map<String, Orchestrator> lookup = Maps.newHashMap();

    private OrchestratorRegistry() {
    }

    private static void register(Class<? extends Orchestrator> orchestratorClass) throws IllegalAccessException, InstantiationException {
        if (Modifier.isAbstract(orchestratorClass.getModifiers())) {
            return;
        }
        String name = orchestratorClass.getSimpleName();
        if (orchestratorClass.isAnnotationPresent(Orchestrator.Metadata.class)) {
            Orchestrator.Metadata annotation = orchestratorClass.getAnnotation(Orchestrator.Metadata.class);
            name = annotation.name();
        }
        logger.info("Registering Orchestrator [{}] under name [{}]", orchestratorClass, (Object)name);
        lookup.put(name, orchestratorClass.newInstance());
    }

    public static Orchestrator getOrchestrator(String name) {
        Orchestrator orchestrator = lookup.get(name);
        if (orchestrator == null) {
            throw new OrchestratorRegistryException(String.format("Could not find a registered orchestrator with name [%s]", name));
        }
        return orchestrator;
    }

    public static List<Orchestrator> getOrchestrators(List<String> names) {
        return Lists.newArrayList((Iterable)Iterables.transform(names, input -> OrchestratorRegistry.getOrchestrator(input)));
    }

    public static Set<String> all() {
        return Sets.newHashSet(lookup.keySet());
    }

    static {
        Set orchestratorClasses = Scannit.getInstance().getSubTypesOf(Orchestrator.class);
        for (Class orchestratorClass : orchestratorClasses) {
            try {
                OrchestratorRegistry.register(orchestratorClass);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't boot the OrchestratorRegistry", e);
            }
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    private static class OrchestratorRegistryException
    extends DeployitException {
        public OrchestratorRegistryException(String message) {
            super(message);
        }
    }
}

