/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.dto.ApplyPatchesInput;
import com.xebialabs.deployit.core.rest.api.dto.PatchedSample;
import com.xebialabs.deployit.model.InvalidActivator;
import com.xebialabs.deployit.model.InvalidActivators;
import com.xebialabs.deployit.model.InvalidPatchEntry;
import com.xebialabs.deployit.model.request.ValidateActivatorRequest;
import com.xebialabs.deployit.model.request.ValidateActivatorsRequest;
import com.xebialabs.deployit.model.request.ValidatePatchEntryRequest;
import com.xebialabs.deployit.plugin.service.FormatSupportProvider;
import com.xebialabs.deployit.plugin.service.PatchFormatSupport;
import com.xebialabs.deployit.plugin.service.PatchService;
import com.xebialabs.deployit.plugin.service.ValidationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Controller
@Autowired
@Path(value="/patch")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\u0005\u000b\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003u\u0001\u0011\u0005Q\u000fC\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\ti\u0001+\u0019;dQJ+7o\\;sG\u0016T!a\u0003\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u000e\u001d\u0005!!/Z:u\u0015\ty\u0001#\u0001\u0003d_J,'BA\t\u0013\u0003!!W\r\u001d7ps&$(BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\ra\u0006$8\r[*feZL7-\u001a\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\nqa]3sm&\u001cWM\u0003\u0002%!\u00051\u0001\u000f\\;hS:L!AJ\u0011\u0003\u0019A\u000bGo\u00195TKJ4\u0018nY3\u0002#Y\fG.\u001b3bi&|gnU3sm&\u001cW\r\u0005\u0002!S%\u0011!&\t\u0002\u0012-\u0006d\u0017\u000eZ1uS>t7+\u001a:wS\u000e,\u0017!\u00064pe6\fGoU;qa>\u0014H\u000f\u0015:pm&$WM\u001d\t\u0003A5J!AL\u0011\u0003+\u0019{'/\\1u'V\u0004\bo\u001c:u!J|g/\u001b3fe\u00061A(\u001b8jiz\"B!M\u001a5kA\u0011!\u0007A\u0007\u0002\u0015!)a\u0004\u0002a\u0001?!)q\u0005\u0002a\u0001Q!)1\u0006\u0002a\u0001Y\u0005)\u0011\r\u001d9msR\u0019\u0001HP-\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mR\u0011a\u00013u_&\u0011QH\u000f\u0002\u000e!\u0006$8\r[3e'\u0006l\u0007\u000f\\3\t\u000b}*\u0001\u0019\u0001!\u0002\u001d\r|g\u000e^3oiRK\b/Z#yiB\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"a\u0011\u000e\u000e\u0003\u0011S!!\u0012\f\u0002\rq\u0012xn\u001c;?\u0013\t9%$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$\u001bQ\u0011qDJV,\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016A\u0001:t\u0015\t\t&+\u0001\u0002xg*\t1+A\u0003kCZ\f\u00070\u0003\u0002V\u001d\nI\u0001+\u0019;i!\u0006\u0014\u0018-\\\u0001\u0006m\u0006dW/Z\u0011\u00021\u0006Y1m\u001c8uK:$H+\u001f9f\u0011\u0015QV\u00011\u0001\\\u0003\u0011!\u0017\r^1\u0011\u0005eb\u0016BA/;\u0005E\t\u0005\u000f\u001d7z!\u0006$8\r[3t\u0013:\u0004X\u000f\u001e\u0015\u0003\u000b}\u0003\"!\u00141\n\u0005\u0005t%\u0001\u0002)P'RCC!B2WMB\u0011Q\nZ\u0005\u0003K:\u0013A\u0001U1uQ\u0006\nq-A\nbaBd\u0017pL>d_:$XM\u001c;UsB,W\u0010\u000b\u0003\u0006SZc\u0007CA'k\u0013\tYgJ\u0001\u0005D_:\u001cX/\\3tY\u0005i\u0017%\u00018\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007\u0006B\u0003q-N\u0004\"!T9\n\u0005It%\u0001\u0003)s_\u0012,8-Z:-\u00035\f\u0011C^1mS\u0012\fG/Z!di&4\u0018\r^8s)\u00111x0a\u0001\u0011\u0007e9\u00180\u0003\u0002y5\t1q\n\u001d;j_:\u0004\"A_?\u000e\u0003mT!\u0001 \t\u0002\u000b5|G-\u001a7\n\u0005y\\(\u0001E%om\u0006d\u0017\u000eZ!di&4\u0018\r^8s\u0011\u0015yd\u00011\u0001AQ\u0011yHJV,\t\u000f\u0005\u0015a\u00011\u0001\u0002\b\u00059!/Z9vKN$\b\u0003BA\u0005\u0003\u001bi!!a\u0003\u000b\u0007\u0005\u001510\u0003\u0003\u0002\u0010\u0005-!\u0001\u0007,bY&$\u0017\r^3BGRLg/\u0019;peJ+\u0017/^3ti\"\u0012aa\u0018\u0015\u0006\r\r4\u0016QC\u0011\u0003\u0003/\t\u0001E^1mS\u0012\fG/Z\u0018bGRLg/\u0019;pe>Z8m\u001c8uK:$H+\u001f9f{\"*a!\u001b,\u0002\u001c1\nQ.\u0001\nwC2LG-\u0019;f\u0003\u000e$\u0018N^1u_J\u001cHCBA\u0011\u0003s\ti\u0004\u0005\u0004\u0002$\u00055\u00121\u0007\b\u0005\u0003K\tICD\u0002D\u0003OI\u0011aG\u0005\u0004\u0003WQ\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003_\t\tD\u0001\u0003MSN$(bAA\u00165A\u0019!0!\u000e\n\u0007\u0005]2PA\tJ]Z\fG.\u001b3BGRLg/\u0019;peNDQaP\u0004A\u0002\u0001CS!!\u000fM-^Cq!!\u0002\b\u0001\u0004\ty\u0004\u0005\u0003\u0002\n\u0005\u0005\u0013\u0002BA\"\u0003\u0017\u0011\u0011DV1mS\u0012\fG/Z!di&4\u0018\r^8sgJ+\u0017/^3ti\"\u0012qa\u0018\u0015\u0006\u000f\r4\u0016\u0011J\u0011\u0003\u0003\u0017\n\u0011E^1mS\u0012\fG/Z\u0018bGRLg/\u0019;peN|3pY8oi\u0016tG\u000fV=qKvDSaB5W\u0003\u001fb\u0013!\\\u0001\u0013m\u0006d\u0017\u000eZ1uKB\u000bGo\u00195F]R\u0014\u0018\u0010\u0006\u0004\u0002V\u0005u\u0013\u0011\r\t\u00053]\f9\u0006E\u0002{\u00033J1!a\u0017|\u0005EIeN^1mS\u0012\u0004\u0016\r^2i\u000b:$(/\u001f\u0005\u0006\u007f!\u0001\r\u0001\u0011\u0015\u0006\u0003;bek\u0016\u0005\b\u0003\u000bA\u0001\u0019AA2!\u0011\tI!!\u001a\n\t\u0005\u001d\u00141\u0002\u0002\u001a-\u0006d\u0017\u000eZ1uKB\u000bGo\u00195F]R\u0014\u0018PU3rk\u0016\u001cH\u000f\u000b\u0002\t?\"*\u0001b\u0019,\u0002n\u0005\u0012\u0011qN\u0001\u001dm\u0006d\u0017\u000eZ1uK>*g\u000e\u001e:z_m\u001cwN\u001c;f]R$\u0016\u0010]3~Q\u0015A\u0011NVA:Y\u0005i\u0007f\u0001\u0001\u0002xA!\u0011\u0011PAD\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014AC:uKJ,w\u000e^=qK*!\u0011\u0011QAB\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAAC\u0003\ry'oZ\u0005\u0005\u0003\u0013\u000bYH\u0001\u0006D_:$(o\u001c7mKJD3\u0001AAG!\u0011\ty)!(\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\t9*!'\u0002\u000f\u0019\f7\r^8ss*!\u00111TA@\u0003\u0015\u0011W-\u00198t\u0013\u0011\ty*!%\u0003\u0013\u0005+Ho\\<je\u0016$\u0007&\u0002\u0001d-\u0006\r\u0016EAAS\u0003\u0019y\u0003/\u0019;dQ\u0002")
public class PatchResource {
    private final PatchService patchService;
    private final ValidationService validationService;
    private final FormatSupportProvider formatSupportProvider;

    @POST
    @Path(value="apply/{contentType}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PatchedSample apply(@PathParam(value="contentType") String contentTypeExt, ApplyPatchesInput data) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.patchService.applyPatch(data.patchEntries(), data.sample(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/activator/{contentType}")
    @Consumes(value={"application/json"})
    public Option<InvalidActivator> validateActivator(@PathParam(value="contentType") String contentTypeExt, ValidateActivatorRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validateActivator(request.content(), request.activator(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/activators/{contentType}")
    @Consumes(value={"application/json"})
    public List<InvalidActivators> validateActivators(@PathParam(value="contentType") String contentTypeExt, ValidateActivatorsRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validateActivators(request.content(), request.activators(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/entry/{contentType}")
    @Consumes(value={"application/json"})
    public Option<InvalidPatchEntry> validatePatchEntry(@PathParam(value="contentType") String contentTypeExt, ValidatePatchEntryRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validatePatchEntry(request.content(), request.entry(), patchFormatSupport);
    }

    public PatchResource(PatchService patchService, ValidationService validationService, FormatSupportProvider formatSupportProvider) {
        this.patchService = patchService;
        this.validationService = validationService;
        this.formatSupportProvider = formatSupportProvider;
    }
}

