/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xebialabs.deployit.core.api.dto.LicensedCiUsageDto;
import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@XmlRootElement(name="license-info")
public class LicenseDto
extends AbstractDto {
    private DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private String product;
    private String licensedTo;
    private String contact;
    private String expiresAfter;
    private String remainingDays;
    private List<LicensedCiUsageDto> licensedCiUsages = new ArrayList<LicensedCiUsageDto>();
    private List<String> licensedPlugins = new ArrayList<String>();
    private String supportPolicy;
    private String maxUsers;
    private String edition;

    public LicenseDto() {
    }

    public LicenseDto(String product, String licensedTo, String contact) {
        this.product = product;
        this.licensedTo = licensedTo;
        this.contact = contact;
    }

    private String calculateRemainingDays(String toBeExpiresAfter) {
        DateTime expiredDate = this.dtf.parseDateTime(toBeExpiresAfter);
        Period period = new Period((ReadableInstant)this.getCurrentTime(), (ReadableInstant)expiredDate, PeriodType.dayTime());
        return String.valueOf(period.getDays() + 1);
    }

    @XmlElement(name="product")
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    @XmlElement(name="licensed-to")
    public String getLicensedTo() {
        return this.licensedTo;
    }

    public void setLicensedTo(String licencedTo) {
        this.licensedTo = licencedTo;
    }

    @XmlElement(name="contact")
    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    @XmlElement(name="expires-after")
    public String getExpiresAfter() {
        return this.expiresAfter;
    }

    @XmlElement(name="remaining-days")
    public String getRemainingDays() {
        return this.remainingDays;
    }

    public void setExpiresAfter(String toBeExpiresAfter) {
        this.expiresAfter = toBeExpiresAfter;
        this.remainingDays = toBeExpiresAfter != null ? this.calculateRemainingDays(toBeExpiresAfter) : null;
    }

    @XmlElement(name="licensed-ci-usage")
    @JsonProperty(value="licensedCiUsage")
    public List<LicensedCiUsageDto> getLicensedCiUsages() {
        return this.licensedCiUsages;
    }

    public void setLicensedCiUsages(List<LicensedCiUsageDto> licensedCiUsages) {
        this.licensedCiUsages = licensedCiUsages;
    }

    @XmlElement(name="licensed-plugin")
    public List<String> getLicensedPlugins() {
        return this.licensedPlugins;
    }

    public void setLicensedPlugins(List<String> licensedPlugins) {
        this.licensedPlugins = licensedPlugins;
    }

    @XmlElement(name="support-policy")
    public String getSupportPolicy() {
        return this.supportPolicy;
    }

    public void setSupportPolicy(String supportPolicy) {
        this.supportPolicy = supportPolicy;
    }

    @XmlElement(name="max-users")
    public String getMaxUsers() {
        return this.maxUsers;
    }

    public void setMaxUsers(String maxUsers) {
        this.maxUsers = maxUsers;
    }

    @XmlElement(name="edition")
    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public DateTime getCurrentTime() {
        return DateTime.now();
    }
}

