/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.SimpleDnsCache;
import org.apache.pekko.io.dns.AAAARecord;
import org.apache.pekko.io.dns.ARecord;
import org.apache.pekko.io.dns.CachePolicy;
import org.apache.pekko.io.dns.CachePolicy$Never$;
import org.apache.pekko.io.dns.CachePolicy$Ttl$;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.io.dns.DnsProtocol$Ip$;
import org.apache.pekko.io.dns.DnsProtocol$Resolved$;
import org.apache.pekko.io.dns.DnsProtocol$Srv$;
import org.apache.pekko.io.dns.DnsSettings;
import org.apache.pekko.io.dns.IdGenerator;
import org.apache.pekko.io.dns.IdGenerator$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.internal.AsyncDnsResolver$;
import org.apache.pekko.io.dns.internal.DnsClient;
import org.apache.pekko.io.dns.internal.package$CachePolicyIsOrdered$;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.PrettyDuration$PrettyPrintableDuration$;
import org.apache.pekko.util.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005b!\u0002\u001e<\u0005}:\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011u\u0003!\u0011!Q\u0001\nyC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003\u0017\u0001A\u0011AA\u000e\u0011%\t\u0019\u0003\u0001b\u0001\n\u0007\t)\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0014\u0011%\t)\u0004\u0001b\u0001\n\u0007\t9\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001d\u0011%\t9\u0005\u0001b\u0001\n\u0003\tI\u0005C\u0004\u0002L\u0001\u0001\u000b\u0011B5\t\u0013\u00055\u0003A1A\u0005\u0002\u0005=\u0003\u0002CA7\u0001\u0001\u0006I!!\u0015\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005=\u0003\u0002CA9\u0001\u0001\u0006I!!\u0015\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004bBA<\u0001\u0001\u0006I! \u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!a0\u0001\t\u0013\t\t\rC\u0004\u0002f\u0002!I!a:\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9\u0011Q \u0001\u0005\n\u0005}x\u0001\u0003B\u000bw!\u0005\u0011Ia\u0006\u0007\u000fiZ\u0004\u0012A!\u0003\u001a!9\u00111\u0002\u000e\u0005\u0002\tm\u0001\"\u0003B\u000f5\t\u0007I\u0011\u0002B\u0010\u0011!\u0011yC\u0007Q\u0001\n\t\u0005\u0002\"\u0003B\u00195\t\u0007I\u0011\u0002B\u0010\u0011!\u0011\u0019D\u0007Q\u0001\n\t\u0005\u0002\u0002\u0003B\u001b5\u0011\u0005\u0011Ia\u000e\t\u0011\t\u0005#\u0004\"\u0001B\u0005\u0007BqAa\u0012\u001b\t\u0013\u0011I\u0005C\u0005\u0003Ni\u0011\r\u0011\"\u0003\u0003P!A!\u0011\u000b\u000e!\u0002\u0013\t\u0019M\u0002\u0004\u0003Ti\u0001%Q\u000b\u0005\u000b\u0005S*#Q3A\u0005\u0002\t-\u0004B\u0003B7K\tE\t\u0015!\u0003\u0002\"\"9\u00111B\u0013\u0005\u0002\t=\u0004\"\u0003B<K\u0005\u0005I\u0011\u0001B=\u0011%\u0011i(JI\u0001\n\u0003\u0011y\bC\u0005\u0003\u0014\u0016\n\t\u0011\"\u0011\u0003\u0016\"I!\u0011U\u0013\u0002\u0002\u0013\u0005!1\u0015\u0005\n\u0005W+\u0013\u0011!C\u0001\u0005[C\u0011B!/&\u0003\u0003%\tEa/\t\u0013\t%W%!A\u0005\u0002\t-\u0007\"\u0003BhK\u0005\u0005I\u0011\tBi\u0011%\u0011).JA\u0001\n\u0003\u00129\u000eC\u0005\u0003Z\u0016\n\t\u0011\"\u0011\u0003\\\u001eI!q\u001c\u000e\u0002\u0002#\u0005!\u0011\u001d\u0004\n\u0005'R\u0012\u0011!E\u0001\u0005GDq!a\u00035\t\u0003\u0011I\u0010C\u0005\u0003|R\n\t\u0011\"\u0012\u0003~\"I!q \u001b\u0002\u0002\u0013\u00055\u0011\u0001\u0005\n\u0007\u000b!\u0014\u0011!CA\u0007\u000fA\u0011ba\u00055\u0003\u0003%Ia!\u0006\u0003!\u0005\u001b\u0018P\\2E]N\u0014Vm]8mm\u0016\u0014(B\u0001\u001f>\u0003!Ig\u000e^3s]\u0006d'B\u0001 @\u0003\r!gn\u001d\u0006\u0003\u0001\u0006\u000b!![8\u000b\u0005\t\u001b\u0015!\u00029fW.|'B\u0001#F\u0003\u0019\t\u0007/Y2iK*\ta)A\u0002pe\u001e\u001cB\u0001\u0001%O)B\u0011\u0011\nT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n1\u0011I\\=SK\u001a\u0004\"a\u0014*\u000e\u0003AS!!U!\u0002\u000b\u0005\u001cGo\u001c:\n\u0005M\u0003&!B!di>\u0014\bCA(V\u0013\t1\u0006K\u0001\u0007BGR|'\u000fT8hO&tw-\u0001\u0005tKR$\u0018N\\4t\u0007\u0001\u0001\"AW.\u000e\u0003uJ!\u0001X\u001f\u0003\u0017\u0011s7oU3ui&twm]\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0003?\u0002l\u0011aP\u0005\u0003C~\u0012abU5na2,GI\\:DC\u000eDW-A\u0007dY&,g\u000e\u001e$bGR|'/\u001f\t\u0006\u0013\u00124\u0017.`\u0005\u0003K*\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u0005=;\u0017B\u00015Q\u0005=\t5\r^8s%\u00164g)Y2u_JL\bc\u00016sk:\u00111\u000e\u001d\b\u0003Y>l\u0011!\u001c\u0006\u0003]b\u000ba\u0001\u0010:p_Rt\u0014\"A&\n\u0005ET\u0015a\u00029bG.\fw-Z\u0005\u0003gR\u0014A\u0001T5ti*\u0011\u0011O\u0013\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f1A\\3u\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001`<\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fE\u0002kez\u0004\"aT@\n\u0007\u0005\u0005\u0001K\u0001\u0005BGR|'OU3g\u0003-IGmR3oKJ\fGo\u001c:\u0011\u0007i\u000b9!C\u0002\u0002\nu\u00121\"\u00133HK:,'/\u0019;pe\u00061A(\u001b8jiz\"\"\"a\u0004\u0002\u0014\u0005U\u0011qCA\r!\r\t\t\u0002A\u0007\u0002w!)q+\u0002a\u00013\")Q,\u0002a\u0001=\")!-\u0002a\u0001G\"9\u00111A\u0003A\u0002\u0005\u0015A\u0003CA\b\u0003;\ty\"!\t\t\u000b]3\u0001\u0019A-\t\u000bu3\u0001\u0019\u00010\t\u000b\t4\u0001\u0019A2\u0002\u0005\u0015\u001cWCAA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017\u0015\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005E\u00121\u0006\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\u0018aA3dA\u00059A/[7f_V$XCAA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \u0003\u0006!Q\u000f^5m\u0013\u0011\t\u0019%!\u0010\u0003\u000fQKW.Z8vi\u0006AA/[7f_V$\b%A\u0006oC6,7+\u001a:wKJ\u001cX#A5\u0002\u00199\fW.Z*feZ,'o\u001d\u0011\u0002'A|7/\u001b;jm\u0016\u001c\u0015m\u00195f!>d\u0017nY=\u0016\u0005\u0005E\u0003\u0003BA*\u0003OrA!!\u0016\u0002d9!\u0011qKA1\u001d\u0011\tI&a\u0018\u000f\t\u0005m\u0013QL\u0007\u0002\u0007&\u0011!iQ\u0005\u0003\u0001\u0006K!AP \n\u0007\u0005\u0015T(A\u0006DC\u000eDW\rU8mS\u000eL\u0018\u0002BA5\u0003W\u00121bQ1dQ\u0016\u0004v\u000e\\5ds*\u0019\u0011QM\u001f\u0002)A|7/\u001b;jm\u0016\u001c\u0015m\u00195f!>d\u0017nY=!\u0003MqWmZ1uSZ,7)Y2iKB{G.[2z\u0003QqWmZ1uSZ,7)Y2iKB{G.[2zA\u0005I!/Z:pYZ,'o]\u000b\u0002{\u0006Q!/Z:pYZ,'o\u001d\u0011\u0002\u000fI,7-Z5wKV\u0011\u0011Q\u0010\t\u0005\u0003\u007f\n\t)D\u0001\u0001\u0013\r\t\u0019I\u0015\u0002\b%\u0016\u001cW-\u001b<f\u0003Q\u0011Xm]8mm\u0016<\u0016\u000e\u001e5SKN|GN^3sgRA\u0011\u0011RAO\u0003c\u000bi\f\u0005\u0004\u0002*\u0005-\u0015qR\u0005\u0005\u0003\u001b\u000bYC\u0001\u0004GkR,(/\u001a\t\u0005\u0003#\u000b9JD\u0002[\u0003'K1!!&>\u0003-!en\u001d)s_R|7m\u001c7\n\t\u0005e\u00151\u0014\u0002\t%\u0016\u001cx\u000e\u001c<fI*\u0019\u0011QS\u001f\t\u000f\u0005}E\u00031\u0001\u0002\"\u0006!a.Y7f!\u0011\t\u0019+a+\u000f\t\u0005\u0015\u0016q\u0015\t\u0003Y*K1!!+K\u0003\u0019\u0001&/\u001a3fM&!\u0011QVAX\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0016&\t\u000f\u0005MF\u00031\u0001\u00026\u0006Y!/Z9vKN$H+\u001f9f!\u0011\t9,!/\u000f\t\u0005U\u00131S\u0005\u0005\u0003w\u000bYJA\u0006SKF,Xm\u001d;UsB,\u0007BBA:)\u0001\u0007Q0\u0001\u0007tK:$\u0017+^3ti&|g\u000e\u0006\u0004\u0002D\u0006]\u00171\u001c\t\u0007\u0003S\tY)!2\u0011\t\u0005\u001d\u0017\u0011\u001b\b\u0005\u0003\u0013\fiM\u0004\u0003\u0002V\u0005-\u0017B\u0001\u001f>\u0013\r\tymO\u0001\n\t:\u001c8\t\\5f]RLA!a5\u0002V\n1\u0011I\\:xKJT1!a4<\u0011\u0019\tI.\u0006a\u0001}\u0006A!/Z:pYZ,'\u000fC\u0004\u0002^V\u0001\r!a8\u0002\u000f5,7o]1hKB!\u0011qYAq\u0013\u0011\t\u0019/!6\u0003\u0017\u0011s7/U;fgRLwN\\\u0001\u0012e\u0016\u001cx\u000e\u001c<f/&$\bnU3be\u000eDG\u0003CAE\u0003S\fY/!<\t\u000f\u0005}e\u00031\u0001\u0002\"\"9\u00111\u0017\fA\u0002\u0005U\u0006BBAm-\u0001\u0007a0\u0001\u0007sKN|GN^3GSJ\u001cH\u000f\u0006\u0005\u0002\n\u0006M\u0018\u0011`A~\u0011\u001d\t)p\u0006a\u0001\u0003o\f1b]3be\u000eDg*Y7fgB!!N]AQ\u0011\u001d\t\u0019l\u0006a\u0001\u0003kCa!!7\u0018\u0001\u0004q\u0018a\u0002:fg>dg/\u001a\u000b\t\u0003\u0013\u0013\tAa\u0001\u0003\u0006!9\u0011q\u0014\rA\u0002\u0005\u0005\u0006bBAZ1\u0001\u0007\u0011Q\u0017\u0005\u0007\u00033D\u0002\u0019\u0001@)\u0007\u0001\u0011I\u0001\u0005\u0003\u0003\f\tEQB\u0001B\u0007\u0015\r\u0011y!Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\n\u0005\u001b\u00111\"\u00138uKJt\u0017\r\\!qS\u0006\u0001\u0012i]=oG\u0012s7OU3t_24XM\u001d\t\u0004\u0003#Q2C\u0001\u000eI)\t\u00119\"A\u0006jaZ$\u0014\t\u001a3sKN\u001cXC\u0001B\u0011!\u0011\u0011\u0019Ca\u000b\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0005S\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003\u007fQ\u0015\u0002\u0002B\u0017\u0005K\u0011QAU3hKb\fA\"\u001b9wi\u0005#GM]3tg\u0002\n1\"\u001b9wm\u0005#GM]3tg\u0006a\u0011\u000e\u001d<7\u0003\u0012$'/Z:tA\u0005i\u0011n]%qmR\nE\r\u001a:fgN$BA!\u000f\u0003@A\u0019\u0011Ja\u000f\n\u0007\tu\"JA\u0004C_>dW-\u00198\t\u000f\u0005}\u0005\u00051\u0001\u0002\"\u0006i\u0011n]%qmZ\nE\r\u001a:fgN$BA!\u000f\u0003F!9\u0011qT\u0011A\u0002\u0005\u0005\u0016!D5t\u0013:,G/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0003:\t-\u0003bBAPE\u0001\u0007\u0011\u0011U\u0001\u0006\u000b6\u0004H/_\u000b\u0003\u0003\u0007\fa!R7qif\u0004#A\u0006*fg>dg/\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0014\u000f\u0015\u00129F!\u0018\u0003dA\u0019!N!\u0017\n\u0007\tmCOA\u0005Fq\u000e,\u0007\u000f^5p]B\u0019\u0011Ja\u0018\n\u0007\t\u0005$JA\u0004Qe>$Wo\u0019;\u0011\u0007)\u0014)'C\u0002\u0003hQ\u0014AbU3sS\u0006d\u0017N_1cY\u0016\f1!\\:h+\t\t\t+\u0001\u0003ng\u001e\u0004C\u0003\u0002B9\u0005k\u00022Aa\u001d&\u001b\u0005Q\u0002b\u0002B5Q\u0001\u0007\u0011\u0011U\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0003r\tm\u0004\"\u0003B5SA\u0005\t\u0019AAQ\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!!+\t\u0005\u0005&1Q\u0016\u0003\u0005\u000b\u0003BAa\"\u0003\u00106\u0011!\u0011\u0012\u0006\u0005\u0005\u0017\u0013i)A\u0005v]\u000eDWmY6fI*\u0019!q\u0002&\n\t\tE%\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0018B!!\u0011\u0014BP\u001b\t\u0011YJC\u0002\u0003\u001ef\fA\u0001\\1oO&!\u0011Q\u0016BN\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011)\u000bE\u0002J\u0005OK1A!+K\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yK!.\u0011\u0007%\u0013\t,C\u0002\u00034*\u00131!\u00118z\u0011%\u00119,LA\u0001\u0002\u0004\u0011)+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005{\u0003bAa0\u0003F\n=VB\u0001Ba\u0015\r\u0011\u0019MS\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bd\u0005\u0003\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!\u0011\bBg\u0011%\u00119lLA\u0001\u0002\u0004\u0011y+\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002BL\u0005'D\u0011Ba.1\u0003\u0003\u0005\rA!*\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!*\u0002\r\u0015\fX/\u00197t)\u0011\u0011ID!8\t\u0013\t]&'!AA\u0002\t=\u0016A\u0006*fg>dg/\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0011\u0007\tMDgE\u00035\u0005K\u0014\t\u0010\u0005\u0005\u0003h\n5\u0018\u0011\u0015B9\u001b\t\u0011IOC\u0002\u0003l*\u000bqA];oi&lW-\u0003\u0003\u0003p\n%(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!!1\u001fB|\u001b\t\u0011)P\u0003\u0002As&!!q\rB{)\t\u0011\t/\u0001\u0005u_N#(/\u001b8h)\t\u00119*A\u0003baBd\u0017\u0010\u0006\u0003\u0003r\r\r\u0001b\u0002B5o\u0001\u0007\u0011\u0011U\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Iaa\u0004\u0011\u000b%\u001bY!!)\n\u0007\r5!J\u0001\u0004PaRLwN\u001c\u0005\n\u0007#A\u0014\u0011!a\u0001\u0005c\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u00199\u0002\u0005\u0003\u0003\u001a\u000ee\u0011\u0002BB\u000e\u00057\u0013aa\u00142kK\u000e$\bf\u0001\u000e\u0003\n!\u001a\u0011D!\u0003")
@InternalApi
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final SimpleDnsCache org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache;
    private final IdGenerator idGenerator;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private final List<ActorRef> org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    public List<ActorRef> org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)A1;
                    String name = resolve.name();
                    Option<DnsProtocol.Resolved> option = this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)(mode = resolve.requestType())));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DnsProtocol.Resolved resolved2 = (DnsProtocol.Resolved)some.value();
                        this.$outer.log().debug("{} cached {}", mode, resolved2);
                        this.$outer.sender().$bang(resolved2, this.$outer.self());
                    } else if (None$.MODULE$.equals(option)) {
                        package$.MODULE$.pipe(this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers()).map((Function1 & Serializable)resolved -> {
                            if (resolved.records().nonEmpty()) {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.positiveCachePolicy();
                                CachePolicy.CachePolicy minTtl = (CachePolicy.CachePolicy)((IterableOnceOps)((SeqOps)resolved.records().map((Function1 & Serializable)x$2 -> x$2.ttl())).$plus$colon((Object)cachePolicy)).min((Ordering)package$CachePolicyIsOrdered$.MODULE$);
                                $this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, minTtl);
                            } else {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    $this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, $this.$outer.negativeCachePolicy());
                                }
                            }
                            $this.$outer.log().debug("{} resolved {}", mode, resolved);
                            return resolved;
                        }, (ExecutionContext)this.$outer.ec()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                    } else {
                        throw new MatchError(option);
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return object instanceof DnsProtocol.Resolve;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.pekko.io.dns.internal.AsyncDnsResolver$$anonfun$receive$1 java.lang.String org.apache.pekko.io.dns.DnsProtocol$RequestType org.apache.pekko.io.dns.DnsProtocol$Resolved ), $anonfun$applyOrElse$2(org.apache.pekko.io.dns.ResourceRecord )}, serializedLambda);
            }
        };
    }

    public Future<DnsProtocol.Resolved> org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        if (AsyncDnsResolver$.MODULE$.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
                ARecord record;
                ResourceRecord resourceRecord;
                InetAddress address = InetAddress.getByName(name);
                InetAddress inetAddress = address;
                if (inetAddress instanceof Inet4Address) {
                    resourceRecord = new ARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                } else if (inetAddress instanceof Inet6Address) {
                    Inet6Address inet6Address = (Inet6Address)inetAddress;
                    resourceRecord = new AAAARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(20).append("Unexpected address: ").append(inetAddress).toString());
                }
                ARecord aRecord = record = resourceRecord;
                return DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord));
            }));
        }
        List<ActorRef> list = resolvers;
        if (Nil$.MODULE$.equals(list)) {
            return Future$.MODULE$.failed((Throwable)new ResolveFailedException(new StringBuilder(37).append("Failed to resolve ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            ActorRef head = (ActorRef)colon2.head();
            List tail = colon2.next$access$1();
            return this.resolveWithSearch(name, requestType, head).recoverWith((PartialFunction)new Serializable(this, name, requestType, tail){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncDnsResolver $outer;
                private final String name$2;
                private final DnsProtocol.RequestType requestType$1;
                private final List tail$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option option;
                    A1 A1 = x1;
                    if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        Throwable throwable = t;
                        if (throwable instanceof AskTimeoutException) {
                            this.$outer.log().info("Resolve of {} timed out after {}. Trying next name server", this.name$2, PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.timeout().duration())));
                        } else {
                            this.$outer.log().info("Resolve of {} failed. Trying next name server {}", this.name$2, t.getMessage());
                        }
                        return (B1)this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, (List<ActorRef>)this.tail$1);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Option option;
                    Throwable throwable = x1;
                    return throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.name$2 = name$2;
                    this.requestType$1 = requestType$1;
                    this.tail$1 = tail$1;
                }
            }, (ExecutionContext)this.ec());
        }
        throw new MatchError(list);
    }

    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).transformWith((Function1 & Serializable)x0$1 -> {
            Object object;
            boolean bl = false;
            Success success = null;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Object result = success.value();
                if (result instanceof DnsClient.Answer) {
                    DnsClient.Answer answer = (DnsClient.Answer)result;
                    return Future$.MODULE$.successful((Object)answer);
                }
            }
            if (bl && (object = success.value()) instanceof DnsClient.DuplicateId) {
                return this.sendQuestion(resolver, message.withId($this.idGenerator.nextId()));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                resolver.$bang(new DnsClient.DropRequest(message), this.self());
                return Future$.MODULE$.failed(t);
            }
            if (bl) {
                Object a = success.value();
                resolver.$bang(new DnsClient.DropRequest(message), this.self());
                return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(29).append("Unexpected response ").append(a.toString()).append(" of type ").append(a.getClass().toString()).toString()));
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.ec());
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        if (this.settings.SearchDomains().nonEmpty()) {
            List list;
            List nameWithSearch = this.settings.SearchDomains().map((Function1 & Serializable)sd -> new StringBuilder(1).append(name).append(".").append((String)sd).toString());
            if (StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AsyncDnsResolver.$anonfun$resolveWithSearch$2(BoxesRunTime.unboxToChar((Object)x$3)))) >= this.settings.NDots()) {
                String string = name;
                list = nameWithSearch.$colon$colon((Object)string);
            } else {
                list = (List)nameWithSearch.$colon$plus((Object)name);
            }
            List toResolve = list;
            return this.resolveFirst((List<String>)toResolve, requestType, resolver);
        }
        return this.resolve(name, requestType, resolver);
    }

    private Future<DnsProtocol.Resolved> resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<String> list = searchNames;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            String searchName = (String)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return this.resolve(searchName, requestType, resolver);
            }
        }
        if (bl) {
            String searchName = (String)colon2.head();
            List remaining = colon2.next$access$1();
            return this.resolve(searchName, requestType, resolver).flatMap((Function1 & Serializable)resolved -> {
                if (resolved.records().isEmpty()) {
                    return this.resolveFirst((List<String>)remaining, requestType, resolver);
                }
                return Future$.MODULE$.successful(resolved);
            }, (ExecutionContext)this.ec());
        }
        if (Nil$.MODULE$.equals(list)) {
            return Future$.MODULE$.failed((Throwable)new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
        }
        throw new MatchError(list);
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv42 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            Future<DnsClient.Answer> ipv4Recs = ipv42 ? this.sendQuestion(resolver, new DnsClient.Question4(this.idGenerator.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$Empty();
            Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.idGenerator.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$Empty();
            return ipv4Recs.flatMap((Function1 & Serializable)ipv4 -> ipv6Recs.map((Function1 & Serializable)ipv6 -> new DnsProtocol.Resolved(name, (Seq<ResourceRecord>)((Seq)ipv4.rrs().$plus$plus(ipv6.rrs())), (Seq<ResourceRecord>)((Seq)ipv4.additionalRecs().$plus$plus(ipv6.additionalRecs()))), (ExecutionContext)this.ec()), (ExecutionContext)this.ec());
        }
        if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            return this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.idGenerator.nextId(), caseFoldedName)).map((Function1 & Serializable)answer -> new DnsProtocol.Resolved(name, answer.rrs(), answer.additionalRecs()), (ExecutionContext)this.ec());
        }
        throw new MatchError((Object)requestType2);
    }

    public static final /* synthetic */ boolean $anonfun$resolveWithSearch$2(char x$3) {
        return x$3 == '.';
    }

    public AsyncDnsResolver(DnsSettings settings, SimpleDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory, IdGenerator idGenerator) {
        Tuple2 tuple2;
        InetAddress loopback;
        this.settings = settings;
        this.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache = cache;
        this.idGenerator = idGenerator;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        InetAddress inetAddress = loopback = InetAddress.getLoopbackAddress();
        if (inetAddress instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            tuple2 = new Tuple2((Object)InetAddress.getByName("127.0.0.1"), (Object)inet6Address);
        } else if (inetAddress instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            tuple2 = new Tuple2((Object)inet4Address, (Object)InetAddress.getByName("::1"));
        } else {
            throw new IllegalArgumentException(new StringBuilder(23).append("Loopback address was [").append(inetAddress).append("]").toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        InetAddress ipv4Address = (InetAddress)tuple22._1();
        InetAddress ipv6Address = (InetAddress)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)ipv4Address, (Object)ipv6Address);
        InetAddress ipv4Address2 = (InetAddress)tuple23._1();
        InetAddress ipv6Address2 = (InetAddress)tuple23._2();
        ARecord aRecord = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), loopback);
        cache.put((Tuple2<String, DnsProtocol.RequestType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"localhost"), (Object)new DnsProtocol.Ip(DnsProtocol$Ip$.MODULE$.apply$default$1(), DnsProtocol$Ip$.MODULE$.apply$default$2())), DnsProtocol$Resolved$.MODULE$.apply("localhost", (Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        boolean x$1 = false;
        boolean x$2 = true;
        ARecord aRecord2 = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), ipv4Address2);
        cache.put((Tuple2<String, DnsProtocol.RequestType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"localhost"), (Object)new DnsProtocol.Ip(true, false)), DnsProtocol$Resolved$.MODULE$.apply("localhost", (Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord2)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        boolean x$3 = true;
        boolean x$4 = false;
        ARecord aRecord3 = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), ipv6Address2);
        cache.put((Tuple2<String, DnsProtocol.RequestType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"localhost"), (Object)new DnsProtocol.Ip(false, true)), DnsProtocol$Resolved$.MODULE$.apply("localhost", (Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord3)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.positiveCachePolicy = settings.PositiveCachePolicy();
        this.negativeCachePolicy = settings.NegativeCachePolicy();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger((int)settings.NDots()));
        this.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
        Statics.releaseFence();
    }

    public AsyncDnsResolver(DnsSettings settings, SimpleDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this(settings, cache, clientFactory, IdGenerator$.MODULE$.apply(settings.IdGeneratorPolicy()));
    }

    public static class ResolveFailedException
    extends Exception
    implements Product {
        private final String msg;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.msg();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "msg";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$((Product)this);
        }
    }
}

