/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.pattern.CircuitBreaker;
import org.apache.pekko.pattern.CircuitBreakersRegistry$;
import org.apache.pekko.pattern.internal.CircuitBreakerTelemetry;
import org.apache.pekko.pattern.internal.CircuitBreakerTelemetryProvider$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-q!\u0002\n\u0014\u0011\u0003ab!\u0002\u0010\u0014\u0011\u0003y\u0002\"B\u001b\u0002\t\u0003Y\u0007\"\u00027\u0002\t\u0003j\u0007\"B8\u0002\t\u0003\u0002\b\"B3\u0002\t\u0003Z\bBB3\u0002\t\u0003\n\tA\u0002\u0003\u001f'\ti\u0003\u0002C\u0019\b\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u000bU:A\u0011\u0001\u001c\t\u000fa:!\u0019!C\u0005s!1!k\u0002Q\u0001\niBqaU\u0004C\u0002\u0013%A\u000b\u0003\u0004_\u000f\u0001\u0006I!\u0016\u0005\b?\u001e\u0011\r\u0011\"\u0003U\u0011\u0019\u0001w\u0001)A\u0005+\")\u0011m\u0002C\u0005E\"1Qm\u0002C\u0001+\u0019\fqcQ5sGVLGO\u0011:fC.,'o\u001d*fO&\u001cHO]=\u000b\u0005Q)\u0012a\u00029biR,'O\u001c\u0006\u0003-]\tQ\u0001]3lW>T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sO\u000e\u0001\u0001CA\u000f\u0002\u001b\u0005\u0019\"aF\"je\u000e,\u0018\u000e\u001e\"sK\u0006\\WM]:SK\u001eL7\u000f\u001e:z'\u0011\t\u0001E\n5\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\r9#\u0006L\u0007\u0002Q)\u0011\u0011&F\u0001\u0006C\u000e$xN]\u0005\u0003W!\u00121\"\u0012=uK:\u001c\u0018n\u001c8JIB\u0011QdB\n\u0004\u000f\u0001r\u0003CA\u00140\u0013\t\u0001\u0004FA\u0005FqR,gn]5p]\u000611/_:uK6\u0004\"aJ\u001a\n\u0005QB#aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017A\u0002\u001fj]&$h\b\u0006\u0002-o!)\u0011'\u0003a\u0001e\u0005A!M]3bW\u0016\u00148/F\u0001;!\u0011Y$\tR(\u000e\u0003qR!!\u0010 \u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002@\u0001\u0006!Q\u000f^5m\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011\u001f\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002F\u0019:\u0011aI\u0013\t\u0003\u000f\nj\u0011\u0001\u0013\u0006\u0003\u0013n\ta\u0001\u0010:p_Rt\u0014BA&#\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\u0013\u0003CA\u000fQ\u0013\t\t6C\u0001\bDSJ\u001cW/\u001b;Ce\u0016\f7.\u001a:\u0002\u0013\t\u0014X-Y6feN\u0004\u0013AB2p]\u001aLw-F\u0001V!\t1F,D\u0001X\u0015\t\u0019\u0006L\u0003\u0002Z5\u0006AA/\u001f9fg\u00064WMC\u0001\\\u0003\r\u0019w.\\\u0005\u0003;^\u0013aaQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0015I\u00164\u0017-\u001e7u\u0005J,\u0017m[3s\u0007>tg-[4\u0002+\u0011,g-Y;mi\n\u0013X-Y6fe\u000e{gNZ5hA\u0005!2M]3bi\u0016\u001c\u0015N]2vSR\u0014%/Z1lKJ$\"aT2\t\u000b\u0011\u0004\u0002\u0019\u0001#\u0002\u0005%$\u0017aA4fiR\u0011qj\u001a\u0005\u0006IF\u0001\r\u0001\u0012\t\u0003O%L!A\u001b\u0015\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u0003q\tqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0003Y9DQ!M\u0002A\u0002I\na\u0001\\8pWV\u0004X#A91\u0005I,\bcA\u0014+gB\u0011A/\u001e\u0007\u0001\t%1H!!A\u0001\u0002\u000b\u0005qOA\u0002`IE\n\"\u0001\u001f\u0018\u0011\u0005\u0005J\u0018B\u0001>#\u0005\u001dqu\u000e\u001e5j]\u001e$\"\u0001\f?\t\u000bE*\u0001\u0019A?\u0011\u0005\u001dr\u0018BA@)\u0005-\t5\r^8s'f\u001cH/Z7\u0015\u00071\n\u0019\u0001\u0003\u00042\r\u0001\u0007\u0011Q\u0001\t\u0004O\u0005\u001d\u0011bAA\u0005Q\tQ2\t\\1tg&\u001c\u0017i\u0019;peNK8\u000f^3n!J|g/\u001b3fe\u0002")
public final class CircuitBreakersRegistry
implements Extension {
    private final ExtendedActorSystem system;
    private final ConcurrentHashMap<String, CircuitBreaker> breakers;
    private final Config config;
    private final Config defaultBreakerConfig;

    public static ExtensionId<? extends Extension> lookup() {
        return CircuitBreakersRegistry$.MODULE$.lookup();
    }

    public static CircuitBreakersRegistry createExtension(ExtendedActorSystem system) {
        return CircuitBreakersRegistry$.MODULE$.createExtension(system);
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return CircuitBreakersRegistry$.MODULE$.apply(system);
    }

    public static Extension apply(ActorSystem system) {
        return CircuitBreakersRegistry$.MODULE$.apply(system);
    }

    private ConcurrentHashMap<String, CircuitBreaker> breakers() {
        return this.breakers;
    }

    private Config config() {
        return this.config;
    }

    private Config defaultBreakerConfig() {
        return this.defaultBreakerConfig;
    }

    private CircuitBreaker createCircuitBreaker(String id) {
        Config breakerConfig = this.config().hasPath(id) ? this.config().getConfig(id).withFallback((ConfigMergeable)this.defaultBreakerConfig()) : this.defaultBreakerConfig();
        int maxFailures = breakerConfig.getInt("max-failures");
        FiniteDuration callTimeout = new package.DurationLong(package$.MODULE$.DurationLong(breakerConfig.getDuration("call-timeout", TimeUnit.MILLISECONDS))).millis();
        FiniteDuration resetTimeout = new package.DurationLong(package$.MODULE$.DurationLong(breakerConfig.getDuration("reset-timeout", TimeUnit.MILLISECONDS))).millis();
        FiniteDuration maxResetTimeout = new package.DurationLong(package$.MODULE$.DurationLong(breakerConfig.getDuration("max-reset-timeout", TimeUnit.MILLISECONDS))).millis();
        double exponentialBackoffFactor = breakerConfig.getDouble("exponential-backoff");
        double randomFactor = breakerConfig.getDouble("random-factor");
        Set allowExceptions = package$JavaConverters$.MODULE$.ListHasAsScala(breakerConfig.getStringList("exception-allowlist")).asScala().toSet();
        CircuitBreakerTelemetry telemetry = CircuitBreakerTelemetryProvider$.MODULE$.start(id, this.system);
        return new CircuitBreaker(this.system.scheduler(), maxFailures, callTimeout, resetTimeout, maxResetTimeout, exponentialBackoffFactor, randomFactor, (Set<String>)allowExceptions, telemetry, (ExecutionContext)this.system.dispatcher());
    }

    public CircuitBreaker get(String id2) {
        return this.breakers().computeIfAbsent(id2, id -> this.createCircuitBreaker((String)id));
    }

    public CircuitBreakersRegistry(ExtendedActorSystem system) {
        this.system = system;
        this.breakers = new ConcurrentHashMap();
        this.config = system.settings().config().getConfig("pekko.circuit-breaker");
        this.defaultBreakerConfig = this.config().getConfig("default");
    }
}

