/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.util.concurrent.atomic.AtomicInteger;

public class ProgressEstimate {
    private long startTime = -1L;
    private final AtomicInteger worked = new AtomicInteger();
    private final int total;

    public ProgressEstimate(int total) {
        this.startTime = System.currentTimeMillis();
        this.total = total;
    }

    public void addWork(int worked) {
        this.worked.addAndGet(worked);
    }

    public int getWorked() {
        return this.worked.get();
    }

    public int getTotal() {
        return this.total;
    }

    public long getTimeRemainingInMillis() {
        long batchTime = System.currentTimeMillis() - this.startTime;
        double timePerIteration = (double)batchTime / (double)this.worked.get();
        return (long)(timePerIteration * (double)(this.total - this.worked.get()));
    }
}

