/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionSynchronizerInterceptor
extends BaseAsyncInterceptor {
    private static final Log log = LogFactory.getLog(TransactionSynchronizerInterceptor.class);

    @Override
    public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (ctx.isOriginLocal() || !(command instanceof TransactionBoundaryCommand)) {
            return this.invokeNext(ctx, command);
        }
        CompletableFuture<Void> releaseFuture = new CompletableFuture<Void>();
        RemoteTransaction remoteTransaction = (RemoteTransaction)((TxInvocationContext)ctx).getCacheTransaction();
        Object result = this.asyncInvokeNext(ctx, command, remoteTransaction.enterSynchronizationAsync(releaseFuture));
        return TransactionSynchronizerInterceptor.makeStage(result).andFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            log.tracef("Completing tx command release future for %s", remoteTransaction);
            releaseFuture.complete(null);
        });
    }
}

