/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.Remove;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.DynamicFilterAliasGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.persister.entity.EntityNameUse;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

@Internal
public class SingleTableEntityPersister
extends AbstractEntityPersister {
    private final int joinSpan;
    private final boolean hasDuplicateTables;
    private final String[] qualifiedTableNames;
    private final boolean[] isInverseTable;
    private final boolean[] isNullableTable;
    private final String[][] keyColumnNames;
    private final boolean[] cascadeDeleteEnabled;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final boolean[] isInverseSubclassTable;
    private final boolean[] isNullableSubclassTable;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final boolean[] isClassOrSuperclassJoin;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final Map<Object, String> subclassesByDiscriminatorValue;
    private final boolean forceDiscriminator;
    private final String discriminatorColumnName;
    private final String discriminatorColumnReaders;
    private final String discriminatorColumnReaderTemplate;
    private final String discriminatorFormulaTemplate;
    private final BasicType<?> discriminatorType;
    private final Object discriminatorValue;
    private final String discriminatorSQLValue;
    private final boolean discriminatorInsertable;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    @Deprecated
    private final String discriminatorAlias;

    @Deprecated(since="6.0")
    public SingleTableEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        this(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    public SingleTableEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, RuntimeModelCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        String rootTableName;
        Dialect dialect = creationContext.getDialect();
        SqmFunctionRegistry functionRegistry = creationContext.getFunctionRegistry();
        TypeConfiguration typeConfiguration = creationContext.getTypeConfiguration();
        this.joinSpan = persistentClass.getJoinClosureSpan() + 1;
        this.qualifiedTableNames = new String[this.joinSpan];
        Table table = persistentClass.getRootTable();
        this.qualifiedTableNames[0] = rootTableName = this.determineTableName(table);
        this.isInverseTable = new boolean[this.joinSpan];
        this.isNullableTable = new boolean[this.joinSpan];
        this.keyColumnNames = new String[this.joinSpan][];
        this.isInverseTable[0] = false;
        this.isNullableTable[0] = false;
        this.keyColumnNames[0] = this.getIdentifierColumnNames();
        this.cascadeDeleteEnabled = new boolean[this.joinSpan];
        this.customSQLInsert = new String[this.joinSpan];
        this.customSQLUpdate = new String[this.joinSpan];
        this.customSQLDelete = new String[this.joinSpan];
        this.insertCallable = new boolean[this.joinSpan];
        this.updateCallable = new boolean[this.joinSpan];
        this.deleteCallable = new boolean[this.joinSpan];
        this.insertExpectations = new Expectation[this.joinSpan];
        this.updateExpectations = new Expectation[this.joinSpan];
        this.deleteExpectations = new Expectation[this.joinSpan];
        this.customSQLInsert[0] = persistentClass.getCustomSQLInsert();
        this.insertCallable[0] = this.customSQLInsert[0] != null && persistentClass.isCustomInsertCallable();
        this.insertExpectations[0] = Expectations.appropriateExpectation(persistentClass.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[0], this.insertCallable[0]) : persistentClass.getCustomSQLInsertCheckStyle());
        this.customSQLUpdate[0] = persistentClass.getCustomSQLUpdate();
        this.updateCallable[0] = this.customSQLUpdate[0] != null && persistentClass.isCustomUpdateCallable();
        this.updateExpectations[0] = Expectations.appropriateExpectation(persistentClass.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[0], this.updateCallable[0]) : persistentClass.getCustomSQLUpdateCheckStyle());
        this.customSQLDelete[0] = persistentClass.getCustomSQLDelete();
        this.deleteCallable[0] = this.customSQLDelete[0] != null && persistentClass.isCustomDeleteCallable();
        this.deleteExpectations[0] = Expectations.appropriateExpectation(persistentClass.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[0], this.deleteCallable[0]) : persistentClass.getCustomSQLDeleteCheckStyle());
        List<Join> joinClosure = persistentClass.getJoinClosure();
        boolean hasDuplicateTableName = false;
        int j = 1;
        while (j - 1 < joinClosure.size()) {
            Join join = joinClosure.get(j - 1);
            this.qualifiedTableNames[j] = this.determineTableName(join.getTable());
            hasDuplicateTableName = hasDuplicateTableName || ArrayHelper.indexOf(this.qualifiedTableNames, j, this.qualifiedTableNames[j]) != -1;
            this.isInverseTable[j] = join.isInverse();
            this.isNullableTable[j] = join.isOptional();
            this.cascadeDeleteEnabled[j] = join.getKey().isCascadeDeleteEnabled() && dialect.supportsCascadeDelete();
            this.customSQLInsert[j] = join.getCustomSQLInsert();
            this.insertCallable[j] = this.customSQLInsert[j] != null && join.isCustomInsertCallable();
            this.insertExpectations[j] = Expectations.appropriateExpectation(join.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[j], this.insertCallable[j]) : join.getCustomSQLInsertCheckStyle());
            this.customSQLUpdate[j] = join.getCustomSQLUpdate();
            this.updateCallable[j] = this.customSQLUpdate[j] != null && join.isCustomUpdateCallable();
            this.updateExpectations[j] = Expectations.appropriateExpectation(join.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[j], this.updateCallable[j]) : join.getCustomSQLUpdateCheckStyle());
            this.customSQLDelete[j] = join.getCustomSQLDelete();
            this.deleteCallable[j] = this.customSQLDelete[j] != null && join.isCustomDeleteCallable();
            this.deleteExpectations[j] = Expectations.appropriateExpectation(join.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[j], this.deleteCallable[j]) : join.getCustomSQLDeleteCheckStyle());
            this.keyColumnNames[j] = new String[join.getKey().getColumnSpan()];
            List<Column> columns = join.getKey().getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                this.keyColumnNames[j][i] = columns.get(i).getQuotedName(dialect);
            }
            ++j;
        }
        this.hasDuplicateTables = hasDuplicateTableName;
        this.constraintOrderedTableNames = new String[this.qualifiedTableNames.length];
        this.constraintOrderedKeyColumnNames = new String[this.qualifiedTableNames.length][];
        int i = this.qualifiedTableNames.length - 1;
        int position = 0;
        while (i >= 0) {
            this.constraintOrderedTableNames[position] = this.qualifiedTableNames[i];
            this.constraintOrderedKeyColumnNames[position] = this.keyColumnNames[i];
            --i;
            ++position;
        }
        this.spaces = ArrayHelper.join(this.qualifiedTableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        ArrayList<String> subclassTables = new ArrayList<String>();
        ArrayList<String[]> joinKeyColumns = new ArrayList<String[]>();
        ArrayList<Boolean> isConcretes = new ArrayList<Boolean>();
        ArrayList<Boolean> isClassOrSuperclassJoins = new ArrayList<Boolean>();
        ArrayList<Boolean> isInverses = new ArrayList<Boolean>();
        ArrayList<Boolean> isNullables = new ArrayList<Boolean>();
        subclassTables.add(this.qualifiedTableNames[0]);
        joinKeyColumns.add(this.getIdentifierColumnNames());
        isConcretes.add(true);
        isClassOrSuperclassJoins.add(true);
        isInverses.add(false);
        isNullables.add(false);
        for (Join join : persistentClass.getSubclassJoinClosure()) {
            isConcretes.add(persistentClass.isClassOrSuperclassTable(join.getTable()));
            isClassOrSuperclassJoins.add(persistentClass.isClassOrSuperclassJoin(join));
            isInverses.add(join.isInverse());
            isNullables.add(join.isOptional());
            String joinTableName = this.determineTableName(join.getTable());
            subclassTables.add(joinTableName);
            String[] keyCols = new String[join.getKey().getColumnSpan()];
            List<Column> columns = join.getKey().getColumns();
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                keyCols[i2] = columns.get(i2).getQuotedName(dialect);
            }
            joinKeyColumns.add(keyCols);
        }
        this.subclassTableNameClosure = ArrayHelper.toStringArray(subclassTables);
        this.subclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(joinKeyColumns);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(isConcretes);
        this.isClassOrSuperclassJoin = ArrayHelper.toBooleanArray(isClassOrSuperclassJoins);
        this.isInverseSubclassTable = ArrayHelper.toBooleanArray(isInverses);
        this.isNullableSubclassTable = ArrayHelper.toBooleanArray(isNullables);
        if (persistentClass.isPolymorphic()) {
            Value discriminator = persistentClass.getDiscriminator();
            if (discriminator == null) {
                throw new MappingException("discriminator mapping required for single table polymorphic persistence");
            }
            this.forceDiscriminator = persistentClass.isForceDiscriminator();
            Selectable selectable = discriminator.getSelectables().get(0);
            this.discriminatorType = DiscriminatorHelper.getDiscriminatorType(persistentClass);
            this.discriminatorValue = DiscriminatorHelper.getDiscriminatorValue(persistentClass);
            this.discriminatorSQLValue = DiscriminatorHelper.getDiscriminatorSQLValue(persistentClass, dialect);
            this.discriminatorInsertable = SingleTableEntityPersister.isDiscriminatorInsertable(persistentClass);
            if (discriminator.hasFormula()) {
                Formula formula = (Formula)selectable;
                this.discriminatorFormulaTemplate = formula.getTemplate(dialect, typeConfiguration, functionRegistry);
                this.discriminatorColumnName = null;
                this.discriminatorColumnReaders = null;
                this.discriminatorColumnReaderTemplate = null;
                this.discriminatorAlias = "clazz_";
            } else {
                Column column = (Column)selectable;
                this.discriminatorColumnName = column.getQuotedName(dialect);
                this.discriminatorColumnReaders = column.getReadExpr(dialect);
                this.discriminatorColumnReaderTemplate = column.getTemplate(dialect, typeConfiguration, functionRegistry);
                this.discriminatorAlias = column.getAlias(dialect, persistentClass.getRootTable());
                this.discriminatorFormulaTemplate = null;
            }
        } else {
            this.forceDiscriminator = false;
            this.discriminatorInsertable = false;
            this.discriminatorColumnName = null;
            this.discriminatorColumnReaders = null;
            this.discriminatorColumnReaderTemplate = null;
            this.discriminatorAlias = null;
            this.discriminatorType = null;
            this.discriminatorValue = null;
            this.discriminatorSQLValue = null;
            this.discriminatorFormulaTemplate = null;
        }
        this.propertyTableNumbers = new int[this.getPropertySpan()];
        List<Property> propertyClosure = persistentClass.getPropertyClosure();
        for (int k = 0; k < propertyClosure.size(); ++k) {
            this.propertyTableNumbers[k] = persistentClass.getJoinNumber(propertyClosure.get(k));
        }
        ArrayList<Integer> propertyJoinNumbers = new ArrayList<Integer>();
        HashMap<Object, String> subclassesByDiscriminatorValueLocal = new HashMap<Object, String>();
        for (Property property : persistentClass.getSubclassPropertyClosure()) {
            propertyJoinNumbers.add(persistentClass.getJoinNumber(property));
        }
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(propertyJoinNumbers);
        int subclassSpan = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[subclassSpan];
        this.subclassClosure[0] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            SingleTableEntityPersister.addSubclassByDiscriminatorValue(subclassesByDiscriminatorValueLocal, this.discriminatorValue, this.getEntityName());
            List<Subclass> subclasses = persistentClass.getSubclasses();
            for (int k = 0; k < subclasses.size(); ++k) {
                Subclass subclass = subclasses.get(k);
                this.subclassClosure[k] = subclass.getEntityName();
                Object subclassDiscriminatorValue = DiscriminatorHelper.getDiscriminatorValue(subclass);
                SingleTableEntityPersister.addSubclassByDiscriminatorValue(subclassesByDiscriminatorValueLocal, subclassDiscriminatorValue, subclass.getEntityName());
            }
        }
        this.subclassesByDiscriminatorValue = CollectionHelper.toSmallMap(subclassesByDiscriminatorValueLocal);
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(creationContext.getMetadata());
    }

    private static boolean isDiscriminatorInsertable(PersistentClass persistentClass) {
        return !persistentClass.isDiscriminatorValueNull() && !persistentClass.isDiscriminatorValueNotNull() && persistentClass.isDiscriminatorInsertable() && !persistentClass.getDiscriminator().hasFormula();
    }

    private static void addSubclassByDiscriminatorValue(Map<Object, String> subclassesByDiscriminatorValue, Object discriminatorValue, String entityName) {
        String mappedEntityName = subclassesByDiscriminatorValue.put(discriminatorValue, entityName);
        if (mappedEntityName != null) {
            throw new MappingException("Entities [" + entityName + "] and [" + mappedEntityName + "] are mapped with the same discriminator value '" + discriminatorValue + "'.");
        }
    }

    @Override
    public boolean isInverseTable(int j) {
        return this.isInverseTable[j];
    }

    @Override
    protected boolean isInverseSubclassTable(int j) {
        return this.isInverseSubclassTable[j];
    }

    @Override
    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    @Override
    public String getDiscriminatorColumnReaders() {
        return this.discriminatorColumnReaders;
    }

    @Override
    public String getDiscriminatorColumnReaderTemplate() {
        return this.discriminatorColumnReaderTemplate;
    }

    @Override
    public String getDiscriminatorFormulaTemplate() {
        return this.discriminatorFormulaTemplate;
    }

    @Override
    public String getTableName() {
        return this.qualifiedTableNames[0];
    }

    @Override
    public BasicType<?> getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public Map<Object, String> getSubclassByDiscriminatorValue() {
        return this.subclassesByDiscriminatorValue;
    }

    @Override
    public TableDetails getMappedTableDetails() {
        return this.getTableMapping(0);
    }

    @Override
    public TableDetails getIdentifierTableDetails() {
        return this.getTableMapping(0);
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    @Deprecated(forRemoval=true)
    @Remove
    public String[] getSubclassClosure() {
        return this.subclassClosure;
    }

    @Override
    public String getSubclassForDiscriminatorValue(Object value) {
        if (value == null) {
            return this.subclassesByDiscriminatorValue.get(DiscriminatorHelper.NULL_DISCRIMINATOR);
        }
        String result = this.subclassesByDiscriminatorValue.get(value);
        return result == null ? this.subclassesByDiscriminatorValue.get(DiscriminatorHelper.NOT_NULL_DISCRIMINATOR) : result;
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    @Override
    protected boolean isDiscriminatorFormula() {
        return this.discriminatorColumnName == null;
    }

    @Override
    public boolean hasDuplicateTables() {
        return this.hasDuplicateTables;
    }

    @Override
    public String getTableName(int j) {
        return this.qualifiedTableNames[j];
    }

    @Override
    public String[] getKeyColumns(int j) {
        return this.keyColumnNames[j];
    }

    @Override
    public boolean isTableCascadeDeleteEnabled(int j) {
        return this.cascadeDeleteEnabled[j];
    }

    @Override
    public boolean isPropertyOfTable(int property, int j) {
        return this.propertyTableNumbers[property] == j;
    }

    @Override
    public String fromTableFragment(String name) {
        return this.getTableName() + " " + name;
    }

    @Override
    protected boolean needsDiscriminator() {
        return this.forceDiscriminator || this.isInherited();
    }

    @Override
    public String getSubclassPropertyTableName(int i) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[i]];
    }

    @Override
    protected int getSubclassPropertyTableNumber(int i) {
        return this.subclassPropertyTableNumberClosure[i];
    }

    @Override
    public int getTableSpan() {
        return this.joinSpan;
    }

    @Override
    public void addDiscriminatorToInsertGroup(MutationGroupBuilder insertGroupBuilder) {
        if (this.discriminatorInsertable) {
            TableInsertBuilder tableInsertBuilder = (TableInsertBuilder)insertGroupBuilder.getTableDetailsBuilder(this.getRootTableName());
            tableInsertBuilder.addValueColumn(this.discriminatorColumnName, this.discriminatorValue == DiscriminatorHelper.NULL_DISCRIMINATOR ? "null" : this.discriminatorSQLValue, this.getDiscriminatorMapping().getJdbcMapping());
        }
    }

    @Override
    protected int[] getPropertyTableNumbers() {
        return this.propertyTableNumbers;
    }

    @Override
    protected String[] getSubclassTableKeyColumns(int j) {
        return this.subclassTableKeyColumnClosure[j];
    }

    @Override
    public String getSubclassTableName(int j) {
        return this.subclassTableNameClosure[j];
    }

    @Override
    protected String[] getSubclassTableNames() {
        return this.subclassTableNameClosure;
    }

    @Override
    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    @Override
    protected boolean isClassOrSuperclassTable(int j) {
        return this.isClassOrSuperclassTable[j];
    }

    @Override
    protected boolean isClassOrSuperclassJoin(int j) {
        return this.isClassOrSuperclassJoin[j];
    }

    @Override
    public boolean isNullableTable(int j) {
        return this.isNullableTable[j];
    }

    @Override
    protected boolean isIdentifierTable(String tableExpression) {
        return tableExpression.equals(this.getRootTableName());
    }

    @Override
    public boolean hasSkippableTables() {
        return this.hasAnySkippableTables(this.isNullableTable, this.isInverseTable);
    }

    @Override
    protected boolean isNullableSubclassTable(int j) {
        return this.isNullableSubclassTable[j];
    }

    @Override
    protected boolean hasMultipleTables() {
        return this.getTableSpan() > 1;
    }

    @Override
    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    @Override
    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new DynamicFilterAliasGenerator(this.qualifiedTableNames, rootAlias);
    }

    @Override
    public void pruneForSubclasses(TableGroup tableGroup, Map<String, EntityNameUse> entityNameUses) {
        if (!this.needsDiscriminator() && entityNameUses.isEmpty()) {
            return;
        }
        MappingMetamodelImplementor mappingMetamodel = this.getFactory().getRuntimeMetamodels().getMappingMetamodel();
        boolean containsTreatUse = false;
        for (Map.Entry<String, EntityNameUse> entry : entityNameUses.entrySet()) {
            EntityPersister entityPersister;
            Object useKind = entry.getValue().getKind();
            if (useKind == EntityNameUse.UseKind.PROJECTION || useKind == EntityNameUse.UseKind.EXPRESSION || (entityPersister = mappingMetamodel.getEntityDescriptor(entry.getKey())).isAbstract() || this.isTypeOrSuperType(entityPersister) || useKind != EntityNameUse.UseKind.TREAT) continue;
            containsTreatUse = true;
            break;
        }
        if (!containsTreatUse) {
            return;
        }
        InFragment frag = new InFragment();
        if (this.isDiscriminatorFormula()) {
            frag.setFormula("t", this.getDiscriminatorFormulaTemplate());
        } else {
            frag.setColumn("t", this.getDiscriminatorColumnName());
        }
        boolean containsNotNull = false;
        for (Map.Entry entry : entityNameUses.entrySet()) {
            EntityPersister persister;
            EntityNameUse.UseKind useKind = ((EntityNameUse)entry.getValue()).getKind();
            if (useKind == EntityNameUse.UseKind.PROJECTION || useKind == EntityNameUse.UseKind.EXPRESSION || (persister = mappingMetamodel.getEntityDescriptor((String)entry.getKey())).isAbstract() || this != persister && this.isTypeOrSuperType(persister)) continue;
            containsNotNull = containsNotNull || "not null".equals(persister.getDiscriminatorSQLValue());
            frag.addValue(persister.getDiscriminatorSQLValue());
        }
        List<String> discriminatorSQLValues = Arrays.asList(((SingleTableEntityPersister)this.getRootEntityDescriptor()).fullDiscriminatorSQLValues);
        if (frag.getValues().size() == discriminatorSQLValues.size()) {
            return;
        }
        NamedTableReference namedTableReference = (NamedTableReference)tableGroup.getPrimaryTableReference();
        if (containsNotNull) {
            StringBuilder sb = new StringBuilder();
            Object lhs = this.isDiscriminatorFormula() ? StringHelper.replace(this.getDiscriminatorFormulaTemplate(), "$PlaceHolder$", "t") : "t." + this.getDiscriminatorColumnName();
            sb.append(" or ").append((String)lhs).append(" is not in (");
            for (String discriminatorSQLValue : discriminatorSQLValues) {
                if (frag.getValues().contains(discriminatorSQLValue)) continue;
                sb.append((String)lhs).append((Object)discriminatorSQLValue);
            }
            sb.append(") and ").append((String)lhs).append(" is not null");
            frag.getValues().remove("not null");
            namedTableReference.setPrunedTableExpression("(select * from " + this.getTableName() + " t where " + frag.toFragmentString() + sb + ")");
        } else {
            namedTableReference.setPrunedTableExpression("(select * from " + this.getTableName() + " t where " + frag.toFragmentString() + ")");
        }
    }

    @Override
    public void visitConstraintOrderedTables(EntityMappingType.ConstraintOrderedTableConsumer consumer) {
        int i = 0;
        while (i < this.constraintOrderedTableNames.length) {
            String tableName = this.constraintOrderedTableNames[i];
            int tablePosition = i++;
            consumer.consume(tableName, () -> columnConsumer -> columnConsumer.accept(tableName, this.constraintOrderedKeyColumnNames[tablePosition], this.getIdentifierMapping()::getJdbcMapping));
        }
    }

    @Override
    protected void visitMutabilityOrderedTables(AbstractEntityPersister.MutabilityOrderedTableConsumer consumer) {
        int i = 0;
        while (i < this.qualifiedTableNames.length) {
            String tableName = this.qualifiedTableNames[i];
            int tableIndex = i++;
            consumer.consume(tableName, tableIndex, () -> columnConsumer -> columnConsumer.accept(tableName, this.getIdentifierMapping(), this.keyColumnNames[tableIndex]));
        }
    }

    @Override
    public String getDiscriminatorAlias() {
        return this.discriminatorAlias;
    }
}

