/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.configuration;

import ai.digital.deploy.permissions.configuration.JpaDialect$;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.reflect.ScalaSignature;

@EnableTransactionManagement
@Configuration
@Autowired
@EnableJpaRepositories(basePackages={"ai.digital.deploy.permissions.repository.jpa", "ai.digital.deploy.permissions.repository.model"}, transactionManagerRef="permissionTransactionManager", entityManagerFactoryRef="permissionEntityManagerFactory", enableDefaultTransactions=false)
@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u0005\u000b\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)a\b\u0001C\u0001\u007f!)Q\t\u0001C\u0001\r\")q\u000b\u0001C\u00051\")\u0001\u000e\u0001C\u0001S\")!\u000f\u0001C\u0001g\")1\u0010\u0001C\u0001y\nQ\u0002+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3Ka\u0006\u001cuN\u001c4jO*\u00111\u0002D\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\u00055q\u0011a\u00039fe6L7o]5p]NT!a\u0004\t\u0002\r\u0011,\u0007\u000f\\8z\u0015\t\t\"#A\u0004eS\u001eLG/\u00197\u000b\u0003M\t!!Y5\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0007\u0015tg\u000f\u0005\u0002\u001fM5\tqD\u0003\u0002\u001dA)\u0011\u0011EI\u0001\u0005G>\u0014XM\u0003\u0002$I\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001&\u0003\ry'oZ\u0005\u0003O}\u00111\"\u00128wSJ|g.\\3oi\u0006!\u0002/\u001a:nSN\u001c\u0018n\u001c8ECR\f7k\\;sG\u0016\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0007M\fHNC\u0001/\u0003\u0015Q\u0017M^1y\u0013\t\u00014F\u0001\u0006ECR\f7k\\;sG\u0016DCA\u0001\u001a={A\u00111GO\u0007\u0002i)\u0011QGN\u0001\u000bC:tw\u000e^1uS>t'BA\u001c9\u0003\u001d1\u0017m\u0019;pefT!!\u000f\u0012\u0002\u000b\t,\u0017M\\:\n\u0005m\"$!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u0005A\u0013A\u0002\u001fj]&$h\bF\u0002A\u0005\u000e\u0003\"!\u0011\u0001\u000e\u0003)AQ\u0001H\u0002A\u0002uAQ\u0001K\u0002A\u0002%BCa\u0011\u001a={\u0005q\u0002/\u001a:nSN\u001c\u0018n\u001c8F]RLG/_'b]\u0006<WM\u001d$bGR|'/\u001f\u000b\u0002\u000fB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0004UB\f'B\u0001'#\u0003\ry'/\\\u0005\u0003\u001d&\u0013\u0001%\u00112tiJ\f7\r^#oi&$\u00180T1oC\u001e,'OR1di>\u0014\u0018PQ3b]\"\u0012A\u0001\u0015\t\u0003#Vk\u0011A\u0015\u0006\u0003kMS!\u0001\u0016\u0012\u0002\u000f\r|g\u000e^3yi&\u0011aK\u0015\u0002\u0005\u0005\u0016\fg.\u0001\u000bhKR\u001c\u0006O]5oO*\u0003\u0018\r\u0015:pa\u0016\u0014H/\u001f\u000b\u00043\u00124\u0007C\u0001.b\u001d\tYv\f\u0005\u0002]15\tQL\u0003\u0002_)\u00051AH]8pizJ!\u0001\u0019\r\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003AbAQ!Z\u0003A\u0002e\u000b\u0001bY8oMB\u000bG\u000f\u001b\u0005\u0006O\u0016\u0001\r!W\u0001\bI\u00164\u0017-\u001e7u\u0003MA\u0017NY3s]\u0006$X\r\u0015:pa\u0016\u0014H/[3t)\u0005Q\u0007CA6q\u001b\u0005a'BA7o\u0003\u0011)H/\u001b7\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001c\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\b9fe6L7o]5p]R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM]\u000b\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011qOI\u0001\fiJ\fgn]1di&|g.\u0003\u0002zm\nQ\u0002\u000b\\1uM>\u0014X\u000e\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\"\u0012q\u0001U\u0001\u001fa\u0016\u0014X.[:tS>tW\t_2faRLwN\u001c+sC:\u001cH.\u0019;j_:,\u0012! \t\u0004}\u0006\u0015Q\"A@\u000b\u0007U\n\tAC\u0002\u0002\u0004\t\n1\u0001Z1p\u0013\r\t9a \u0002-!\u0016\u00148/[:uK:\u001cW-\u0012=dKB$\u0018n\u001c8Ue\u0006t7\u000f\\1uS>t\u0007k\\:u!J|7-Z:t_JD#\u0001\u0003))\u0007\u0001\ti\u0001\u0005\u0003\u0002\u0010\u0005MQBAA\t\u0015\t)d/\u0003\u0003\u0002\u0016\u0005E!aG#oC\ndW\r\u0016:b]N\f7\r^5p]6\u000bg.Y4f[\u0016tG\u000fK\u0002\u0001\u00033\u00012!UA\u000e\u0013\r\tiB\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8)\u0007\u0001\t\t\u0003E\u00024\u0003GI1!!\n5\u0005%\tU\u000f^8xSJ,G\rK\n\u0001\u0003S\ty$!\u0011\u0002L\u00055\u0013qJA)\u0003'\n)\u0006\u0005\u0003\u0002,\u0005mRBAA\u0017\u0015\u0011\ty#!\r\u0002\r\r|gNZ5h\u0015\u0011\t\u0019$!\u000e\u0002\u0015I,\u0007o\\:ji>\u0014\u0018PC\u0002K\u0003oQ1!!\u000f#\u0003\u0011!\u0017\r^1\n\t\u0005u\u0012Q\u0006\u0002\u0016\u000b:\f'\r\\3Ka\u0006\u0014V\r]8tSR|'/[3t\u00031\u0011\u0017m]3QC\u000e\\\u0017mZ3tY\u0011\t\u0019%a\u0012\"\u0005\u0005\u0015\u0013\u0001L1j]\u0011Lw-\u001b;bY:\"W\r\u001d7ps:\u0002XM]7jgNLwN\\:/e\u0016\u0004xn]5u_JLhF\u001b9bC\t\tI%\u0001\u0018bS:\"\u0017nZ5uC2tC-\u001a9m_ft\u0003/\u001a:nSN\u001c\u0018n\u001c8t]I,\u0007o\\:ji>\u0014\u0018PL7pI\u0016d\u0017!\u0006;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ\u0014VMZ\u0011\u0002e\u00069RM\u001c;jifl\u0015M\\1hKJ4\u0015m\u0019;pef\u0014VMZ\u0011\u0002\u000b\u0006IRM\\1cY\u0016$UMZ1vYR$&/\u00198tC\u000e$\u0018n\u001c8t3\u0005\u0001\u0001")
public class PermissionServiceJpaConfig {
    private final Environment env;
    @Qualifier(value="permissionDataSource")
    private final DataSource permissionDataSource;

    @Bean
    public AbstractEntityManagerFactoryBean permissionEntityManagerFactory() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.permissionDataSource);
        em.setPackagesToScan(new String[]{"ai.digital.deploy.permissions.model"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        em.setJpaProperties(this.hibernateProperties());
        return em;
    }

    private String getSpringJpaProperty(String confPath, String string) {
        return this.env.getProperty("spring.jpa.properties." + confPath, string);
    }

    public Properties hibernateProperties() {
        Properties properties = new Properties();
        properties.put("org.hibernate.envers.audit_strategy", this.getSpringJpaProperty("org.hibernate.envers.audit_strategy", "org.hibernate.envers.strategy.internal.ValidityAuditStrategy"));
        properties.put("org.hibernate.envers.audit_table_suffix", this.getSpringJpaProperty("org.hibernate.envers.audit_table_suffix", "_audit"));
        properties.put("org.hibernate.envers.store_data_at_delete", this.getSpringJpaProperty("org.hibernate.envers.store_data_at_delete", "true"));
        properties.put("hibernate.id.new_generator_mappings", this.getSpringJpaProperty("hibernate.id.new_generator_mappings", "false"));
        properties.put("hibernate.dialect", JpaDialect$.MODULE$.initializeDialect(this.permissionDataSource).dialect());
        properties.put("hibernate.id.db_structure_naming_strategy", this.getSpringJpaProperty("hibernate.id.db_structure_naming_strategy", "legacy"));
        properties.put("hibernate.type.preferred_uuid_jdbc_type", this.getSpringJpaProperty("hibernate.type.preferred_uuid_jdbc_type", "CHAR"));
        return properties;
    }

    @Bean
    public PlatformTransactionManager permissionTransactionManager() {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(this.permissionEntityManagerFactory().getObject());
        transactionManager.setDataSource(this.permissionDataSource);
        return transactionManager;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor permissionExceptionTranslation() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    public PermissionServiceJpaConfig(Environment env, @Qualifier(value="permissionDataSource") DataSource permissionDataSource) {
        this.env = env;
        this.permissionDataSource = permissionDataSource;
    }
}

