/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.user;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class OAuth2UserAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 620L;
    private final String authority;
    private final Map<String, Object> attributes;

    public OAuth2UserAuthority(Map<String, Object> attributes) {
        this("OAUTH2_USER", attributes);
    }

    public OAuth2UserAuthority(String authority, Map<String, Object> attributes) {
        Assert.hasText((String)authority, (String)"authority cannot be empty");
        Assert.notEmpty(attributes, (String)"attributes cannot be empty");
        this.authority = authority;
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(attributes));
    }

    public String getAuthority() {
        return this.authority;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2UserAuthority that = (OAuth2UserAuthority)obj;
        if (!this.getAuthority().equals(that.getAuthority())) {
            return false;
        }
        Map<String, Object> thatAttributes = that.getAttributes();
        if (this.getAttributes().size() != thatAttributes.size()) {
            return false;
        }
        for (Map.Entry<String, Object> e : this.getAttributes().entrySet()) {
            Object thatValue;
            String key = e.getKey();
            Object value = OAuth2UserAuthority.convertURLIfNecessary(e.getValue());
            if (!(value == null ? thatAttributes.get(key) != null || !thatAttributes.containsKey(key) : !value.equals(thatValue = OAuth2UserAuthority.convertURLIfNecessary(thatAttributes.get(key))))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.getAuthority().hashCode();
        result = 31 * result;
        for (Map.Entry<String, Object> e : this.getAttributes().entrySet()) {
            String key = e.getKey();
            Object value = OAuth2UserAuthority.convertURLIfNecessary(e.getValue());
            result += Objects.hashCode(key) ^ Objects.hashCode(value);
        }
        return result;
    }

    public String toString() {
        return this.getAuthority();
    }

    private static Object convertURLIfNecessary(Object value) {
        return value instanceof URL ? ((URL)value).toExternalForm() : value;
    }
}

