/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.ConsumedPage;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.transaction.Transaction;

public interface PageSubscription {
    public PagingStore getPagingStore();

    public void stop();

    public void counterSnapshot();

    public void notEmpty();

    public void bookmark(PagePosition var1) throws Exception;

    public PageSubscriptionCounter getCounter();

    public long getMessageCount();

    public boolean isCounterPending();

    public long getPersistentSize();

    public long getId();

    public boolean isPersistent();

    public boolean isPaging();

    public PageIterator iterator();

    public PageIterator iterator(boolean var1);

    public void destroy() throws Exception;

    public void scheduleCleanupCheck();

    public void cleanupEntries(boolean var1) throws Exception;

    public void onPageModeCleared(Transaction var1) throws Exception;

    public void disableAutoCleanup();

    public void enableAutoCleanup();

    public void ack(PagedReference var1) throws Exception;

    public boolean contains(PagedReference var1) throws Exception;

    public void confirmPosition(PagePosition var1) throws Exception;

    public void ackTx(Transaction var1, PagedReference var2) throws Exception;

    public void confirmPosition(Transaction var1, PagePosition var2) throws Exception;

    public void scanAck(BooleanSupplier var1, ToIntFunction<PagedReference> var2, Runnable var3, Runnable var4);

    public long getFirstPage();

    public void reloadACK(PagePosition var1);

    public boolean reloadPageCompletion(PagePosition var1) throws Exception;

    public void reloadPageInfo(long var1);

    public void positionIgnored(PagePosition var1);

    public void lateDeliveryRollback(PagePosition var1);

    public void reloadPreparedACK(Transaction var1, PagePosition var2);

    public void processReload() throws Exception;

    public void addPendingDelivery(PagedMessage var1);

    public void redeliver(PageIterator var1, PagedReference var2);

    public void printDebug();

    public boolean isComplete(long var1);

    public void forEachConsumedPage(Consumer<ConsumedPage> var1);

    public PagedMessage queryMessage(PagePosition var1);

    public void setQueue(Queue var1);

    public Queue getQueue();

    public void onDeletePage(Page var1) throws Exception;

    public long getDeliveredCount();

    public long getDeliveredSize();

    public void incrementDeliveredSize(long var1);

    public void removePendingDelivery(PagedMessage var1);

    public ConsumedPage locatePageInfo(long var1);
}

