/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.envers.internal.tools.graph.Vertex;

public class TopologicalSort<R> {
    private List<R> sorted;
    private int time;

    private void process(Vertex<R> v) {
        if (v.getStartTime() != 0) {
            return;
        }
        v.setStartTime(this.time++);
        for (Vertex<R> n : v.getNeighbours()) {
            this.process(n);
        }
        v.setEndTime(this.time++);
        this.sorted.add(v.getRepresentation());
    }

    public List<R> sort(Collection<Vertex<R>> vertices) {
        this.sorted = new ArrayList<R>(vertices.size());
        this.time = 1;
        for (Vertex<R> v : vertices) {
            if (v.getEndTime() != 0) continue;
            this.process(v);
        }
        Collections.reverse(this.sorted);
        return this.sorted;
    }
}

