/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InvocationCallback;
import org.infinispan.interceptors.InvocationExceptionFunction;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.InvocationSuccessFunction;

public class ExceptionSyncInvocationStage
extends InvocationStage {
    private final Throwable throwable;

    public ExceptionSyncInvocationStage(Throwable throwable) {
        this.throwable = CompletableFutures.extractException((Throwable)throwable);
    }

    public Object thenApply(InvocationContext ctx, VisitableCommand command, InvocationSuccessFunction function) {
        return this;
    }

    public Object thenAccept(InvocationContext ctx, VisitableCommand command, InvocationSuccessAction function) {
        return this;
    }

    public Object andExceptionally(InvocationContext ctx, VisitableCommand command, InvocationExceptionFunction function) {
        try {
            return function.apply(ctx, command, this.throwable);
        }
        catch (Throwable t) {
            return new ExceptionSyncInvocationStage(t);
        }
    }

    public Object andFinally(InvocationContext ctx, VisitableCommand command, InvocationFinallyAction action) {
        try {
            action.accept(ctx, command, null, this.throwable);
            return this;
        }
        catch (Throwable t) {
            return new ExceptionSyncInvocationStage(t);
        }
    }

    public Object andHandle(InvocationContext ctx, VisitableCommand command, InvocationFinallyFunction function) {
        try {
            return function.apply(ctx, command, null, this.throwable);
        }
        catch (Throwable t) {
            return new ExceptionSyncInvocationStage(t);
        }
    }

    @Override
    public Object thenReturn(InvocationContext ctx, VisitableCommand command, Object returnValue) {
        return this;
    }

    @Override
    public Object get() throws Throwable {
        throw this.throwable;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return CompletableFutures.completedExceptionFuture((Throwable)this.throwable);
    }

    public Object addCallback(InvocationContext ctx, VisitableCommand command, InvocationCallback function) {
        try {
            return function.apply(ctx, command, null, this.throwable);
        }
        catch (Throwable t) {
            return new ExceptionSyncInvocationStage(t);
        }
    }
}

