/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import java.time.Duration;
import java.util.List;
import org.springframework.cloud.client.hypermedia.RemoteResource;
import org.springframework.scheduling.config.ContextLifecycleScheduledTaskRegistrar;
import org.springframework.scheduling.config.IntervalTask;

public class RemoteResourceRefresher
extends ContextLifecycleScheduledTaskRegistrar {
    private final List<RemoteResource> discoveredResources;
    private final int fixedDelay;
    private final int initialDelay;

    public RemoteResourceRefresher(List<RemoteResource> discoveredResources, int fixedDelay, int initialDelay) {
        this.discoveredResources = discoveredResources;
        this.fixedDelay = fixedDelay;
        this.initialDelay = initialDelay;
    }

    public void afterPropertiesSet() {
        for (RemoteResource resource : this.discoveredResources) {
            this.addFixedDelayTask(new IntervalTask(resource::verifyOrDiscover, Duration.ofMillis(this.fixedDelay), Duration.ofMillis(this.initialDelay)));
        }
        super.afterPropertiesSet();
    }
}

