/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameError;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEventOrError;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.ProtocolException;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class FrameLogger$ {
    public static final FrameLogger$ MODULE$ = new FrameLogger$();

    public final int maxBytes() {
        return 16;
    }

    public BidiFlow<FrameEventOrError, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> logFramesIfEnabled(boolean shouldLog) {
        if (shouldLog) {
            return this.bidi();
        }
        return BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<FrameEventOrError, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> bidi() {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$1 = "\u001b[31mDOWN\u001b[0m";
        Function1 & Serializable x$2 = (Function1 & Serializable)frameEvent -> MODULE$.logEvent((FrameEventOrError)frameEvent);
        LoggingAdapter x$3 = qual$1.log$default$3("\u001b[31mDOWN\u001b[0m", (Function1)x$2);
        Flow qual$2 = Flow$.MODULE$.apply();
        String x$4 = "\u001b[32m UP \u001b[0m";
        Function1 & Serializable x$5 = (Function1 & Serializable)frameEvent -> MODULE$.logEvent((FrameEventOrError)frameEvent);
        LoggingAdapter x$6 = qual$2.log$default$3("\u001b[32m UP \u001b[0m", (Function1)x$5);
        return BidiFlow$.MODULE$.fromFlows((Graph)qual$1.log("\u001b[31mDOWN\u001b[0m", (Function1)x$2, x$3), (Graph)qual$2.log("\u001b[32m UP \u001b[0m", (Function1)x$5, x$6)).addAttributes(Attributes$.MODULE$.apply((Attributes.Attribute)new Attributes.LogLevels(Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel())));
    }

    public String logEvent(FrameEventOrError frameEvent) {
        FrameEventOrError frameEventOrError = frameEvent;
        if (frameEventOrError instanceof FrameStart) {
            FrameStart frameStart = (FrameStart)frameEventOrError;
            FrameHeader header = frameStart.header();
            ByteString data = frameStart.data();
            return FrameLogger$.displayLogEntry$1(header.opcode().short(), header.length(), FrameLogger$.hex$1(data), frameStart.lastPart(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{FrameLogger$.flag$1(header.fin(), "FIN"), FrameLogger$.flag$1(header.rsv1(), "RSV1"), FrameLogger$.flag$1(header.rsv2(), "RSV2"), FrameLogger$.flag$1(header.rsv3(), "RSV3")}));
        }
        if (frameEventOrError instanceof FrameData) {
            FrameData frameData = (FrameData)frameEventOrError;
            ByteString data = frameData.data();
            boolean lastPart = frameData.lastPart();
            return FrameLogger$.displayLogEntry$1("DATA", 0L, FrameLogger$.hex$1(data), lastPart, (Seq)Nil$.MODULE$);
        }
        if (frameEventOrError instanceof FrameError) {
            FrameError frameError = (FrameError)frameEventOrError;
            ProtocolException ex = frameError.p();
            return new StringBuilder(16).append("\u001b[31m").append("Error: ").append(ex.getMessage()).append("\u001b[0m").toString();
        }
        throw new MatchError((Object)frameEventOrError);
    }

    private static final String displayLogEntry$1(String frameType, long length, String data, boolean lastPart, Seq flags) {
        String f = flags.nonEmpty() ? new StringBuilder(6).append(" ").append("\u001b[31m").append(((IterableOnceOps)flags.flatten(Predef$.MODULE$.$conforms())).mkString(" ")).toString() : "";
        String l = length > 0L ? StringOps$.MODULE$.format$extension(" %s%d bytes", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"\u001b[33m", BoxesRunTime.boxToLong((long)length)})) : "";
        return new StringBuilder(10).append("\u001b[32m").append(frameType).append(f).append(l).append("\u001b[0m").append(" ").append(data).append((Object)(!lastPart ? " ..." : "")).toString();
    }

    private static final Option flag$1(boolean value, String name) {
        if (value) {
            return new Some((Object)name);
        }
        return None$.MODULE$;
    }

    private static final String hex$1(ByteString bytes) {
        int num = package$.MODULE$.min(16, bytes.size());
        String ellipsis = num < bytes.size() ? new StringBuilder(18).append(" [... ").append(bytes.size() - num).append(" more bytes]").toString() : "";
        ByteString first = bytes.take(num);
        String h = ((IterableOnceOps)first.map((Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})))).mkString(" ");
        String ascii = ((IterableOnceOps)first.map((Function1 & Serializable)b -> BoxesRunTime.boxToCharacter((char)LogByteStringTools$.MODULE$.asASCII(BoxesRunTime.unboxToByte((Object)b))))).mkString();
        return new StringBuilder(21).append("\u001b[37m").append(h).append("\u001b[0m").append(" | ").append("\u001b[37m").append(ascii).append("\u001b[0m").append(ellipsis).toString();
    }

    private FrameLogger$() {
    }
}

