/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.web.server.DefaultOidcLogoutTokenValidatorFactory;
import org.springframework.security.config.web.server.OidcBackChannelLogoutAuthentication;
import org.springframework.security.config.web.server.OidcLogoutAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.authentication.logout.OidcLogoutToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoderFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

final class OidcBackChannelLogoutReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private ReactiveJwtDecoderFactory<ClientRegistration> logoutTokenDecoderFactory;

    OidcBackChannelLogoutReactiveAuthenticationManager() {
        DefaultOidcLogoutTokenValidatorFactory jwtValidator = new DefaultOidcLogoutTokenValidatorFactory();
        this.logoutTokenDecoderFactory = clientRegistration -> {
            String jwkSetUri = clientRegistration.getProviderDetails().getJwkSetUri();
            if (!StringUtils.hasText((String)jwkSetUri)) {
                OAuth2Error oauth2Error = new OAuth2Error("missing_signature_verifier", "Failed to find a Signature Verifier for Client Registration: '" + clientRegistration.getRegistrationId() + "'. Check to ensure you have configured the JwkSet URI.", null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            DefaultJOSEObjectTypeVerifier typeVerifier = new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{null, JOSEObjectType.JWT, new JOSEObjectType("logout+jwt")});
            NimbusReactiveJwtDecoder decoder = NimbusReactiveJwtDecoder.withJwkSetUri((String)jwkSetUri).jwtProcessorCustomizer(arg_0 -> OidcBackChannelLogoutReactiveAuthenticationManager.lambda$new$0((JOSEObjectTypeVerifier)typeVerifier, arg_0)).build();
            decoder.setJwtValidator(jwtValidator.apply((ClientRegistration)clientRegistration));
            decoder.setClaimSetConverter((Converter)new ClaimTypeConverter(OidcIdTokenDecoderFactory.createDefaultClaimTypeConverters()));
            return decoder;
        };
    }

    public Mono<Authentication> authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof OidcLogoutAuthenticationToken)) {
            return Mono.empty();
        }
        OidcLogoutAuthenticationToken token = (OidcLogoutAuthenticationToken)authentication;
        String logoutToken = token.getLogoutToken();
        ClientRegistration registration = token.getClientRegistration();
        return this.decode(registration, logoutToken).map(jwt -> OidcLogoutToken.withTokenValue((String)logoutToken).claims(claims -> claims.putAll(jwt.getClaims())).build()).map(OidcBackChannelLogoutAuthentication::new);
    }

    private Mono<Jwt> decode(ClientRegistration registration, String token) {
        ReactiveJwtDecoder logoutTokenDecoder = this.logoutTokenDecoderFactory.createDecoder((Object)registration);
        return logoutTokenDecoder.decode(token).onErrorResume(Exception.class, ex -> {
            if (ex instanceof BadJwtException) {
                OAuth2Error error = new OAuth2Error("invalid_request", ex.getMessage(), "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
                return Mono.error((Throwable)new OAuth2AuthenticationException(error, (Throwable)ex));
            }
            return Mono.error((Throwable)new AuthenticationServiceException(ex.getMessage(), (Throwable)ex));
        });
    }

    void setLogoutTokenDecoderFactory(ReactiveJwtDecoderFactory<ClientRegistration> logoutTokenDecoderFactory) {
        Assert.notNull(logoutTokenDecoderFactory, (String)"logoutTokenDecoderFactory cannot be null");
        this.logoutTokenDecoderFactory = logoutTokenDecoderFactory;
    }

    private static /* synthetic */ void lambda$new$0(JOSEObjectTypeVerifier typeVerifier, ConfigurableJWTProcessor processor) {
        processor.setJWSTypeVerifier(typeVerifier);
    }
}

