/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.AsyncProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RxJavaInterop
extends org.infinispan.commons.reactive.RxJavaInterop {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final BiFunction<Object, Object, Flowable<Object>> combineBiFunction = (v1, v2) -> {
        if (v1 != null) {
            if (v2 != null) {
                return Flowable.just((Object)v1, (Object)v2);
            }
            return Flowable.just((Object)v1);
        }
        if (v2 != null) {
            return Flowable.just((Object)v2);
        }
        return Flowable.empty();
    };

    private RxJavaInterop() {
    }

    public static <R> Flowable<R> voidCompletionStageToFlowable(CompletionStage<Void> stage) {
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            return Flowable.empty();
        }
        AsyncProcessor ap = AsyncProcessor.create();
        stage.whenComplete((value, t) -> {
            if (t != null) {
                ap.onError(t);
            } else {
                ap.onComplete();
            }
        });
        return ap;
    }

    public static <R> Flowable<R> voidCompletionStageToFlowable(CompletionStage<Void> stage, boolean ignoreErrorIfCancelled) {
        if (!ignoreErrorIfCancelled) {
            return RxJavaInterop.voidCompletionStageToFlowable(stage);
        }
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            return Flowable.empty();
        }
        AtomicBoolean cancelled = new AtomicBoolean();
        UnicastProcessor ap = UnicastProcessor.create((int)1, () -> cancelled.set(true));
        stage.whenComplete((value, t) -> {
            if (t != null) {
                if (!cancelled.get()) {
                    ap.onError(t);
                } else {
                    log.debug("Ignoring throwable as the UnicastProcessor is already completed", (Throwable)t);
                }
            } else {
                ap.onComplete();
            }
        });
        return ap;
    }

    public static <I> BiFunction<I, I, Flowable<I>> combinedBiFunction() {
        return combineBiFunction;
    }
}

