/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInputImpl;
import org.jboss.resteasy.plugins.server.Cleanables;
import org.jboss.resteasy.spi.EntityOutputStream;
import org.jboss.resteasy.spi.multipart.MultipartContent;
import org.jboss.resteasy.spi.util.Types;

@Provider
public class EntityPartFilter
implements ContainerRequestFilter {
    @Context
    private Providers providers;
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String boundary;
        MediaType mediaType = requestContext.getMediaType();
        if (MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(mediaType) && !ResteasyContext.hasContextData(MultipartContent.class) && (boundary = (String)mediaType.getParameters().get("boundary")) != null) {
            Method method = this.resourceInfo.getResourceMethod();
            if (EntityPartFilter.hasEntityPartParameter(EntityPartFilter.findAllParameters(this.resourceInfo.getResourceClass(), method))) {
                MultipartFormDataInputImpl input = new MultipartFormDataInputImpl(requestContext.getMediaType(), this.providers);
                CopyInputStream copyInputStream = new CopyInputStream(requestContext.getEntityStream());
                input.parse(copyInputStream);
                requestContext.setEntityStream(copyInputStream.entity.toInputStream());
                List<EntityPart> parts = List.copyOf(input.toEntityParts());
                MultipartContent multipartParts = () -> parts;
                ResteasyContext.pushContext(MultipartContent.class, (Object)multipartParts);
                Cleanables cleanables = (Cleanables)ResteasyContext.getContextData(Cleanables.class);
                if (cleanables != null) {
                    cleanables.addCleanable(() -> ResteasyContext.popContextData(MultipartContent.class));
                }
            }
        }
    }

    private static boolean hasEntityPartParameter(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(FormParam.class) && !parameter.isAnnotationPresent(org.jboss.resteasy.annotations.jaxrs.FormParam.class)) continue;
            if (parameter.getType().isAssignableFrom(EntityPart.class)) {
                return true;
            }
            if (!parameter.getType().isAssignableFrom(List.class) || !Types.isGenericTypeInstanceOf(EntityPart.class, (Type)parameter.getParameterizedType())) continue;
            return true;
        }
        return false;
    }

    private static List<Parameter> findAllParameters(Class<?> resourceClass, Method method) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Collections.addAll(parameters, method.getParameters());
        for (Class<?> intf : resourceClass.getInterfaces()) {
            EntityPartFilter.addAnnotations(intf, method, parameters);
        }
        if (resourceClass.getSuperclass() != null) {
            Class<?> superType = resourceClass.getSuperclass();
            EntityPartFilter.addAnnotations(superType, method, parameters);
            for (Class<?> intf : superType.getInterfaces()) {
                EntityPartFilter.addAnnotations(intf, method, parameters);
            }
        }
        return parameters;
    }

    private static void addAnnotations(Class<?> type, Method method, List<Parameter> parameters) {
        try {
            Method superMethod = type.getMethod(method.getName(), method.getParameterTypes());
            Collections.addAll(parameters, superMethod.getParameters());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static class CopyInputStream
    extends InputStream {
        private final InputStream delegate;
        private final EntityOutputStream entity;

        private CopyInputStream(InputStream delegate) {
            this.delegate = delegate;
            this.entity = new EntityOutputStream();
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = this.delegate.read(b);
            this.write(b, 0, read);
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.delegate.read(b, off, len);
            this.write(b, off, read);
            return read;
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            byte[] read = this.delegate.readAllBytes();
            if (read.length > 0) {
                this.entity.write(read);
            }
            return read;
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            byte[] read = this.delegate.readNBytes(len);
            if (read.length > 0) {
                this.entity.write(read);
            }
            return read;
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            int read = this.delegate.readNBytes(b, off, len);
            this.write(b, off, read);
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.entity.close();
            }
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            return this.delegate.transferTo(out);
        }

        @Override
        public int read() throws IOException {
            int read = this.delegate.read();
            if (read != -1) {
                this.entity.write(read);
            }
            return read;
        }

        private void write(byte[] b, int off, int read) throws IOException {
            int writeLen;
            if (read > 0 && (writeLen = read - off) > 0) {
                this.entity.write(b, off, writeLen);
            }
        }
    }
}

