/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.AbstractService;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.posix.PosixProcess;
import org.rzo.yajsw.os.posix.PosixUtils;
import org.rzo.yajsw.os.posix.UpdateRcParser;
import org.rzo.yajsw.os.posix.VelocityLog;
import org.rzo.yajsw.util.Utils;

public class PosixService
extends AbstractService
implements Constants {
    protected String _daemonDir;
    String _daemonTemplate;
    String _daemonScript;
    String _wrapperPidFile;
    String _appPidFile;
    String _pidDir;
    String _confFile;
    int _stopTimeout;
    boolean _useSystemd;
    String[] _startCmd;
    String[] _execCmd;
    String[] _stopCmd;
    String[] _statusCmd;
    List<String> _ksLinks = new ArrayList<String>();
    UpdateRcParser _updateRcParser;
    PosixUtils _utils = new PosixUtils();

    @Override
    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this._utils.setLog(logger);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init() {
        void var25_41;
        void var25_39;
        void var25_37;
        String java;
        JavaHome javaHome;
        String wrapperJar;
        block47: {
            String apidName;
            File pidFile;
            File daemonScript;
            File daemonTemplate;
            block46: {
                String pidName;
                File pidDir;
                block45: {
                    File f;
                    if (this._name == null) {
                        this._logger.warning("no name for daemon -> abort");
                        return;
                    }
                    this._useSystemd = this.isUseSystemd();
                    this._daemonDir = this._config.getString("wrapper.daemon.dir", this.getDefaultDaemonDir());
                    File daemonDir = new File(this._daemonDir);
                    if (!daemonDir.exists() || !daemonDir.isDirectory()) {
                        this._logger.warning("Error " + this._daemonDir + " : is not a directory");
                        return;
                    }
                    this._pidDir = this._config.getString("wrapper.daemon.pid.dir", "/var/run");
                    pidDir = new File(this._pidDir);
                    if (!pidDir.exists() || !pidDir.isDirectory()) {
                        this._logger.warning("Error " + this._pidDir + " : is not a directory");
                        return;
                    }
                    wrapperJar = WrapperLoader.getWrapperJar().trim();
                    String wrapperHome = ".";
                    try {
                        wrapperHome = new File(wrapperJar).getParentFile().getCanonicalPath();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    String confFile = null;
                    YajswConfigurationImpl conf = (YajswConfigurationImpl)this._config;
                    confFile = !conf.isLocalFile() ? conf.getCachedPath() : this._config.getString("wrapper.config");
                    String confDir = null;
                    if (confFile != null && (f = new File(confFile)).exists()) {
                        try {
                            confDir = f.getParentFile().getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (confDir == null) {
                        confDir = wrapperHome + "/conf";
                    }
                    if (confFile == null) {
                        this._logger.warning("no conf file found -> abort");
                        return;
                    }
                    try {
                        this._confFile = new File(confFile).getCanonicalPath();
                    }
                    catch (IOException e) {
                        this._logger.throwing(this.getClass().getName(), "init", e);
                    }
                    javaHome = OperatingSystem.instance().getJavaHome(this._config);
                    java = javaHome.findJava(null, null);
                    boolean bDone = false;
                    File fJava = java == null ? null : new File(java);
                    String custProcName = this._config.getString("wrapper.java.customProcName");
                    if (custProcName != null && custProcName.length() > 0) {
                        File fcustom = new File(custProcName);
                        bDone = false;
                        while (!bDone) {
                            if (fcustom.exists() && fcustom.canExecute()) {
                                this._config.setProperty("wrapper.java.custProcName", (Object)fcustom.getAbsolutePath());
                                bDone = true;
                                break;
                            }
                            if (fJava == null) {
                                bDone = true;
                                break;
                            }
                            if (fcustom.isAbsolute() && fcustom.getParentFile().exists()) {
                                if (PosixProcess.CLibrary.INSTANCE.symlink(fJava.getAbsolutePath(), fcustom.getAbsolutePath()) != 0 && this._logger != null) {
                                    this._logger.info("error on creating script link " + fcustom);
                                }
                            } else {
                                File tmpPath = new File(this._config.getString("wrapper.tmp.path", "/tmp"));
                                if (tmpPath.exists()) {
                                    File link = new File(tmpPath, fcustom.getName());
                                    if (PosixProcess.CLibrary.INSTANCE.symlink(fJava.getAbsolutePath(), link.getAbsolutePath()) != 0) {
                                        if (this._logger != null) {
                                            this._logger.info("error on creating script link " + link);
                                        }
                                    } else {
                                        this._config.setProperty("wrapper.java.custProcName", (Object)link.getAbsolutePath());
                                    }
                                } else if (this._logger != null) {
                                    this._logger.info("error on creating customProcName link - temp directory [" + tmpPath.getAbsolutePath() + "] does not exist");
                                }
                            }
                            bDone = true;
                        }
                    }
                    String defaultTemplate = this._useSystemd ? "/templates/systemd.vm" : "/templates/daemon.vm";
                    this._daemonTemplate = this._config.getString("wrapper.daemon.template", wrapperHome + defaultTemplate);
                    daemonTemplate = new File(this._daemonTemplate);
                    if (!daemonTemplate.exists() || !daemonTemplate.isFile()) {
                        if (this._logger != null) {
                            this._logger.warning("Error " + this._daemonTemplate + " : template file not found");
                        }
                        return;
                    }
                    daemonScript = this.getDaemonScript();
                    if (daemonScript.exists() && this._logger != null) {
                        this._logger.info(daemonScript.getAbsolutePath() + " already exists");
                    }
                    pidName = null;
                    try {
                        pidName = this._config.getString("wrapper.pidfile", new File(pidDir, "wrapper." + this.getName() + ".pid").getCanonicalPath());
                    }
                    catch (IOException e) {
                        if (this._logger == null) break block45;
                        this._logger.throwing(this.getClass().getName(), "init", e);
                    }
                }
                pidFile = new File(pidName);
                apidName = null;
                try {
                    apidName = this._config.getString("wrapper.java.pidfile", new File(pidDir, "wrapper.java." + this.getName() + ".pid").getCanonicalPath());
                }
                catch (IOException e) {
                    if (this._logger == null) break block46;
                    this._logger.throwing(this.getClass().getName(), "init", e);
                }
            }
            File apidFile = new File(apidName);
            try {
                this._daemonTemplate = daemonTemplate.getCanonicalPath();
                this._wrapperPidFile = pidFile.getCanonicalPath();
                this._appPidFile = apidFile.getCanonicalPath();
                this._daemonScript = daemonScript.getCanonicalPath();
            }
            catch (Exception ex) {
                if (this._logger == null) break block47;
                this._logger.throwing(this.getClass().getName(), "init", ex);
            }
        }
        java = javaHome.findJava(this._config.getString("wrapper.ntservice.java.command"), this._config.getString("wrapper.java.customProcName"));
        String tmpDir = this._config.getString("wrapper.tmp.path", System.getProperty("jna_tmpdir", null));
        ArrayList<String> result = new ArrayList<String>();
        String opt = null;
        if (tmpDir != null) {
            opt = Utils.getDOption("jna_tmpdir", tmpDir);
            result.add(opt);
        }
        YajswConfigurationImpl config = (YajswConfigurationImpl)this._config;
        Iterator it = config.subset("wrapper").getKeys();
        while (it.hasNext()) {
            try {
                config.getProperty((String)it.next());
            }
            catch (Exception exception) {}
        }
        if (this._config.getBoolean("wrapper.save_interpolated", true)) {
            for (Map.Entry entry : config.getEnvLookupSet().entrySet()) {
                if (((String)entry.getKey()).contains("password") || result.contains(opt = Utils.getDOption((String)entry.getKey(), (String)entry.getValue()))) continue;
                result.add(opt);
            }
        }
        it = this._config.getKeys("wrapper.ntservice.additional");
        while (it.hasNext()) {
            String string = (String)it.next();
            String value = this._config.getString(string);
            result.add(value);
        }
        List configs = this._config.getList("wrapperx.config");
        this._startCmd = new String[10 + result.size() + configs.size() + this._cliProperties.size()];
        this._startCmd[0] = java;
        this._startCmd[1] = Utils.getDOption("wrapper.pidfile", this._wrapperPidFile);
        this._startCmd[2] = "-Dwrapper.service=true";
        this._startCmd[3] = "-Dwrapper.visible=false";
        boolean bl = false;
        while (var25_37 < result.size()) {
            this._startCmd[4 + var25_37] = (String)result.get((int)var25_37);
            ++var25_37;
        }
        this._startCmd[4 + result.size()] = null;
        this._startCmd[5 + result.size()] = null;
        this._startCmd[6 + result.size()] = "-jar";
        this._startCmd[7 + result.size()] = wrapperJar;
        this._startCmd[8 + result.size()] = "-tx";
        this._startCmd[9 + result.size()] = this._confFile;
        boolean bl2 = true;
        while (var25_39 < configs.size()) {
            this._startCmd[9 + result.size() + var25_39] = configs.get((int)var25_39).toString();
            ++var25_39;
        }
        System.out.println("_cliProperties.size() " + this._cliProperties.size());
        boolean bl3 = false;
        while (var25_41 < this._cliProperties.size()) {
            this._startCmd[9 + result.size() + configs.size() + var25_41 + 1] = (String)this._cliProperties.get((int)var25_41);
            ++var25_41;
        }
        this._execCmd = (String[])this._startCmd.clone();
        this._execCmd[8 + result.size()] = "-c";
        if (this._config.getBoolean("wrapper.ntservice.debug", false)) {
            this._execCmd[4 + result.size()] = "-Xdebug";
            this._execCmd[5 + result.size()] = "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=1044";
        }
        this._stopCmd = (String[])this._startCmd.clone();
        this._stopCmd[8 + result.size()] = "-px";
        this._statusCmd = (String[])this._startCmd.clone();
        this._statusCmd[8 + result.size()] = "-qx";
        String string = this._daemonDir + "/" + "rc5.d";
        String runLevelDir = this._config.getString("wrapper.daemon.run_level_dir", string);
        this._updateRcParser = new UpdateRcParser(this._config.getString("wrapper.daemon.update_rc", null), runLevelDir, this.getName());
        this._ksLinks.addAll(this._updateRcParser.getStartLinks());
        this._ksLinks.addAll(this._updateRcParser.getStopLinks());
        this._stopTimeout = this._config.getInt("wrapper.shutdown.timeout", 30) * 1000;
    }

    protected String getDefaultDaemonDir() {
        if (this._useSystemd) {
            return "/etc/systemd/system";
        }
        return "/etc/init.d";
    }

    protected File getDaemonScript() {
        String fileName = this.getName();
        if (this._useSystemd) {
            fileName = fileName + ".service";
        }
        return new File(new File(this._daemonDir), fileName);
    }

    @Override
    public boolean install() {
        if (this._daemonScript == null) {
            if (this._logger != null) {
                this._logger.warning("Error : not initialized -> abort");
            }
            return false;
        }
        try {
            File daemonTemplate = new File(this._daemonTemplate);
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"file");
            ve.setProperty("file.resource.loader.path", (Object)daemonTemplate.getParent());
            ve.setProperty("runtime.log.logsystem.class", (Object)VelocityLog.class.getCanonicalName());
            VelocityLog.setLogger(this._logger);
            ve.init();
            Template t = null;
            try {
                t = ve.getTemplate(daemonTemplate.getName());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
            VelocityContext context = new VelocityContext();
            context.put("w_name", (Object)this._name);
            context.put("w_long_name", (Object)this._displayName);
            context.put("w_start_cmd", (Object)this.toStrCommand(this._startCmd));
            context.put("w_stop_cmd", (Object)this.toStrCommand(this._stopCmd));
            context.put("w_status_cmd", (Object)this.toStrCommand(this._statusCmd));
            context.put("w_description", (Object)this._description);
            context.put("w_conf_file", (Object)this._confFile);
            context.put("w_app_pid_file", (Object)this._appPidFile);
            context.put("w_wrapper_pid_file", (Object)this._wrapperPidFile);
            context.put("w_start_levels", (Object)this._updateRcParser.getStartLevels());
            context.put("w_stop_levels", (Object)this._updateRcParser.getStopLevels());
            context.put("w_start_priority", (Object)this._config.getString("chkconfig_start_priority", ""));
            context.put("w_stop_priority", (Object)this._config.getString("chkconfig_stop_priority", ""));
            context.put("start_dependencies", (Object)this.getStartDependencies(this._useSystemd));
            context.put("stop_dependencies", (Object)this.getInternalStopDependencies());
            FileWriter writer = new FileWriter(this._daemonScript);
            t.merge((Context)context, (Writer)writer);
            writer.flush();
            writer.close();
            File daemonScript = new File(this._daemonScript);
            if (daemonScript.exists()) {
                if (this._logger != null) {
                    this._logger.warning("created daemon script: " + this._daemonScript);
                }
            } else if (this._logger != null) {
                this._logger.warning("error creating daemon script: " + this._daemonScript);
            }
            Runtime.getRuntime().exec("chmod 755 " + this._daemonScript);
            if ("AUTO_START".equals(this._config.getString("wrapper.ntservice.starttype", "AUTO_START")) || "DELAYED_AUTO_START".equals(this._config.getString("wrapper.ntservice.starttype", "AUTO_START"))) {
                if (this._useSystemd) {
                    this._utils.osCommand("systemctl enable " + this._daemonScript, 10000L);
                } else {
                    for (String link : this._ksLinks) {
                        if (PosixProcess.CLibrary.INSTANCE.symlink(this._daemonScript, link) != 0) {
                            if (this._logger == null) continue;
                            this._logger.info("error on creating script link " + link);
                            continue;
                        }
                        if (new File(link).exists()) {
                            if (this._logger == null) continue;
                            this._logger.info("created link : " + link);
                            continue;
                        }
                        if (this._logger == null) continue;
                        this._logger.info("error on creating script link " + link);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (this._logger != null) {
                this._logger.throwing(this.getClass().getName(), "install", ex);
            } else {
                ex.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private boolean isUseSystemd() {
        String required = this._config.getString("wrapper.daemon.system");
        if (required == null) {
            return this.systemDInstalled();
        }
        return "systemd".equals(required);
    }

    private boolean systemDInstalled() {
        String cmd = "ps --no-headers -o comm 1";
        String process1 = this._utils.osCommand(cmd, 2000L);
        if (process1 == null) {
            if (this._logger != null) {
                this._logger.warning("Warning error executing\"" + cmd + "\"");
            }
            return false;
        }
        return process1.contains("systemd");
    }

    private String getInternalStopDependencies() {
        String result = "";
        String[] dependencies = super.getStopDependencies();
        if (dependencies != null) {
            for (String dep : dependencies) {
                result = result + dep + " ";
            }
        }
        return result;
    }

    private String getStartDependencies(boolean systemd) {
        String result = "";
        String[] dependencies = super.getDependencies();
        if (dependencies != null) {
            for (String dep : dependencies) {
                if (!dep.contains(".")) {
                    dep = dep + ".service";
                }
                result = result + dep + " ";
            }
        }
        return result;
    }

    private String toStrCommand(String[] cmd) {
        StringBuffer tmp = new StringBuffer();
        for (String s : cmd) {
            if (s != null && s.contains(" ") && !s.contains("\"")) {
                tmp.append("\"");
                tmp.append(s);
                tmp.append("\"");
            } else if (s != null) {
                tmp.append(s);
            }
            if (s == null || s == cmd[cmd.length - 1]) continue;
            tmp.append(" ");
        }
        return tmp.toString();
    }

    public boolean isInstalled() {
        return this._daemonScript != null && new File(this._daemonScript).exists();
    }

    public boolean isRunning() {
        int pid = this.getPid();
        if (pid < 0) {
            return false;
        }
        Process p = OperatingSystem.instance().processManagerInstance().getProcess(pid);
        return p != null && p.isRunning();
    }

    @Override
    public boolean start() {
        if (this.isRunning()) {
            if (this._logger != null) {
                this._logger.info("already running");
            }
            return true;
        }
        File f = new File(this._daemonScript);
        if (!OperatingSystem.instance().setWorkingDir(f.getParent())) {
            if (this._logger != null) {
                this._logger.warning("could not set working dir. pls check configuration or user rights :" + f.getParent());
            } else {
                System.out.println("could not set working dir. pls check configuration or user rights :" + f.getParent());
            }
        }
        if (this._useSystemd) {
            String txt = this._utils.osCommand("systemctl start " + this.getName(), 45000L);
            if (this._logger != null) {
                this._logger.info(txt);
            }
        } else {
            String txt = this._utils.osCommand(this._daemonScript + " start", 45000L);
            if (this._logger != null) {
                this._logger.info(txt);
            }
        }
        return this.isRunning();
    }

    @Override
    public boolean stop() {
        if (this._useSystemd) {
            String txt = this._utils.osCommand("systemctl stop " + this.getName(), this._stopTimeout);
            if (this._logger != null) {
                this._logger.info(txt);
            }
        } else {
            String txt = this._utils.osCommand(this._daemonScript + " stop", this._stopTimeout);
            if (this._logger != null) {
                this._logger.info(txt);
            }
        }
        return !this.isRunning();
    }

    public boolean startProcess() {
        block4: {
            if (this.isRunning()) {
                this._logger.info("already running");
                return true;
            }
            try {
                if (this._logger != null) {
                    this._logger.info("calling " + this.toStrCommand(this._execCmd));
                }
                Runtime.getRuntime().exec(this.cleanCmd(this._execCmd));
            }
            catch (Exception e) {
                if (this._logger == null) break block4;
                this._logger.throwing(this.getClass().getName(), "startProcess", e);
            }
        }
        return true;
    }

    public boolean stopProcess() {
        int pid = this.getPid();
        if (this._logger != null) {
            this._logger.info("stop daemon with pid " + pid);
        }
        if (pid <= 0) {
            return false;
        }
        Process p = OperatingSystem.instance().processManagerInstance().getProcess(pid);
        if (p == null) {
            if (this._logger != null) {
                this._logger.info("process not running");
            }
            return true;
        }
        p.stop(this._stopTimeout, 0);
        int apid = this.getAppPid();
        if (this._logger != null) {
            this._logger.info("stop daemon app with pid " + apid);
        }
        if (apid <= 0) {
            return false;
        }
        Process ap = OperatingSystem.instance().processManagerInstance().getProcess(apid);
        if (ap != null) {
            ap.kill(999);
        }
        return true;
    }

    @Override
    public boolean uninstall() {
        if (this.isRunning()) {
            this.stop();
        }
        if (this._useSystemd) {
            this._utils.osCommand("systemctl disable " + this._daemonScript, 10000L);
        }
        new File(this._daemonScript).delete();
        if (!this._useSystemd) {
            for (String link : this._ksLinks) {
                new File(link).delete();
            }
        }
        return true;
    }

    @Override
    public int state() {
        int result = 0;
        if (new File(this._daemonScript).exists()) {
            result |= 1;
        }
        if (this.isRunning()) {
            result |= 2;
        }
        return result;
    }

    public int getPid() {
        block4: {
            if (this._logger != null) {
                this._logger.info("wrapper pid file: " + this._wrapperPidFile);
            }
            if (this._wrapperPidFile != null && new File(this._wrapperPidFile).exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this._wrapperPidFile));
                    String pid = reader.readLine();
                    reader.close();
                    return Integer.parseInt(pid);
                }
                catch (Exception e) {
                    if (this._logger == null) break block4;
                    this._logger.throwing(this.getClass().getName(), "getPid", e);
                }
            }
        }
        return -1;
    }

    public int getAppPid() {
        block3: {
            this._logger.info("app pid file: " + this._appPidFile);
            if (this._appPidFile != null && new File(this._appPidFile).exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this._appPidFile));
                    String pid = reader.readLine();
                    reader.close();
                    return Integer.parseInt(pid);
                }
                catch (Exception e) {
                    if (this._logger == null) break block3;
                    this._logger.throwing(this.getClass().getName(), "getAppPid", e);
                }
            }
        }
        return -1;
    }

    public String[] cleanCmd(String[] cmd) {
        ArrayList<String> cmdl = new ArrayList<String>();
        for (String s : cmd) {
            if (s == null || "".equals(s)) continue;
            cmdl.add(s);
        }
        String[] result = new String[cmdl.size()];
        int i = 0;
        for (String s : cmdl) {
            result[i++] = s;
        }
        return result;
    }
}

