/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.PluginsInZipExtension;
import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.TypePluginMappingManager;
import com.xebialabs.deployit.booter.local.generator.TypeGenerators;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import com.xebialabs.xlplatform.synthetic.xml.SyntheticXmlDocument;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.immutable.List;
import scala.util.Try;

class TypeSystemBootstrapper {
    private static final String PLUGINS = File.separator + "plugins" + File.separator;
    private final Scannit scannit;
    private final TypeDefinitions typeDefinitions;
    private final TypeGenerators typeGenerators;
    private static final Logger logger = LoggerFactory.getLogger(TypeSystemBootstrapper.class);

    TypeSystemBootstrapper(IDescriptorRegistry registry, Scannit scannit) {
        this.scannit = scannit;
        this.typeDefinitions = new TypeDefinitions(registry);
        this.typeGenerators = new TypeGenerators(scannit);
    }

    TypeDefinitions loadTypes() {
        logger.info("Initializing type system.");
        this.scanClasses();
        this.scanSynthetics();
        this.scanZipBasedDefinitions();
        this.typeDefinitions.registerTypes();
        this.typeGenerators.generateTypeDefinitions(this.typeDefinitions);
        this.typeDefinitions.registerTypes();
        return this.typeDefinitions;
    }

    private void scanClasses() {
        this.typeDefinitions.defineType(ConfigurationItem.class);
        Set cis = this.scannit.getSubTypesOf(ConfigurationItem.class);
        for (Class ci : cis) {
            this.typeDefinitions.defineType(ci);
            TypePluginMappingManager.loadTypePluginMapping(ci, this.typeDefinitions.getDescriptorRegistry());
        }
    }

    private void scanSynthetics() {
        try {
            ArrayList<TypeSpecification> types = new ArrayList<TypeSpecification>();
            ArrayList<TypeModificationSpecification> typeModifications = new ArrayList<TypeModificationSpecification>();
            this.readSyntheticXml("synthetic.xml", types, typeModifications);
            this.readSyntheticXml("synthetic-test.xml", types, typeModifications);
            types.forEach(this.typeDefinitions::defineType);
            typeModifications.forEach(this.typeDefinitions::modifyType);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read synthetic type definitions.", ex);
        }
    }

    private void scanZipBasedDefinitions() {
        ArrayList<TypeSpecification> types = new ArrayList<TypeSpecification>();
        try {
            this.readTypeDefinitionsFromZipForXml("type-definitions.xml");
            this.readTypeDefinitionsFromZipForYaml("type-definitions.yaml", types);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read synthetic type definitions.", ex);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void readSyntheticXml(String name, java.util.List<TypeSpecification> types, java.util.List<TypeModificationSpecification> typeModifications) throws IOException {
        Enumeration<URL> syntheticXMLs = ClassLoaderUtils$.MODULE$.classLoader().getResources(name);
        for (URL syntheticXML : this.sortedResources(syntheticXMLs)) {
            logger.debug("Scanning synthetic XML: {}", (Object)syntheticXML);
            SyntheticXmlDocument syntheticXml = SyntheticXmlDocument.read(syntheticXML);
            types.addAll(syntheticXml.getTypes());
            typeModifications.addAll(syntheticXml.getTypeModifications());
            TypePluginMappingManager.loadTypePluginMapping(syntheticXML, syntheticXml);
        }
    }

    private void readTypeDefinitionsFromZipForXml(String name) throws IOException {
        Enumeration<URL> syntheticXMLs = ClassLoaderUtils$.MODULE$.classLoader().getResources(name);
        for (URL syntheticXML : this.sortedResources(syntheticXMLs)) {
            logger.debug("Scanning Type Defintions in XML: {}", (Object)syntheticXML);
            SyntheticXmlDocument syntheticXml = SyntheticXmlDocument.read(syntheticXML);
            TypePluginMappingManager.loadTypePluginMapping(syntheticXML, syntheticXml);
        }
    }

    private void readTypeDefinitionsFromZipForYaml(String name, java.util.List<TypeSpecification> types) throws IOException, URISyntaxException {
        Enumeration<URL> syntheticXMLs = ClassLoaderUtils$.MODULE$.classLoader().getResources(name);
        PluginsInZipExtension pluginsInZipExtension = new PluginsInZipExtension();
        for (URL syntheticXML : this.sortedResources(syntheticXMLs)) {
            File zipFile;
            logger.debug("Scanning Type Defintions in YAML: {}", (Object)syntheticXML);
            String filePath = syntheticXML.getPath().replace("!/type-definitions.yaml", "");
            if (!filePath.endsWith(".zip") || !(zipFile = new File(URI.create(filePath))).exists()) continue;
            Option<Try<List<TypeSpecification>>> result = pluginsInZipExtension.extractFrom(zipFile);
            ((List)((Try)result.get()).get()).foreach(types::add);
            TypePluginMappingManager.loadTypePluginMapping(syntheticXML, (List<TypeSpecification>)((List)((Try)result.get()).get()));
        }
    }

    private java.util.List<URL> sortedResources(Enumeration<URL> syntheticXMLs) {
        ArrayList<URL> files = Collections.list(syntheticXMLs);
        return Stream.concat(this.allButPlugins(files), this.sortedPlugins(files)).collect(Collectors.toList());
    }

    private Stream<URL> allButPlugins(java.util.List<URL> files) {
        return files.stream().filter(this.filterByFolder(PLUGINS).negate());
    }

    private Predicate<URL> filterByFolder(String s) {
        return p -> this.decode((URL)p).contains(s);
    }

    private String decode(URL url) {
        String decodedString = "";
        try {
            decodedString = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedString;
    }

    private Stream<URL> sortedPlugins(java.util.List<URL> files) {
        return files.stream().filter(this.filterByFolder(PLUGINS)).sorted(this::sortByPluginFolderName);
    }

    private int sortByPluginFolderName(URL url1, URL url2) {
        return this.getPluginFolderName(url1).compareTo(this.getPluginFolderName(url2));
    }

    private String getPluginFolderName(URL url) {
        String path = this.decode(url);
        return path.substring(path.lastIndexOf(PLUGINS) + PLUGINS.length());
    }
}

