/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.loader;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.shared.common.error.StandardException;

public class ClassInspector {
    private static final String[] primTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] nonPrimTypeNames = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private static final String OBJECT_TYPE_NAME = "java.lang.Object";
    private static final String STRING_TYPE_NAME = "java.lang.String";
    private static final String BIGDECIMAL_TYPE_NAME = "java.math.BigDecimal";
    private final ClassFactory cf;

    public ClassInspector(ClassFactory classFactory) {
        this.cf = classFactory;
    }

    public boolean instanceOf(String string, Object object) throws ClassNotFoundException {
        Class<?> clazz = this.getClass(string);
        if (clazz == null) {
            return false;
        }
        return clazz.isInstance(object);
    }

    public boolean assignableTo(String string, String string2) {
        try {
            Class<?> clazz = this.getClass(string2);
            if (clazz == null) {
                return false;
            }
            Class<?> clazz2 = this.getClass(string);
            if (clazz2 == null) {
                return !clazz.isPrimitive() || clazz == Void.TYPE;
            }
            return clazz.isAssignableFrom(clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean accessible(String string) throws ClassNotFoundException {
        Class<?> clazz = this.getClass(string);
        if (clazz == null) {
            return false;
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public String getType(Member member) {
        Class<Object> clazz = member instanceof Method ? ((Method)member).getReturnType() : (member instanceof Field ? ((Field)member).getType() : (member instanceof Constructor ? ((Constructor)member).getDeclaringClass() : Void.TYPE));
        return ClassInspector.readableClassName(clazz);
    }

    public Member findPublicMethod(String string, String string2, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean bl, boolean bl2, boolean bl3) throws ClassNotFoundException, StandardException {
        Class[] classArray;
        Class[] classArray2;
        Class<?> clazz;
        block13: {
            clazz = this.getClass(string);
            if (clazz == null) {
                return null;
            }
            if (clazz.isPrimitive()) {
                return null;
            }
            if (stringArray == null) {
                Method[] methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    if (bl && !Modifier.isStatic(methodArray[i].getModifiers()) || bl3 && !this.isVarArgsMethod(methodArray[i]) || !string2.equals(methodArray[i].getName())) continue;
                    return methodArray[i];
                }
                return null;
            }
            classArray2 = new Class[stringArray.length];
            classArray = null;
            if (stringArray2 != null) {
                classArray = new Class[stringArray2.length];
            }
            for (int i = 0; i < classArray2.length; ++i) {
                classArray2[i] = this.getClass(stringArray[i]);
                if (stringArray2 == null) continue;
                classArray[i] = stringArray2[i].equals(stringArray[i]) ? null : this.getClass(stringArray2[i]);
            }
            if (classArray2.length == 0) {
                try {
                    Method method = clazz.getMethod(string2, classArray2);
                    if (bl && !Modifier.isStatic(method.getModifiers())) {
                        return null;
                    }
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (clazz.isInterface()) break block13;
                    return null;
                }
            }
        }
        Member[] memberArray = clazz.getMethods();
        if (clazz.isInterface()) {
            Method[] methodArray = Object.class.getMethods();
            if (memberArray.length == 0) {
                memberArray = methodArray;
            } else {
                Member[] memberArray2 = new Member[memberArray.length + methodArray.length];
                System.arraycopy(memberArray, 0, memberArray2, 0, memberArray.length);
                System.arraycopy(methodArray, 0, memberArray2, memberArray.length, methodArray.length);
                memberArray = memberArray2;
            }
        }
        return this.resolveMethod(clazz, string2, classArray2, classArray, blArray, bl, bl2, memberArray, bl3);
    }

    public Member findPublicField(String string, String string2, boolean bl) throws StandardException {
        ReflectiveOperationException reflectiveOperationException;
        block8: {
            reflectiveOperationException = null;
            try {
                Class<?> clazz = this.getClass(string);
                if (clazz == null) {
                    return null;
                }
                if (clazz.isArray() || clazz.isPrimitive()) {
                    return null;
                }
                int n = bl ? 9 : 1;
                Field field = clazz.getField(string2);
                if ((field.getModifiers() & n) != n) break block8;
                if (clazz.isInterface() || field.getDeclaringClass().equals(clazz)) {
                    return field;
                }
                try {
                    Field field2 = clazz.getDeclaredField(string2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return field;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                reflectiveOperationException = classNotFoundException;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                reflectiveOperationException = noSuchFieldException;
            }
        }
        throw StandardException.newException((String)(bl ? "42X72" : "42X68"), (Throwable)reflectiveOperationException, (Object[])new Object[]{string2, string});
    }

    public Member findPublicConstructor(String string, String[] stringArray, String[] stringArray2, boolean[] blArray) throws ClassNotFoundException, StandardException {
        Class[] classArray;
        Class[] classArray2;
        Class<?> clazz;
        block8: {
            clazz = this.getClass(string);
            if (clazz == null) {
                return null;
            }
            if (clazz.isArray() || clazz.isPrimitive() || clazz.isInterface()) {
                return null;
            }
            classArray2 = new Class[stringArray.length];
            classArray = null;
            if (stringArray2 != null) {
                classArray = new Class[stringArray2.length];
            }
            boolean bl = false;
            for (int i = 0; i < classArray2.length; ++i) {
                classArray2[i] = this.getClass(stringArray[i]);
                if (classArray2[i] == null) {
                    bl = true;
                }
                if (stringArray2 == null) continue;
                classArray[i] = stringArray2[i].equals(stringArray[i]) ? null : this.getClass(stringArray2[i]);
            }
            try {
                if (!bl && stringArray2 == null) {
                    Constructor<?> constructor = clazz.getConstructor(classArray2);
                    return constructor;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (classArray2.length != 0) break block8;
                return null;
            }
        }
        return this.resolveMethod(clazz, "<init>", classArray2, classArray, blArray, false, false, clazz.getConstructors(), false);
    }

    public Class[][] getTypeBounds(Class clazz, Class clazz2) throws StandardException {
        Type[] typeArray;
        if (clazz2 == null) {
            return null;
        }
        for (Type type : typeArray = clazz2.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type type2;
            if (!(type instanceof ParameterizedType) || clazz != (type2 = (parameterizedType = (ParameterizedType)type).getRawType())) continue;
            return this.findTypeBounds(parameterizedType);
        }
        return this.getTypeBounds(clazz, clazz2.getSuperclass());
    }

    public boolean isVarArgsMethod(Member member) {
        if (member instanceof Method) {
            return ((Method)member).isVarArgs();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).isVarArgs();
        }
        return false;
    }

    public Class<?>[] getGenericParameterTypes(Class clazz, Class clazz2) throws StandardException {
        ArrayList<Class<?>> arrayList = this.getTypeChain(clazz, clazz2);
        HashMap<Type, Type> hashMap = this.getResolvedTypes(arrayList);
        ArrayList<Class<?>> arrayList2 = this.getParameterTypes(clazz, hashMap);
        if (arrayList2 == null) {
            return null;
        }
        return arrayList2.toArray(new Class[arrayList2.size()]);
    }

    public String[] getParameterTypes(Member member) {
        Class<?>[] classArray = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ClassInspector.readableClassName(classArray[i]);
        }
        return stringArray;
    }

    public static boolean primitiveType(String string) {
        for (int i = 0; i < primTypeNames.length; ++i) {
            if (!string.equals(primTypeNames[i])) continue;
            return true;
        }
        return false;
    }

    private Member resolveMethod(Class clazz, String string, Class[] classArray, Class[] classArray2, boolean[] blArray, boolean bl, boolean bl2, Member[] memberArray, boolean bl3) throws StandardException {
        boolean bl4;
        boolean bl5;
        int n = -1;
        boolean bl6 = true;
        do {
            bl5 = false;
            bl4 = false;
            block1: for (int i = 0; i < memberArray.length; ++i) {
                Class[] classArray3;
                Member member = memberArray[i];
                if (member == null || i == n) continue;
                Class[] classArray4 = classArray3 = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
                if (bl6) {
                    if (bl2) {
                        if (classArray3.length < classArray.length) {
                            memberArray[i] = null;
                            continue;
                        }
                    } else if (classArray3.length != classArray.length) {
                        memberArray[i] = null;
                        continue;
                    }
                    if (bl && !Modifier.isStatic(member.getModifiers())) {
                        memberArray[i] = null;
                        continue;
                    }
                    if (bl3 && !this.isVarArgsMethod(member)) {
                        memberArray[i] = null;
                        continue;
                    }
                    if (!string.startsWith("<") && !string.equals(member.getName())) {
                        memberArray[i] = null;
                        continue;
                    }
                    if (bl2) {
                        for (int j = classArray.length - 1; j < classArray3.length; ++j) {
                            if (classArray3[j].equals(classArray[classArray.length - 1])) continue;
                            memberArray[i] = null;
                            continue block1;
                        }
                    }
                }
                if (!this.signatureConvertableFromTo(classArray, classArray2, classArray3, blArray, true)) {
                    memberArray[i] = null;
                    continue;
                }
                if (n == -1) {
                    n = i;
                    continue;
                }
                bl5 = true;
            }
            bl6 = false;
        } while (bl5 && bl4);
        if (bl5) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < classArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(classArray[i] == null ? "null" : classArray[i].getName());
                if (classArray2 == null || classArray2[i] == null) continue;
                stringBuffer.append("(").append(classArray2[i].getName()).append(")");
            }
            throw StandardException.newException((String)"42X73", (Object[])new Object[]{clazz.getName(), string, stringBuffer.toString()});
        }
        if (n == -1) {
            return null;
        }
        return memberArray[n];
    }

    public Class<?> getClass(String string) throws ClassNotFoundException {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = n2 - 2;
        while (n3 >= 0 && string.substring(n3, n3 + 2).equals("[]")) {
            ++n;
            n3 -= 2;
            n2 -= 2;
        }
        if (n2 <= 0) {
            return Class.forName(string);
        }
        if (n != 0) {
            string = string.substring(0, n2);
        }
        Class<Object> clazz = null;
        if (n2 >= 3 && n2 <= 7) {
            if ("int".equals(string)) {
                clazz = Integer.TYPE;
            } else if ("short".equals(string)) {
                clazz = Short.TYPE;
            } else if ("boolean".equals(string)) {
                clazz = Boolean.TYPE;
            } else if ("byte".equals(string)) {
                clazz = Byte.TYPE;
            } else if ("float".equals(string)) {
                clazz = Float.TYPE;
            } else if ("double".equals(string)) {
                clazz = Double.TYPE;
            } else if ("long".equals(string)) {
                clazz = Long.TYPE;
            } else if ("char".equals(string)) {
                clazz = Character.TYPE;
            } else if ("void".equals(string)) {
                clazz = Void.TYPE;
            }
        }
        if (clazz == null) {
            clazz = this.cf.loadApplicationClass(string);
        }
        if (n == 0) {
            return clazz;
        }
        if (n == 1) {
            return Array.newInstance(clazz, 0).getClass();
        }
        return Array.newInstance(clazz, new int[n]).getClass();
    }

    private boolean signatureConvertableFromTo(Class[] classArray, Class[] classArray2, Class[] classArray3, boolean[] blArray, boolean bl) {
        int n = classArray.length;
        if (classArray3.length < n) {
            n = classArray3.length;
        }
        for (int i = 0; i < n; ++i) {
            Class clazz = classArray[i];
            Class clazz2 = classArray3[i];
            if (!(clazz == null ? clazz2.isPrimitive() && (classArray2 == null || blArray != null && !blArray[i]) : !this.classConvertableFromTo(clazz, clazz2, bl) && (classArray2 == null || classArray2[i] == null || !this.classConvertableFromTo(classArray2[i], clazz2, bl)))) continue;
            return false;
        }
        return true;
    }

    protected boolean classConvertableFromTo(Class clazz, Class clazz2, boolean bl) {
        if (clazz.getName().equals(clazz2.getName())) {
            return true;
        }
        if (clazz.isArray() && clazz2.isArray()) {
            return this.classConvertableFromTo(clazz.getComponentType(), clazz2.getComponentType(), bl);
        }
        if (!(clazz2.isPrimitive() && clazz.isPrimitive() || bl)) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        return clazz == Boolean.TYPE || string.equals(nonPrimTypeNames[0]) ? clazz2 == Boolean.TYPE || string2.equals(nonPrimTypeNames[0]) : (clazz == Byte.TYPE || string.equals(nonPrimTypeNames[1]) ? clazz2 == Byte.TYPE || string2.equals(nonPrimTypeNames[1]) || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Character.TYPE || string.equals(nonPrimTypeNames[2]) ? clazz2 == Character.TYPE || string2.equals(nonPrimTypeNames[2]) || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Short.TYPE || string.equals(nonPrimTypeNames[3]) ? clazz2 == Short.TYPE || string2.equals(nonPrimTypeNames[4]) : (clazz == Integer.TYPE || string.equals(nonPrimTypeNames[4]) ? clazz2 == Integer.TYPE || string2.equals(nonPrimTypeNames[4]) : (clazz == Long.TYPE || string.equals(nonPrimTypeNames[5]) ? clazz2 == Long.TYPE || string2.equals(nonPrimTypeNames[5]) : (clazz == Float.TYPE || string.equals(nonPrimTypeNames[6]) ? clazz2 == Float.TYPE || string2.equals(nonPrimTypeNames[6]) : !(clazz != Double.TYPE && !string.equals(nonPrimTypeNames[7]) || clazz2 != Double.TYPE && !string2.equals(nonPrimTypeNames[7]))))))));
    }

    public static String readableClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public String getDeclaringClass(Member member) {
        return member.getDeclaringClass().getName();
    }

    private Class[][] findTypeBounds(ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        int n = typeArray.length;
        Class[][] classArray = new Class[n][];
        for (int i = 0; i < n; ++i) {
            classArray[i] = this.boundType(typeArray[i]);
        }
        return classArray;
    }

    private Class[] boundType(Type type) {
        if (type instanceof Class) {
            return new Class[]{(Class)type};
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = ((TypeVariable)type).getBounds();
            int n = typeArray.length;
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = this.getRawType(typeArray[i]);
            }
            return classArray;
        }
        return null;
    }

    private Class getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.getRawType(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    private ArrayList<Class<?>> getTypeChain(Class<?> clazz, Class<?> clazz2) {
        ArrayList arrayList = null;
        if (clazz2 == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            return null;
        }
        if (clazz2 == clazz) {
            arrayList = new ArrayList();
        }
        if (arrayList == null && (arrayList = this.getTypeChain(clazz, clazz2.getSuperclass())) == null) {
            Class<?> clazz3;
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (arrayList = this.getTypeChain(clazz, clazz3 = classArray[i])) == null; ++i) {
            }
        }
        if (arrayList != null) {
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    private HashMap<Type, Type> getResolvedTypes(ArrayList<Class<?>> arrayList) {
        if (arrayList == null) {
            return null;
        }
        HashMap<Type, Type> hashMap = new HashMap<Type, Type>();
        for (Class<?> clazz : arrayList) {
            this.addResolvedTypes(hashMap, clazz.getGenericSuperclass());
            for (Type type : clazz.getGenericInterfaces()) {
                this.addResolvedTypes(hashMap, type);
            }
        }
        return hashMap;
    }

    private void addResolvedTypes(HashMap<Type, Type> hashMap, Type type) {
        if (type == null) {
            return;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i = 0; i < typeArray.length; ++i) {
                hashMap.put(typeVariableArray[i], typeArray[i]);
            }
        }
    }

    private ArrayList<Class<?>> getParameterTypes(Class<?> clazz, HashMap<Type, Type> hashMap) {
        if (hashMap == null) {
            return null;
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        ArrayList arrayList = new ArrayList();
        for (Type type : typeVariableArray) {
            while (hashMap.containsKey(type)) {
                type = hashMap.get(type);
            }
            arrayList.add(this.getRawType(type));
        }
        return arrayList;
    }
}

