/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.JoinResultSet;
import org.apache.derby.shared.common.error.StandardException;

class MergeJoinResultSet
extends JoinResultSet {
    private static final int GREATER_THAN = 1;
    private static final int EQUAL = 0;
    private static final int LESS_THAN = -1;
    private GeneratedMethod leftGreaterThanRight;

    MergeJoinResultSet(NoPutResultSet noPutResultSet, int n, NoPutResultSet noPutResultSet2, int n2, Activation activation, GeneratedMethod generatedMethod, GeneratedMethod generatedMethod2, int n3, boolean bl, boolean bl2, double d, double d2) {
        super(noPutResultSet, n, noPutResultSet2, n2, activation, generatedMethod2, n3, bl, bl2, d, d2, null);
        this.leftGreaterThanRight = generatedMethod;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException((String)"XCL16.S", (Object[])new Object[]{"next"});
        }
        if (!this.isRightOpen) {
            this.openRight();
        }
        while (this.leftRow != null) {
            int n;
            while ((n = ((Integer)this.leftGreaterThanRight.invoke(this.activation)).intValue()) == 1) {
                this.rightRow = this.rightResultSet.getNextRowCore();
                ++this.rowsSeenRight;
                if (this.rightRow != null) continue;
                this.clearCurrentRow();
                return null;
            }
            if (n == 0 && this.restrictionIsTrue()) {
                ExecRow execRow = this.getReturnRow(this.leftRow, this.rightRow);
                this.leftRow = this.leftResultSet.getNextRowCore();
                return execRow;
            }
            this.leftRow = this.leftResultSet.getNextRowCore();
            ++this.rowsSeenLeft;
        }
        this.clearCurrentRow();
        return null;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.leftResultSet.getTimeSpent(1) - this.rightResultSet.getTimeSpent(1);
        }
        return l;
    }

    private ExecRow getReturnRow(ExecRow execRow, ExecRow execRow2) throws StandardException {
        DataValueDescriptor dataValueDescriptor;
        if (this.mergedRow == null) {
            this.mergedRow = this.getExecutionFactory().getValueRow(this.leftNumCols + this.rightNumCols);
        }
        int n = 1;
        int n2 = 1;
        while (n <= this.leftNumCols) {
            dataValueDescriptor = execRow.getColumn(n);
            if (dataValueDescriptor != null && dataValueDescriptor.hasStream()) {
                dataValueDescriptor = dataValueDescriptor.cloneValue(false);
            }
            this.mergedRow.setColumn(n2, dataValueDescriptor);
            ++n;
            ++n2;
        }
        n = 1;
        while (n <= this.rightNumCols) {
            dataValueDescriptor = execRow2.getColumn(n);
            if (dataValueDescriptor != null && dataValueDescriptor.hasStream()) {
                dataValueDescriptor = dataValueDescriptor.cloneValue(false);
            }
            this.mergedRow.setColumn(n2, dataValueDescriptor);
            ++n;
            ++n2;
        }
        this.setCurrentRow(this.mergedRow);
        ++this.rowsReturned;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return this.mergedRow;
    }

    private boolean restrictionIsTrue() throws StandardException {
        DataValueDescriptor dataValueDescriptor;
        if (this.restriction != null && ((dataValueDescriptor = (DataValueDescriptor)this.restriction.invoke(this.activation)).isNull() || !dataValueDescriptor.getBoolean())) {
            ++this.rowsFiltered;
            return false;
        }
        return true;
    }
}

