/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteConstraints;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.JsonRecyclerPools;
import com.fasterxml.jackson.core.util.RecyclerPool;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.Set;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperFactory;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperProvider;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class JacksonObjectMapperProvider$
implements ExtensionId<JacksonObjectMapperProvider>,
ExtensionIdProvider {
    public static final JacksonObjectMapperProvider$ MODULE$ = new JacksonObjectMapperProvider$();

    public Extension apply(ActorSystem system) {
        return ExtensionId.apply$((ExtensionId)this, (ActorSystem)system);
    }

    public Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)this, (ClassicActorSystemProvider)system);
    }

    public final int hashCode() {
        return ExtensionId.hashCode$((ExtensionId)this);
    }

    public final boolean equals(Object other) {
        return ExtensionId.equals$((ExtensionId)this, (Object)other);
    }

    public JacksonObjectMapperProvider get(ActorSystem system) {
        return (JacksonObjectMapperProvider)ExtensionId.get$((ExtensionId)this, (ActorSystem)system);
    }

    public JacksonObjectMapperProvider get(ClassicActorSystemProvider system) {
        return (JacksonObjectMapperProvider)ExtensionId.get$((ExtensionId)this, (ClassicActorSystemProvider)system);
    }

    public JacksonObjectMapperProvider$ lookup() {
        return this;
    }

    public JacksonObjectMapperProvider createExtension(ExtendedActorSystem system) {
        return new JacksonObjectMapperProvider(system);
    }

    public Config configForBinding(String bindingName, Config systemConfig) {
        String basePath = "pekko.serialization.jackson";
        Config baseConf = systemConfig.getConfig(basePath);
        if (systemConfig.hasPath(new StringBuilder(1).append(basePath).append(".").append(bindingName).toString())) {
            return systemConfig.getConfig(new StringBuilder(1).append(basePath).append(".").append(bindingName).toString()).withFallback((ConfigMergeable)baseConf);
        }
        return baseConf;
    }

    private JsonFactory createJsonFactory(String bindingName, JacksonObjectMapperFactory objectMapperFactory, Config config, Option<JsonFactory> baseJsonFactory) {
        JsonFactory jsonFactory;
        StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxNestingDepth(config.getInt("read.max-nesting-depth")).maxNumberLength(config.getInt("read.max-number-length")).maxStringLength(config.getInt("read.max-string-length")).maxNameLength(config.getInt("read.max-name-length")).maxDocumentLength(config.getLong("read.max-document-length")).maxTokenCount(config.getLong("read.max-token-count")).build();
        StreamWriteConstraints streamWriteConstraints = StreamWriteConstraints.builder().maxNestingDepth(config.getInt("write.max-nesting-depth")).build();
        if (baseJsonFactory instanceof Some) {
            JsonFactory factory = (JsonFactory)((Some)baseJsonFactory).value();
            factory.setStreamReadConstraints(streamReadConstraints);
            factory.setStreamWriteConstraints(streamWriteConstraints);
            jsonFactory = factory.setRecyclerPool(this.getBufferRecyclerPool(config));
        } else if (None$.MODULE$.equals(baseJsonFactory)) {
            jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(streamReadConstraints).streamWriteConstraints(streamWriteConstraints).recyclerPool(this.getBufferRecyclerPool(config))).build();
        } else {
            throw new MatchError(baseJsonFactory);
        }
        JsonFactory jsonFactory2 = jsonFactory;
        Seq configuredStreamReadFeatures = (Seq)this.features(config, "stream-read-features").map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String enumName = (String)x0$1._1();
                boolean value = x0$1._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamReadFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredStreamReadFeatures(bindingName, (Seq<Tuple2<StreamReadFeature, Object>>)configuredStreamReadFeatures).foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                StreamReadFeature feature = (StreamReadFeature)x0$2._1();
                boolean value = x0$2._2$mcZ$sp();
                return jsonFactory2.configure(feature.mappedFeature(), value);
            }
            throw new MatchError(null);
        });
        Seq configuredStreamWriteFeatures = (Seq)this.features(config, "stream-write-features").map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                String enumName = (String)x0$3._1();
                boolean value = x0$3._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamWriteFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredStreamWriteFeatures(bindingName, (Seq<Tuple2<StreamWriteFeature, Object>>)configuredStreamWriteFeatures).foreach((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                StreamWriteFeature feature = (StreamWriteFeature)x0$4._1();
                boolean value = x0$4._2$mcZ$sp();
                return jsonFactory2.configure(feature.mappedFeature(), value);
            }
            throw new MatchError(null);
        });
        Seq configuredJsonReadFeatures = (Seq)this.features(config, "json-read-features").map((Function1 & Serializable)x0$5 -> {
            if (x0$5 != null) {
                String enumName = (String)x0$5._1();
                boolean value = x0$5._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JsonReadFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredJsonReadFeatures(bindingName, (Seq<Tuple2<JsonReadFeature, Object>>)configuredJsonReadFeatures).foreach((Function1 & Serializable)x0$6 -> {
            if (x0$6 != null) {
                JsonReadFeature feature = (JsonReadFeature)x0$6._1();
                boolean value = x0$6._2$mcZ$sp();
                return jsonFactory2.configure(feature.mappedFeature(), value);
            }
            throw new MatchError(null);
        });
        Seq configuredJsonWriteFeatures = (Seq)this.features(config, "json-write-features").map((Function1 & Serializable)x0$7 -> {
            if (x0$7 != null) {
                String enumName = (String)x0$7._1();
                boolean value = x0$7._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JsonWriteFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredJsonWriteFeatures(bindingName, (Seq<Tuple2<JsonWriteFeature, Object>>)configuredJsonWriteFeatures).foreach((Function1 & Serializable)x0$8 -> {
            if (x0$8 != null) {
                JsonWriteFeature feature = (JsonWriteFeature)x0$8._1();
                boolean value = x0$8._2$mcZ$sp();
                return jsonFactory2.configure(feature.mappedFeature(), value);
            }
            throw new MatchError(null);
        });
        return jsonFactory2;
    }

    private RecyclerPool<BufferRecycler> getBufferRecyclerPool(Config cfg) {
        String string = cfg.getString("buffer-recycler.pool-instance");
        switch (string == null ? 0 : string.hashCode()) {
            case -2100337910: {
                if (!"concurrent-deque".equals(string)) break;
                return JsonRecyclerPools.newConcurrentDequePool();
            }
            case -2071825550: {
                if (!"shared-concurrent-deque".equals(string)) break;
                return JsonRecyclerPools.sharedConcurrentDequePool();
            }
            case -1706241560: {
                if (!"thread-local".equals(string)) break;
                return JsonRecyclerPools.threadLocalPool();
            }
            case 70311581: {
                if (!"bounded".equals(string)) break;
                return JsonRecyclerPools.newBoundedPool((int)cfg.getInt("buffer-recycler.bounded-pool-size"));
            }
            case 150628240: {
                if (!"non-recycling".equals(string)) break;
                return JsonRecyclerPools.nonRecyclingPool();
            }
        }
        throw new IllegalArgumentException(new StringBuilder(23).append("Unknown recycler-pool: ").append(string).toString());
    }

    private void configureObjectMapperFeatures(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config) {
        Seq configuredSerializationFeatures = (Seq)this.features(config, "serialization-features").map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String enumName = (String)x0$1._1();
                boolean value = x0$1._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SerializationFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredSerializationFeatures(bindingName, (Seq<Tuple2<SerializationFeature, Object>>)configuredSerializationFeatures).foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                SerializationFeature feature = (SerializationFeature)x0$2._1();
                boolean value = x0$2._2$mcZ$sp();
                return objectMapper.configure(feature, value);
            }
            throw new MatchError(null);
        });
        Seq configuredDeserializationFeatures = (Seq)this.features(config, "deserialization-features").map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                String enumName = (String)x0$3._1();
                boolean value = x0$3._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeserializationFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredDeserializationFeatures(bindingName, (Seq<Tuple2<DeserializationFeature, Object>>)configuredDeserializationFeatures).foreach((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                DeserializationFeature feature = (DeserializationFeature)x0$4._1();
                boolean value = x0$4._2$mcZ$sp();
                return objectMapper.configure(feature, value);
            }
            throw new MatchError(null);
        });
        Seq configuredEnumFeatures = (Seq)this.features(config, "enum-features").map((Function1 & Serializable)x0$5 -> {
            if (x0$5 != null) {
                String enumName = (String)x0$5._1();
                boolean value = x0$5._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnumFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredEnumFeatures(bindingName, (Seq<Tuple2<EnumFeature, Object>>)configuredEnumFeatures).foreach((Function1 & Serializable)x0$6 -> {
            if (x0$6 != null) {
                EnumFeature feature = (EnumFeature)x0$6._1();
                boolean value = x0$6._2$mcZ$sp();
                return objectMapper.configure((DatatypeFeature)feature, value);
            }
            throw new MatchError(null);
        });
        Seq configuredMapperFeatures = (Seq)this.features(config, "mapper-features").map((Function1 & Serializable)x0$7 -> {
            if (x0$7 != null) {
                String enumName = (String)x0$7._1();
                boolean value = x0$7._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MapperFeature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredMapperFeatures(bindingName, (Seq<Tuple2<MapperFeature, Object>>)configuredMapperFeatures).foreach((Function1 & Serializable)x0$8 -> {
            if (x0$8 != null) {
                MapperFeature feature = (MapperFeature)x0$8._1();
                boolean value = x0$8._2$mcZ$sp();
                return objectMapper.configure(feature, value);
            }
            throw new MatchError(null);
        });
        Seq configuredJsonParserFeatures = (Seq)this.features(config, "json-parser-features").map((Function1 & Serializable)x0$9 -> {
            if (x0$9 != null) {
                String enumName = (String)x0$9._1();
                boolean value = x0$9._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JsonParser.Feature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredJsonParserFeatures(bindingName, (Seq<Tuple2<JsonParser.Feature, Object>>)configuredJsonParserFeatures).foreach((Function1 & Serializable)x0$10 -> {
            if (x0$10 != null) {
                JsonParser.Feature feature = (JsonParser.Feature)x0$10._1();
                boolean value = x0$10._2$mcZ$sp();
                return objectMapper.configure(feature, value);
            }
            throw new MatchError(null);
        });
        Seq configuredJsonGeneratorFeatures = (Seq)this.features(config, "json-generator-features").map((Function1 & Serializable)x0$11 -> {
            if (x0$11 != null) {
                String enumName = (String)x0$11._1();
                boolean value = x0$11._2$mcZ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JsonGenerator.Feature.valueOf((String)enumName)), (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredJsonGeneratorFeatures(bindingName, (Seq<Tuple2<JsonGenerator.Feature, Object>>)configuredJsonGeneratorFeatures).foreach((Function1 & Serializable)x0$12 -> {
            if (x0$12 != null) {
                JsonGenerator.Feature feature = (JsonGenerator.Feature)x0$12._1();
                boolean value = x0$12._2$mcZ$sp();
                return objectMapper.configure(feature, value);
            }
            throw new MatchError(null);
        });
    }

    private void configureObjectVisibility(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config) {
        Seq configuredVisibility = (Seq)this.configPairs(config, "visibility").map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String property = (String)x0$1._1();
                String visibility = (String)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyAccessor.valueOf((String)property)), (Object)JsonAutoDetect.Visibility.valueOf((String)visibility));
            }
            throw new MatchError(null);
        });
        objectMapperFactory.overrideConfiguredVisibility(bindingName, (Seq<Tuple2<PropertyAccessor, JsonAutoDetect.Visibility>>)configuredVisibility).foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                PropertyAccessor property = (PropertyAccessor)x0$2._1();
                JsonAutoDetect.Visibility visibility = (JsonAutoDetect.Visibility)x0$2._2();
                return objectMapper.setVisibility(property, visibility);
            }
            throw new MatchError(null);
        });
    }

    private void configureObjectMapperModules(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config, DynamicAccess dynamicAccess, Option<LoggingAdapter> log) {
        List modules2 = ((IterableOnceOps)((Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (java.util.List)config.getStringList("jackson-modules")).asScala().flatMap((Function1 & Serializable)fqcn -> {
            if (MODULE$.isModuleEnabled((String)fqcn, dynamicAccess)) {
                Try try_ = dynamicAccess.createInstanceFor(fqcn, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Module.class));
                if (try_ instanceof Success) {
                    Module m = (Module)((Success)try_).value();
                    return new Some((Object)m);
                }
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    log.foreach((Function1 & Serializable)x$1 -> {
                        x$1.error(e, new StringBuilder(187).append("Could not load configured Jackson module [").append(fqcn).append("], ").append("please verify classpath dependencies or amend the configuration ").append("[pekko.serialization.jackson.jackson-modules]. Continuing without this module.").toString());
                        return BoxedUnit.UNIT;
                    });
                    return None$.MODULE$;
                }
                throw new MatchError((Object)try_);
            }
            return None$.MODULE$;
        })).map((Function1 & Serializable)module -> {
            if (module instanceof ParameterNamesModule) {
                return new ParameterNamesModule(JsonCreator.Mode.PROPERTIES);
            }
            return module;
        })).toList();
        objectMapperFactory.overrideConfiguredModules(bindingName, (Seq<Module>)modules2).foreach((Function1 & Serializable)module -> {
            JacksonObjectMapperProvider$.$anonfun$configureObjectMapperModules$4(objectMapper, log, module);
            return BoxedUnit.UNIT;
        });
    }

    @InternalStableApi
    public ObjectMapper createObjectMapper(String bindingName, Option<JsonFactory> jsonFactory, JacksonObjectMapperFactory objectMapperFactory, Config config, DynamicAccess dynamicAccess, Option<LoggingAdapter> log) {
        JsonFactory configuredJsonFactory = this.createJsonFactory(bindingName, objectMapperFactory, config, jsonFactory);
        ObjectMapper mapper = objectMapperFactory.newObjectMapper(bindingName, configuredJsonFactory);
        this.configureObjectMapperFeatures(bindingName, mapper, objectMapperFactory, config);
        this.configureObjectMapperModules(bindingName, mapper, objectMapperFactory, config, dynamicAccess, log);
        this.configureObjectVisibility(bindingName, mapper, objectMapperFactory, config);
        return mapper;
    }

    private boolean isModuleEnabled(String fqcn, DynamicAccess dynamicAccess) {
        switch (fqcn == null ? 0 : fqcn.hashCode()) {
            case -1986392852: {
                if (!"org.apache.pekko.serialization.jackson.PekkoTypedJacksonModule".equals(fqcn)) break;
                return dynamicAccess.classIsOnClasspath("org.apache.pekko.actor.typed.ActorRef");
            }
            case 80545096: {
                if (!"org.apache.pekko.serialization.jackson.PekkoStreamJacksonModule".equals(fqcn)) break;
                return dynamicAccess.classIsOnClasspath("org.apache.pekko.stream.Graph");
            }
        }
        return true;
    }

    private Seq<Tuple2<String, Object>> features(Config config, String section) {
        Config cfg = config.getConfig(section);
        return ((IterableOnceOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (Set)cfg.root().keySet()).asScala().map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)BoxesRunTime.boxToBoolean((boolean)cfg.getBoolean(key))))).toList();
    }

    private Seq<Tuple2<String, String>> configPairs(Config config, String section) {
        Config cfg = config.getConfig(section);
        return ((IterableOnceOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (Set)cfg.root().keySet()).asScala().map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)cfg.getString(key)))).toList();
    }

    public static final /* synthetic */ void $anonfun$configureObjectMapperModules$4(ObjectMapper objectMapper$3, Option log$1, Module module) {
        objectMapper$3.registerModule(module);
        log$1.foreach((Function1 & Serializable)x$2 -> {
            x$2.debug("Registered Jackson module [{}]", (Object)module.getClass().getName());
            return BoxedUnit.UNIT;
        });
    }

    private JacksonObjectMapperProvider$() {
    }
}

