/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.JavaVersion$;
import scala.Function0;
import scala.Predef$;
import scala.util.control.NonFatal$;

@InternalApi
public final class VirtualThreadSupport$ {
    public static final VirtualThreadSupport$ MODULE$ = new VirtualThreadSupport$();
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private static final boolean isSupported = JavaVersion$.MODULE$.majorVersion() >= 21;

    private MethodHandles.Lookup lookup() {
        return lookup;
    }

    public boolean isSupported() {
        return isSupported;
    }

    public ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
        Predef$.MODULE$.require(threadFactory != null, (Function0 & Serializable)() -> "threadFactory should not be null.");
        try {
            Class<?> executorsClazz = ClassLoader.getSystemClassLoader().loadClass("java.util.concurrent.Executors");
            return (ExecutorService)this.lookup().findStatic(executorsClazz, "newThreadPerTaskExecutor", MethodType.methodType(ExecutorService.class, ThreadFactory.class)).invoke(threadFactory);
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new UnsupportedOperationException("Failed to create newThreadPerTaskExecutor.", throwable);
            }
            throw throwable;
        }
    }

    public ThreadFactory newVirtualThreadFactory(String prefix) {
        Predef$.MODULE$.require(this.isSupported(), (Function0 & Serializable)() -> "Virtual thread is not supported.");
        try {
            Class<?> builderClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder");
            Class<?> ofVirtualClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder$OfVirtual");
            Object builder = this.lookup().findStatic(Thread.class, "ofVirtual", MethodType.methodType(ofVirtualClass)).invoke();
            MethodHandle nameMethod = this.lookup().findVirtual(ofVirtualClass, "name", MethodType.methodType(ofVirtualClass, String.class, Long.TYPE));
            MethodHandle factoryMethod = this.lookup().findVirtual(builderClass, "factory", MethodType.methodType(ThreadFactory.class));
            builder = nameMethod.invoke(builder, new StringBuilder(16).append(prefix).append("-virtual-thread-").toString(), 0L);
            return (ThreadFactory)factoryMethod.invoke(builder);
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new UnsupportedOperationException("Failed to create virtual thread factory", throwable);
            }
            throw throwable;
        }
    }

    public ThreadFactory newVirtualThreadFactory(String prefix, ExecutorService executor) {
        try {
            Class<?> builderClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder");
            Class<?> ofVirtualClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder$OfVirtual");
            Object builder = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]).invoke(null, new Object[0]);
            if (executor != null) {
                Field field = builder.getClass().getDeclaredField("scheduler");
                field.setAccessible(true);
                field.set(builder, executor);
            }
            Method nameMethod = ofVirtualClass.getDeclaredMethod("name", String.class, Long.TYPE);
            Method factoryMethod = builderClass.getDeclaredMethod("factory", new Class[0]);
            Long zero = 0L;
            builder = nameMethod.invoke(builder, new StringBuilder(16).append(prefix).append("-virtual-thread-").toString(), zero);
            return (ThreadFactory)factoryMethod.invoke(builder, new Object[0]);
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new UnsupportedOperationException("Failed to create virtual thread factory", throwable);
            }
            throw throwable;
        }
    }

    public ForkJoinPool getVirtualThreadDefaultScheduler() {
        try {
            Predef$.MODULE$.require(this.isSupported(), (Function0 & Serializable)() -> "Virtual thread is not supported.");
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("java.lang.VirtualThread");
            String fieldName = "DEFAULT_SCHEDULER";
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (ForkJoinPool)field.get(null);
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new UnsupportedOperationException("Failed to get default scheduler of virtual thread.", throwable);
            }
            throw throwable;
        }
    }

    private VirtualThreadSupport$() {
    }
}

