/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.LogMarker;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.SubchannelClassification;
import org.apache.pekko.remote.FailureDetector;
import org.apache.pekko.remote.FailureDetector$;
import org.apache.pekko.remote.FailureDetectorWithAddress;
import org.apache.pekko.remote.HeartbeatHistory;
import org.apache.pekko.remote.HeartbeatHistory$;
import org.apache.pekko.remote.PhiAccrualFailureDetector$State$;
import org.apache.pekko.remote.RemoteLogMarker$;
import org.apache.pekko.util.Helpers;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\tmg\u0001B\u001f?\u0001\u001dC\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0011)A\u0005/\"A1\f\u0001BC\u0002\u0013\u0005A\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003^\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u00111\u0004!Q1A\u0005\u0002\tD\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\t]\u0002\u0011)\u0019!C\u0001E\"Aq\u000e\u0001B\u0001B\u0003%1\r\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!Q\bA!A!\u0002\u0017Y\bbBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u001f\u0001A\u0011AA\u0013\u0011\u001d\ty\u0001\u0001C\u0001\u0003kA\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0015\t\u0011\u0005m\u0003\u0001)A\u0005\u0003+B\u0011\"!\u0018\u0001\u0005\u0004%I!a\u0018\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003CB\u0011\"!\u001b\u0001\u0001\u0004%I!a\u001b\t\u0013\u0005\r\u0005\u00011A\u0005\n\u0005\u0015\u0005\u0002CAI\u0001\u0001\u0006K!!\u001c\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u001a1\u00111\u0014\u0001E\u0003;C!\"a.\u0019\u0005+\u0007I\u0011AA*\u0011)\tI\f\u0007B\tB\u0003%\u0011Q\u000b\u0005\u000b\u0003wC\"Q3A\u0005\u0002\u0005u\u0006BCAa1\tE\t\u0015!\u0003\u0002@\"9\u0011q\u0002\r\u0005\u0002\u0005\r\u0007\"CAg1\u0005\u0005I\u0011AAh\u0011%\t)\u000eGI\u0001\n\u0003\t9\u000eC\u0005\u0002nb\t\n\u0011\"\u0001\u0002p\"I\u00111\u001f\r\u0002\u0002\u0013\u0005\u0013Q\u001f\u0005\t\u0005\u000bA\u0012\u0011!C\u00019\"I!q\u0001\r\u0002\u0002\u0013\u0005!\u0011\u0002\u0005\n\u0005'A\u0012\u0011!C!\u0005+A\u0011Ba\t\u0019\u0003\u0003%\tA!\n\t\u0013\t=\u0002$!A\u0005B\tE\u0002\"\u0003B\u001b1\u0005\u0005I\u0011\tB\u001c\u0011%\u0011I\u0004GA\u0001\n\u0003\u0012Y\u0004C\u0005\u0003>a\t\t\u0011\"\u0011\u0003@\u001dI!1\t\u0001\u0002\u0002#%!Q\t\u0004\n\u00037\u0003\u0011\u0011!E\u0005\u0005\u000fBq!a\u0004,\t\u0003\u0011y\u0006C\u0005\u0003:-\n\t\u0011\"\u0012\u0003<!I!\u0011M\u0016\u0002\u0002\u0013\u0005%1\r\u0005\n\u0005SZ\u0013\u0011!CA\u0005WB\u0011B!\u001f\u0001\u0005\u0004%IAa\u001f\t\u0011\t=\u0005\u0001)A\u0005\u0005{BqA!%\u0001\t\u0003\u0012\u0019\nC\u0004\u0003\u0012\u0002!IA!&\t\u000f\te\u0005\u0001\"\u0011\u0003\u0014\"9!1\u0014\u0001\u0005F\tu\u0005b\u0002BU\u0001\u0011E!1\u0016\u0005\u0007\u0005{\u0003A\u0011\u0001,\t\u000f\tu\u0006\u0001\"\u0003\u0003@\"A!Q\u0018\u0001\u0005\u0002\u0001\u0013\u0019\r\u0003\u0005\u0003R\u0002\u0011\r\u0011\"\u0003W\u0011\u001d\u0011\u0019\u000e\u0001Q\u0001\n]CqA!6\u0001\t\u0013\u00119NA\rQQ&\f5m\u0019:vC24\u0015-\u001b7ve\u0016$U\r^3di>\u0014(BA A\u0003\u0019\u0011X-\\8uK*\u0011\u0011IQ\u0001\u0006a\u0016\\7n\u001c\u0006\u0003\u0007\u0012\u000ba!\u00199bG\",'\"A#\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001AeJ\u0015\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0003V\"\u0001 \n\u0005Es$a\u0004$bS2,(/\u001a#fi\u0016\u001cGo\u001c:\u0011\u0005=\u001b\u0016B\u0001+?\u0005i1\u0015-\u001b7ve\u0016$U\r^3di>\u0014x+\u001b;i\u0003\u0012$'/Z:t\u0003%!\bN]3tQ>dG-F\u0001X!\tI\u0005,\u0003\u0002Z\u0015\n1Ai\\;cY\u0016\f!\u0002\u001e5sKNDw\u000e\u001c3!\u00035i\u0017\r_*b[BdWmU5{KV\tQ\f\u0005\u0002J=&\u0011qL\u0013\u0002\u0004\u0013:$\u0018AD7bqN\u000bW\u000e\u001d7f'&TX\rI\u0001\u0010[&t7\u000b\u001e3EKZL\u0017\r^5p]V\t1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006AA-\u001e:bi&|gN\u0003\u0002i\u0015\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005),'A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0011[&t7\u000b\u001e3EKZL\u0017\r^5p]\u0002\n\u0001$Y2dKB$\u0018M\u00197f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0016-^:f\u0003e\t7mY3qi\u0006\u0014G.\u001a%fCJ$(-Z1u!\u0006,8/\u001a\u0011\u0002-\u0019L'o\u001d;IK\u0006\u0014HOY3bi\u0016\u001bH/[7bi\u0016\fqCZ5sgRDU-\u0019:uE\u0016\fG/R:uS6\fG/\u001a\u0011\u0002\u0017\u00154XM\u001c;TiJ,\u0017-\u001c\t\u0004\u0013J$\u0018BA:K\u0005\u0019y\u0005\u000f^5p]B\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fQ\u0001\u0006KZ,g\u000e^\u0005\u0003sZ\u00141\"\u0012<f]R\u001cFO]3b[\u0006)1\r\\8dWB\u0019A0!\u0003\u000f\u0007u\f)AD\u0002\u007f\u0003\u0007q1a`A\u0001\u001b\u0005\u0011\u0015BA!C\u0013\ty\u0004)C\u0002\u0002\by\nqBR1jYV\u0014X\rR3uK\u000e$xN]\u0005\u0005\u0003\u0017\tiAA\u0003DY>\u001c7NC\u0002\u0002\by\na\u0001P5oSRtDCDA\n\u00033\tY\"!\b\u0002 \u0005\u0005\u00121\u0005\u000b\u0005\u0003+\t9\u0002\u0005\u0002P\u0001!)!0\u0004a\u0002w\")Q+\u0004a\u0001/\")1,\u0004a\u0001;\")\u0011-\u0004a\u0001G\")A.\u0004a\u0001G\")a.\u0004a\u0001G\")\u0001/\u0004a\u0001cRa\u0011qEA\u0016\u0003[\ty#!\r\u00024Q!\u0011QCA\u0015\u0011\u0015Qh\u0002q\u0001|\u0011\u0015)f\u00021\u0001X\u0011\u0015Yf\u00021\u0001^\u0011\u0015\tg\u00021\u0001d\u0011\u0015ag\u00021\u0001d\u0011\u0015qg\u00021\u0001d)\u0019\t)\"a\u000e\u0002N!9\u0011\u0011H\bA\u0002\u0005m\u0012AB2p]\u001aLw\r\u0005\u0003\u0002>\u0005%SBAA \u0015\u0011\tI$!\u0011\u000b\t\u0005\r\u0013QI\u0001\tif\u0004Xm]1gK*\u0011\u0011qI\u0001\u0004G>l\u0017\u0002BA&\u0003\u007f\u0011aaQ8oM&<\u0007BBA(\u001f\u0001\u0007A/\u0001\u0002fm\u0006qa-\u001b:ti\"+\u0017M\u001d;cK\u0006$XCAA+!\ry\u0015qK\u0005\u0004\u00033r$\u0001\u0005%fCJ$(-Z1u\u0011&\u001cHo\u001c:z\u0003=1\u0017N]:u\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0013AH1dG\u0016\u0004H/\u00192mK\"+\u0017M\u001d;cK\u0006$\b+Y;tK6KG\u000e\\5t+\t\t\t\u0007E\u0002J\u0003GJ1!!\u001aK\u0005\u0011auN\\4\u0002?\u0005\u001c7-\u001a9uC\ndW\rS3beR\u0014W-\u0019;QCV\u001cX-T5mY&\u001c\b%A\u0004bI\u0012\u0014Xm]:\u0016\u0005\u00055\u0004\u0003BA8\u0003{rA!!\u001d\u0002zA\u0019\u00111\u000f&\u000e\u0005\u0005U$bAA<\r\u00061AH]8pizJ1!a\u001fK\u0003\u0019\u0001&/\u001a3fM&!\u0011qPAA\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0010&\u0002\u0017\u0005$GM]3tg~#S-\u001d\u000b\u0005\u0003\u000f\u000bi\tE\u0002J\u0003\u0013K1!a#K\u0005\u0011)f.\u001b;\t\u0013\u0005=U#!AA\u0002\u00055\u0014a\u0001=%c\u0005A\u0011\r\u001a3sKN\u001c\b%\u0001\u0006tKR\fE\r\u001a:fgN$B!a\"\u0002\u0018\"9\u0011\u0011T\fA\u0002\u00055\u0014\u0001B1eIJ\u0014Qa\u0015;bi\u0016\u001cb\u0001\u0007%\u0002 \u0006\u0015\u0006cA%\u0002\"&\u0019\u00111\u0015&\u0003\u000fA\u0013x\u000eZ;diB!\u0011qUAY\u001d\u0011\tI+!,\u000f\t\u0005M\u00141V\u0005\u0002\u0017&\u0019\u0011q\u0016&\u0002\u000fA\f7m[1hK&!\u00111WA[\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tyKS\u0001\bQ&\u001cHo\u001c:z\u0003!A\u0017n\u001d;pef\u0004\u0013!\u0003;j[\u0016\u001cH/Y7q+\t\ty\f\u0005\u0003Je\u0006\u0005\u0014A\u0003;j[\u0016\u001cH/Y7qAQ1\u0011QYAe\u0003\u0017\u00042!a2\u0019\u001b\u0005\u0001\u0001bBA\\;\u0001\u0007\u0011Q\u000b\u0005\b\u0003wk\u0002\u0019AA`\u0003\u0011\u0019w\u000e]=\u0015\r\u0005\u0015\u0017\u0011[Aj\u0011%\t9L\bI\u0001\u0002\u0004\t)\u0006C\u0005\u0002<z\u0001\n\u00111\u0001\u0002@\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAmU\u0011\t)&a7,\u0005\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a:K\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\f\tOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002r*\"\u0011qXAn\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u001f\t\u0005\u0003s\u0014\u0019!\u0004\u0002\u0002|*!\u0011Q`A\u0000\u0003\u0011a\u0017M\\4\u000b\u0005\t\u0005\u0011\u0001\u00026bm\u0006LA!a \u0002|\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0006\u0005#\u00012!\u0013B\u0007\u0013\r\u0011yA\u0013\u0002\u0004\u0003:L\b\u0002CAHG\u0005\u0005\t\u0019A/\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0006\u0011\r\te!q\u0004B\u0006\u001b\t\u0011YBC\u0002\u0003\u001e)\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tCa\u0007\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005O\u0011i\u0003E\u0002J\u0005SI1Aa\u000bK\u0005\u001d\u0011un\u001c7fC:D\u0011\"a$&\u0003\u0003\u0005\rAa\u0003\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003o\u0014\u0019\u0004\u0003\u0005\u0002\u0010\u001a\n\t\u00111\u0001^\u0003!A\u0017m\u001d5D_\u0012,G#A/\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a>\u0002\r\u0015\fX/\u00197t)\u0011\u00119C!\u0011\t\u0013\u0005=\u0015&!AA\u0002\t-\u0011!B*uCR,\u0007cAAdWM)1F!\u0013\u0003VAQ!1\nB)\u0003+\ny,!2\u000e\u0005\t5#b\u0001B(\u0015\u00069!/\u001e8uS6,\u0017\u0002\u0002B*\u0005\u001b\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u00119F!\u0018\u000e\u0005\te#\u0002\u0002B.\u0003\u007f\f!![8\n\t\u0005M&\u0011\f\u000b\u0003\u0005\u000b\nQ!\u00199qYf$b!!2\u0003f\t\u001d\u0004bBA\\]\u0001\u0007\u0011Q\u000b\u0005\b\u0003ws\u0003\u0019AA`\u0003\u001d)h.\u00199qYf$BA!\u001c\u0003vA!\u0011J\u001dB8!\u001dI%\u0011OA+\u0003\u007fK1Aa\u001dK\u0005\u0019!V\u000f\u001d7fe!I!qO\u0018\u0002\u0002\u0003\u0007\u0011QY\u0001\u0004q\u0012\u0002\u0014!B:uCR,WC\u0001B?!\u0019\u0011yHa#\u0002F6\u0011!\u0011\u0011\u0006\u0005\u0005\u0007\u0013))\u0001\u0004bi>l\u0017n\u0019\u0006\u0004Q\n\u001d%\u0002\u0002BE\u0003\u007f\fA!\u001e;jY&!!Q\u0012BA\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0017AB:uCR,\u0007%A\u0006jg\u00063\u0018-\u001b7bE2,WC\u0001B\u0014)\u0011\u00119Ca&\t\u000f\u0005m6\u00071\u0001\u0002b\u0005a\u0011n]'p]&$xN]5oO\u0006I\u0001.Z1si\n,\u0017\r\u001e\u000b\u0003\u0003\u000fC3!\u000eBQ!\u0011\u0011\u0019K!*\u000e\u0005\u0005\u0015\u0018\u0002\u0002BT\u0003K\u0014q\u0001^1jYJ,7-\u0001\bsK\u000e|'\u000fZ%oi\u0016\u0014h/\u00197\u0015\t\u0005U#Q\u0016\u0005\b\u0005_3\u0004\u0019AA1\u0003!Ig\u000e^3sm\u0006d\u0007f\u0001\u001c\u00034B!!Q\u0017B]\u001b\t\u00119LC\u0002\u0002h\u0002KAAa/\u00038\nY\u0011J\u001c;fe:\fG.\u00119j\u0003\r\u0001\b.\u001b\u000b\u0004/\n\u0005\u0007bBA^q\u0001\u0007\u0011\u0011\r\u000b\b/\n\u0015'\u0011\u001aBg\u0011\u001d\u00119-\u000fa\u0001\u0003C\n\u0001\u0002^5nK\u0012KgM\u001a\u0005\u0007\u0005\u0017L\u0004\u0019A,\u0002\t5,\u0017M\u001c\u0005\u0007\u0005\u001fL\u0004\u0019A,\u0002\u0019M$H\rR3wS\u0006$\u0018n\u001c8\u0002+5Lgn\u0015;e\t\u00164\u0018.\u0019;j_:l\u0015\u000e\u001c7jg\u00061R.\u001b8Ti\u0012$UM^5bi&|g.T5mY&\u001c\b%A\ff]N,(/\u001a,bY&$7\u000b\u001e3EKZL\u0017\r^5p]R\u0019qK!7\t\r\t=G\b1\u0001X\u0001")
public class PhiAccrualFailureDetector
implements FailureDetector,
FailureDetectorWithAddress {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final double minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    private String address() {
        return this.address;
    }

    private void address_$eq(String x$1) {
        this.address = x$1;
    }

    @Override
    public void setAddress(String addr) {
        this.address_$eq(addr);
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                long latestTimestamp = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                long interval = timestamp - latestTimestamp;
                heartbeatHistory = this.isAvailable(timestamp) ? this.recordInterval(interval) : oldState.history();
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public HeartbeatHistory recordInterval(long interval) {
        if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
            void apply_marker;
            void apply_mdc;
            void apply_message;
            void apply_logClass;
            LogMarker logMarker = RemoteLogMarker$.MODULE$.failureDetectorGrowing(this.address());
            Map map = Logging$.MODULE$.emptyMDC();
            String string = new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString();
            Class<?> clazz = this.getClass();
            String apply_logSource = this.toString();
            Object var3_6 = null;
            clazz = null;
            string = null;
            map = null;
            logMarker = null;
            ((SubchannelClassification)this.eventStream.get()).publish((Object)new Logging.Warning3(apply_logSource, (Class)apply_logClass, (Object)apply_message, (Map)apply_mdc, (LogMarker)apply_marker));
        }
        return this.state().get().history().$colon$plus(interval);
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            return 0.0;
        }
        long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
        HeartbeatHistory history = oldState.history();
        double mean = history.mean();
        double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
        return this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        if ((double)timeDiff > mean) {
            return -package$.MODULE$.log10(e / (1.0 + e));
        }
        return -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private double minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        synchronized (this) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
            return;
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0 & Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0 & Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        String getMillisDuration$extension_path = "min-std-deviation";
        Object var3_3 = null;
        String getMillisDuration$extension_path2 = "acceptable-heartbeat-pause";
        Object var4_4 = null;
        String getMillisDuration$extension_path3 = "heartbeat-interval";
        Object var5_5 = null;
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers.ConfigOps$.MODULE$.getDuration$extension(config, getMillisDuration$extension_path, TimeUnit.MILLISECONDS), Helpers.ConfigOps$.MODULE$.getDuration$extension(config, getMillisDuration$extension_path2, TimeUnit.MILLISECONDS), Helpers.ConfigOps$.MODULE$.getDuration$extension(config, getMillisDuration$extension_path3, TimeUnit.MILLISECONDS), (Option<EventStream>)new Some((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    private class State
    implements Product,
    Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        public final /* synthetic */ PhiAccrualFailureDetector $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer(), history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.history();
                }
                case 1: {
                    return this.timestamp();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "history";
                }
                case 1: {
                    return "timestamp";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 382765188, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof State && ((State)x$1).org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() == this.org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer())) break block3;
                    State state = (State)x$1;
                    HeartbeatHistory heartbeatHistory = this.history();
                    HeartbeatHistory heartbeatHistory2 = state.history();
                    if (heartbeatHistory != null ? !((Object)heartbeatHistory).equals(heartbeatHistory2) : heartbeatHistory2 != null) break block3;
                    Option<Object> option = this.timestamp();
                    Option<Object> option2 = state.timestamp();
                    if ((option != null ? !option.equals(option2) : option2 != null) || !state.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ PhiAccrualFailureDetector org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

