/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oslogin.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.oslogin.common.OsLoginProto;
import com.google.cloud.oslogin.v1.CreateSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.DeletePosixAccountRequest;
import com.google.cloud.oslogin.v1.DeleteSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.FingerprintName;
import com.google.cloud.oslogin.v1.GetLoginProfileRequest;
import com.google.cloud.oslogin.v1.GetSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.ImportSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.ImportSshPublicKeyResponse;
import com.google.cloud.oslogin.v1.LoginProfile;
import com.google.cloud.oslogin.v1.OsLoginServiceSettings;
import com.google.cloud.oslogin.v1.ProjectName;
import com.google.cloud.oslogin.v1.UpdateSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.UserName;
import com.google.cloud.oslogin.v1.stub.OsLoginServiceStub;
import com.google.cloud.oslogin.v1.stub.OsLoginServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class OsLoginServiceClient
implements BackgroundResource {
    private final OsLoginServiceSettings settings;
    private final OsLoginServiceStub stub;

    public static final OsLoginServiceClient create() throws IOException {
        return OsLoginServiceClient.create(OsLoginServiceSettings.newBuilder().build());
    }

    public static final OsLoginServiceClient create(OsLoginServiceSettings settings) throws IOException {
        return new OsLoginServiceClient(settings);
    }

    public static final OsLoginServiceClient create(OsLoginServiceStub stub) {
        return new OsLoginServiceClient(stub);
    }

    protected OsLoginServiceClient(OsLoginServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OsLoginServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected OsLoginServiceClient(OsLoginServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OsLoginServiceSettings getSettings() {
        return this.settings;
    }

    public OsLoginServiceStub getStub() {
        return this.stub;
    }

    public final OsLoginProto.SshPublicKey createSshPublicKey(UserName parent, OsLoginProto.SshPublicKey sshPublicKey) {
        CreateSshPublicKeyRequest request = CreateSshPublicKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSshPublicKey(sshPublicKey).build();
        return this.createSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey createSshPublicKey(String parent, OsLoginProto.SshPublicKey sshPublicKey) {
        CreateSshPublicKeyRequest request = CreateSshPublicKeyRequest.newBuilder().setParent(parent).setSshPublicKey(sshPublicKey).build();
        return this.createSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey createSshPublicKey(CreateSshPublicKeyRequest request) {
        return (OsLoginProto.SshPublicKey)this.createSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSshPublicKeyRequest, OsLoginProto.SshPublicKey> createSshPublicKeyCallable() {
        return this.stub.createSshPublicKeyCallable();
    }

    public final void deletePosixAccount(ProjectName name) {
        DeletePosixAccountRequest request = DeletePosixAccountRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePosixAccount(request);
    }

    public final void deletePosixAccount(String name) {
        DeletePosixAccountRequest request = DeletePosixAccountRequest.newBuilder().setName(name).build();
        this.deletePosixAccount(request);
    }

    public final void deletePosixAccount(DeletePosixAccountRequest request) {
        this.deletePosixAccountCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePosixAccountRequest, Empty> deletePosixAccountCallable() {
        return this.stub.deletePosixAccountCallable();
    }

    public final void deleteSshPublicKey(FingerprintName name) {
        DeleteSshPublicKeyRequest request = DeleteSshPublicKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSshPublicKey(request);
    }

    public final void deleteSshPublicKey(String name) {
        DeleteSshPublicKeyRequest request = DeleteSshPublicKeyRequest.newBuilder().setName(name).build();
        this.deleteSshPublicKey(request);
    }

    public final void deleteSshPublicKey(DeleteSshPublicKeyRequest request) {
        this.deleteSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSshPublicKeyRequest, Empty> deleteSshPublicKeyCallable() {
        return this.stub.deleteSshPublicKeyCallable();
    }

    public final LoginProfile getLoginProfile(UserName name) {
        GetLoginProfileRequest request = GetLoginProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLoginProfile(request);
    }

    public final LoginProfile getLoginProfile(String name) {
        GetLoginProfileRequest request = GetLoginProfileRequest.newBuilder().setName(name).build();
        return this.getLoginProfile(request);
    }

    public final LoginProfile getLoginProfile(GetLoginProfileRequest request) {
        return (LoginProfile)this.getLoginProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetLoginProfileRequest, LoginProfile> getLoginProfileCallable() {
        return this.stub.getLoginProfileCallable();
    }

    public final OsLoginProto.SshPublicKey getSshPublicKey(FingerprintName name) {
        GetSshPublicKeyRequest request = GetSshPublicKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey getSshPublicKey(String name) {
        GetSshPublicKeyRequest request = GetSshPublicKeyRequest.newBuilder().setName(name).build();
        return this.getSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey getSshPublicKey(GetSshPublicKeyRequest request) {
        return (OsLoginProto.SshPublicKey)this.getSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetSshPublicKeyRequest, OsLoginProto.SshPublicKey> getSshPublicKeyCallable() {
        return this.stub.getSshPublicKeyCallable();
    }

    public final ImportSshPublicKeyResponse importSshPublicKey(UserName parent, OsLoginProto.SshPublicKey sshPublicKey) {
        ImportSshPublicKeyRequest request = ImportSshPublicKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSshPublicKey(sshPublicKey).build();
        return this.importSshPublicKey(request);
    }

    public final ImportSshPublicKeyResponse importSshPublicKey(String parent, OsLoginProto.SshPublicKey sshPublicKey) {
        ImportSshPublicKeyRequest request = ImportSshPublicKeyRequest.newBuilder().setParent(parent).setSshPublicKey(sshPublicKey).build();
        return this.importSshPublicKey(request);
    }

    public final ImportSshPublicKeyResponse importSshPublicKey(UserName parent, OsLoginProto.SshPublicKey sshPublicKey, String projectId) {
        ImportSshPublicKeyRequest request = ImportSshPublicKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSshPublicKey(sshPublicKey).setProjectId(projectId).build();
        return this.importSshPublicKey(request);
    }

    public final ImportSshPublicKeyResponse importSshPublicKey(String parent, OsLoginProto.SshPublicKey sshPublicKey, String projectId) {
        ImportSshPublicKeyRequest request = ImportSshPublicKeyRequest.newBuilder().setParent(parent).setSshPublicKey(sshPublicKey).setProjectId(projectId).build();
        return this.importSshPublicKey(request);
    }

    public final ImportSshPublicKeyResponse importSshPublicKey(ImportSshPublicKeyRequest request) {
        return (ImportSshPublicKeyResponse)this.importSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<ImportSshPublicKeyRequest, ImportSshPublicKeyResponse> importSshPublicKeyCallable() {
        return this.stub.importSshPublicKeyCallable();
    }

    public final OsLoginProto.SshPublicKey updateSshPublicKey(FingerprintName name, OsLoginProto.SshPublicKey sshPublicKey) {
        UpdateSshPublicKeyRequest request = UpdateSshPublicKeyRequest.newBuilder().setName(name == null ? null : name.toString()).setSshPublicKey(sshPublicKey).build();
        return this.updateSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey updateSshPublicKey(String name, OsLoginProto.SshPublicKey sshPublicKey) {
        UpdateSshPublicKeyRequest request = UpdateSshPublicKeyRequest.newBuilder().setName(name).setSshPublicKey(sshPublicKey).build();
        return this.updateSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey updateSshPublicKey(FingerprintName name, OsLoginProto.SshPublicKey sshPublicKey, FieldMask updateMask) {
        UpdateSshPublicKeyRequest request = UpdateSshPublicKeyRequest.newBuilder().setName(name == null ? null : name.toString()).setSshPublicKey(sshPublicKey).setUpdateMask(updateMask).build();
        return this.updateSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey updateSshPublicKey(String name, OsLoginProto.SshPublicKey sshPublicKey, FieldMask updateMask) {
        UpdateSshPublicKeyRequest request = UpdateSshPublicKeyRequest.newBuilder().setName(name).setSshPublicKey(sshPublicKey).setUpdateMask(updateMask).build();
        return this.updateSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey updateSshPublicKey(UpdateSshPublicKeyRequest request) {
        return (OsLoginProto.SshPublicKey)this.updateSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSshPublicKeyRequest, OsLoginProto.SshPublicKey> updateSshPublicKeyCallable() {
        return this.stub.updateSshPublicKeyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

