/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;
import org.apache.derby.shared.common.error.StandardException;

class BulkTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    private DataValueDescriptor[][] rowArray;
    private RowLocation[] rowLocations;
    private int curRowPosition;
    private int numRowsInArray;
    private int baseColumnCount;
    private int resultColumnCount;
    private static int OUT_OF_ROWS = 0;

    BulkTableScanResultSet(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, int n, int n2, GeneratedMethod generatedMethod, int n3, GeneratedMethod generatedMethod2, int n4, boolean bl, Qualifier[][] qualifierArray, String string, String string2, String string3, boolean bl2, boolean bl3, int n5, int n6, int n7, boolean bl4, int n8, int n9, boolean bl5, boolean bl6, double d, double d2) throws StandardException {
        super(l, staticCompiledOpenConglomInfo, activation, n, n2, generatedMethod, n3, generatedMethod2, n4, bl, qualifierArray, string, string2, string3, bl2, bl3, n5, n6, n7, bl4, n8, BulkTableScanResultSet.adjustBulkFetchSize(activation, n9, bl5), bl6, d, d2);
        this.setRowLocationsState();
        if (this.fetchRowLocations) {
            this.resultColumnCount = this.accessedCols == null ? this.candidate.nColumns() : this.accessedCols.getNumBitsSet();
            this.baseColumnCount = this.candidate.nColumns() - 1;
            this.candidate.setRowArray(this.lopOffRowLocation());
            if (this.accessedCols == null) {
                this.accessedCols = new FormatableBitSet(this.baseColumnCount);
                for (int i = 0; i < this.baseColumnCount; ++i) {
                    this.accessedCols.set(i);
                }
            } else {
                FormatableBitSet formatableBitSet = new FormatableBitSet(this.baseColumnCount);
                for (int i = 0; i < this.baseColumnCount; ++i) {
                    if (!this.accessedCols.isSet(i)) continue;
                    formatableBitSet.set(i);
                }
                this.accessedCols = formatableBitSet;
            }
        }
    }

    private static int adjustBulkFetchSize(Activation activation, int n, boolean bl) {
        if (bl && activation.getResultSetHoldability()) {
            return 1;
        }
        return n;
    }

    @Override
    protected void openScanController(TransactionController transactionController) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        DataValueDescriptor[] dataValueDescriptorArray2 = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray3 = dataValueDescriptorArray = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (transactionController == null) {
            transactionController = this.activation.getTransactionController();
        }
        this.scanController = transactionController.openCompiledScan(this.activation.getResultSetHoldability(), this.forUpdate ? 4 : 0, this.lockMode, this.isolationLevel, this.accessedCols, dataValueDescriptorArray2, this.startSearchOperator, this.qualifiers, dataValueDescriptorArray, this.stopSearchOperator, this.scoci, this.dcoci);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
    }

    @Override
    public void openCore() throws StandardException {
        super.openCore();
        this.beginTime = this.getCurrentTimeMillis();
        this.rowArray = new DataValueDescriptor[this.rowsPerRead][];
        if (this.fetchRowLocations) {
            this.rowLocations = new RowLocation[this.rowsPerRead];
        }
        this.rowArray[0] = this.candidate.getRowArrayClone();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private DataValueDescriptor[] lopOffRowLocation() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = this.candidate.getRowArrayClone();
        int n = dataValueDescriptorArray.length - 1;
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[n];
        for (int i = 0; i < n; ++i) {
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[i];
        }
        return dataValueDescriptorArray2;
    }

    @Override
    public void reopenCore() throws StandardException {
        super.reopenCore();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        this.checkCancellationFlag();
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen && this.scanControllerOpened) {
            if (this.currentRow == null) {
                this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
            }
            block0: while (true) {
                if (this.curRowPosition >= this.numRowsInArray - 1 && this.reloadArray() == OUT_OF_ROWS) {
                    this.clearCurrentRow();
                    this.setRowCountIfPossible(this.rowsThisScan);
                    return null;
                }
                while (true) {
                    if (++this.curRowPosition >= this.numRowsInArray) continue block0;
                    this.candidate.setRowArray(this.rowArray[this.curRowPosition]);
                    this.currentRow = this.setCompactRow(this.candidate, this.currentRow);
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.skipRow(this.candidate)) break block0;
                    ++this.rowsFiltered;
                }
                break;
            }
            execRow = this.currentRow;
            if (this.fetchRowLocations) {
                int n;
                execRow = new ValueRow(this.resultColumnCount);
                for (n = 1; n < this.resultColumnCount; ++n) {
                    execRow.setColumn(n, this.currentRow.getColumn(n));
                }
                execRow.setColumn(n, this.rowLocations[this.curRowPosition]);
            }
        }
        this.setCurrentRow(execRow);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    private int reloadArray() throws StandardException {
        this.curRowPosition = -1;
        this.numRowsInArray = ((GroupFetchScanController)((Object)this.scanController)).fetchNextGroup(this.rowArray, this.rowLocations);
        return this.numRowsInArray;
    }

    @Override
    public void close() throws StandardException {
        super.close();
        this.numRowsInArray = -1;
        this.curRowPosition = -1;
        this.rowArray = null;
        this.rowLocations = null;
    }

    @Override
    protected boolean canGetInstantaneousLocks() {
        return !this.forUpdate;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 2 || this.isolationLevel == 3 || this.isolationLevel == 1;
    }
}

