/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.exception.NewRulesFileException;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitUserCredentials;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.ChangeSetService;
import com.xebialabs.deployit.plugin.stitch.service.GitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.GitService;
import com.xebialabs.deployit.plugin.stitch.service.util.GitCredentialsUtils$;
import com.xebialabs.deployit.security.service.UserCredentialsService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\u0006\f\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013\rA\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003>\u0011!)\u0005A!b\u0001\n\u00071\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b9\u0003A\u0011A(\t\u000be\u0003A\u0011\t.\t\u000bY\u0004A\u0011I<\u0003)\rC\u0017M\\4f'\u0016$8+\u001a:wS\u000e,\u0017*\u001c9m\u0015\taQ\"A\u0004tKJ4\u0018nY3\u000b\u00059y\u0011AB:uSR\u001c\u0007N\u0003\u0002\u0011#\u00051\u0001\u000f\\;hS:T!AE\n\u0002\u0011\u0011,\u0007\u000f\\8zSRT!\u0001F\u000b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011aC\u0005\u0003E-\u0011\u0001c\u00115b]\u001e,7+\u001a;TKJ4\u0018nY3\u0002\u001b\u001dLGo\u00149t'\u0016\u0014h/[2f!\t\u0001S%\u0003\u0002'\u0017\tiq)\u001b;PaN\u001cVM\u001d<jG\u0016D#!\u0001\u0015\u0011\u0005%\"T\"\u0001\u0016\u000b\u0005-b\u0013AC1o]>$\u0018\r^5p]*\u0011QFL\u0001\bM\u0006\u001cGo\u001c:z\u0015\ty\u0003'A\u0003cK\u0006t7O\u0003\u00022e\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u00014\u0003\ry'oZ\u0005\u0003k)\u0012\u0011\"Q;u_^L'/\u001a3\u0002\u0015\u001dLGoU3sm&\u001cW\r\u0005\u0002!q%\u0011\u0011h\u0003\u0002\u000b\u000f&$8+\u001a:wS\u000e,\u0007F\u0001\u0002)\u0003Y)8/\u001a:De\u0016$WM\u001c;jC2\u001c8+\u001a:wS\u000e,W#A\u001f\u0011\u0005y\u0012U\"A \u000b\u00051\u0001%BA!\u0012\u0003!\u0019XmY;sSRL\u0018BA\"@\u0005Y)6/\u001a:De\u0016$WM\u001c;jC2\u001c8+\u001a:wS\u000e,\u0017aF;tKJ\u001c%/\u001a3f]RL\u0017\r\\:TKJ4\u0018nY3!\u0003E\u0001\u0018m]:x_J$WI\\2ssB$XM]\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!*E\u0001\u0005kRLG.\u0003\u0002M\u0013\n\t\u0002+Y:to>\u0014H-\u00128def\u0004H/\u001a:\u0002%A\f7o]<pe\u0012,en\u0019:zaR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bA\u000b6+V,\u0011\u0005\u0001\u0002\u0001\"B\u0012\b\u0001\u0004!\u0003FA))\u0011\u00151t\u00011\u00018Q\t\u0019\u0006\u0006C\u0003<\u000f\u0001\u000fQ\b\u000b\u0002VQ!)Qi\u0002a\u0002\u000f\"\u0012q\u000bK\u0001\rY&\u001cHO\u0011:b]\u000eDWm\u001d\u000b\u00047>\f\bc\u0001/eO:\u0011QL\u0019\b\u0003=\u0006l\u0011a\u0018\u0006\u0003A^\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005\r\\\u0012a\u00029bG.\fw-Z\u0005\u0003K\u001a\u0014A\u0001T5ti*\u00111m\u0007\t\u0003Q2t!!\u001b6\u0011\u0005y[\u0012BA6\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011QN\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\\\u0002\"\u00029\t\u0001\u00049\u0017\u0001C:pkJ\u001cW-\u00133\t\u000bID\u0001\u0019A:\u0002\u00179\fW.\u001a)biR,'O\u001c\t\u00045Q<\u0017BA;\u001c\u0005\u0019y\u0005\u000f^5p]\u0006qa/\u00197jI\u0006$XM\u0011:b]\u000eDGc\u0001=|yB\u0011!$_\u0005\u0003un\u0011A!\u00168ji\")\u0001/\u0003a\u0001O\")Q0\u0003a\u0001O\u00061!M]1oG\"D#\u0001A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u00021\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u0013\t\u0019AA\u0004TKJ4\u0018nY3")
public class ChangeSetServiceImpl
implements ChangeSetService {
    @Autowired
    private final GitOpsService gitOpsService;
    @Autowired
    private final GitService gitService;
    private final UserCredentialsService userCredentialsService;
    private final PasswordEncrypter passwordEncrypter;

    public UserCredentialsService userCredentialsService() {
        return this.userCredentialsService;
    }

    public PasswordEncrypter passwordEncrypter() {
        return this.passwordEncrypter;
    }

    @Override
    public List<String> listBranches(String sourceId, Option<String> namePattern) {
        GitSource source = this.gitService.fetchGitSourceCi(sourceId);
        GitUserCredentials credentials = GitCredentialsUtils$.MODULE$.getUserOrSourceCredentials(source, this.userCredentialsService(), this.passwordEncrypter());
        return this.gitOpsService.getGitSourceBranchNames(credentials, source).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matches(source.branchRegex()))).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(source.masterBranchName()))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ChangeSetServiceImpl.$anonfun$listBranches$3(namePattern, x$3)));
    }

    @Override
    public void validateBranch(String sourceId, String branch) {
        GitSource source = this.gitService.fetchGitSourceCi(sourceId);
        if (!branch.matches(source.branchRegex())) {
            throw new NewRulesFileException("Branch '" + branch + "' does't match source branch regex '" + source.branchRegex());
        }
    }

    public static final /* synthetic */ boolean $anonfun$listBranches$3(Option namePattern$1, String x$3) {
        return x$3.toLowerCase().contains(((String)namePattern$1.getOrElse((Function0 & Serializable)() -> "")).toLowerCase());
    }

    public ChangeSetServiceImpl(@Autowired GitOpsService gitOpsService, @Autowired GitService gitService, @Autowired UserCredentialsService userCredentialsService, @Autowired PasswordEncrypter passwordEncrypter) {
        this.gitOpsService = gitOpsService;
        this.gitService = gitService;
        this.userCredentialsService = userCredentialsService;
        this.passwordEncrypter = passwordEncrypter;
    }
}

