/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.resteasy;

import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class InternalServerErrorClientResponseInterceptor
implements ClientResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorClientResponseInterceptor.class);

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (this.isError(responseContext.getStatusInfo())) {
            logger.info("Handling Error Response, status code: {}", (Object)responseContext.getStatus());
            this.tryDeployitException(responseContext);
            this.tryUnhandledException(responseContext);
        }
    }

    public boolean isError(Response.StatusType statusInfo) {
        return statusInfo.getFamily() == Response.Status.Family.SERVER_ERROR || statusInfo.getFamily() == Response.Status.Family.CLIENT_ERROR;
    }

    private void tryUnhandledException(ClientResponseContext clientResponse) {
        if (clientResponse.getHeaders().containsKey((Object)"X-Unhandled-Exception")) {
            logger.debug("Found unhandled header");
            throw new RuntimeException(this.extractMessage(clientResponse));
        }
    }

    private void tryDeployitException(ClientResponseContext clientResponse) {
        if (clientResponse.getHeaders().containsKey((Object)"X-Deployit-Exception")) {
            logger.debug("Found XL Deploy header");
            if (!clientResponse.getHeaders().containsKey((Object)"X-Entity") || !clientResponse.hasEntity()) {
                throw new DeployitClientException(this.extractMessage(clientResponse), clientResponse.getStatus());
            }
        }
    }

    private String extractMessage(ClientResponseContext clientResponse) {
        Object exceptionType = clientResponse.getHeaders().getFirst((Object)"X-Exception-Type");
        Object path = clientResponse.getHeaders().getFirst((Object)"X-Path");
        return String.format("%s [%s]: %s", exceptionType, path, this.tryToReadEntity(clientResponse));
    }

    private String tryToReadEntity(ClientResponseContext clientResponse) {
        try {
            return IOUtils.toString((InputStream)clientResponse.getEntityStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "";
        }
    }
}

