/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public enum BOM {
    NONE("NONE", new byte[0], null),
    UTF8("UTF-8", new byte[]{-17, -69, -65}, StandardCharsets.UTF_8),
    UTF16BE("UTF-16BE", new byte[]{-2, -1}, StandardCharsets.UTF_16BE),
    UTF16LE("UTF-16LE", new byte[]{-1, -2}, StandardCharsets.UTF_16LE);

    private final String name;
    private final byte[] bom;
    private Charset charset;

    private BOM(String encoding, byte[] bom, Charset charset) {
        this.name = encoding;
        this.bom = bom;
        this.charset = charset;
    }

    public static BOM matchedBOM(byte[] bomToMatch) {
        if (bomToMatch == null) {
            throw new IllegalArgumentException("BOM bytes cannot be null");
        }
        for (BOM bom : BOM.values()) {
            byte[] bomBytes = bom.getBom();
            if (bomBytes.length <= 0 || !Arrays.equals(bomBytes, Arrays.copyOfRange(bomToMatch, 0, bomBytes.length))) continue;
            return bom;
        }
        return NONE;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultCharset() {
        return this.charset == null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getSize() {
        return this.bom.length;
    }

    public byte[] getBom() {
        return (byte[])this.bom.clone();
    }

    public String toString() {
        return this.name;
    }
}

