/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.i18n;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;

public class I18NUtils {
    public static FormPanel applyComponentOrientation(FormPanel formPanel, ComponentOrientation componentOrientation) {
        if (!componentOrientation.isLeftToRight()) {
            I18NUtils.flip((GridView)formPanel.getFormAccessor());
        }
        return formPanel;
    }

    private static void flip(GridView gridView) {
        JPanel jPanel;
        int n;
        FormLayout formLayout = gridView.getFormLayout();
        int n2 = formLayout.getColumnCount();
        int n3 = formLayout.getRowCount();
        ColumnSpec[] columnSpecArray = new ColumnSpec[n2];
        RowSpec[] rowSpecArray = new RowSpec[n3];
        LinkedList<GridView> linkedList = new LinkedList<GridView>();
        GridComponent[][] gridComponentArray = new GridComponent[n2][n3];
        for (int i = 1; i <= n2; ++i) {
            columnSpecArray[i - 1] = formLayout.getColumnSpec(i);
            for (n = 1; n <= n3; ++n) {
                rowSpecArray[n - 1] = formLayout.getRowSpec(n);
                jPanel = gridView.getGridComponent(i, n);
                gridComponentArray[i - 1][n - 1] = jPanel;
                if (jPanel == null || !(jPanel instanceof FormComponent)) continue;
                linkedList.add((GridView)((GridComponent)jPanel).getBeanDelegate());
            }
        }
        ColumnSpec[] columnSpecArray2 = I18NUtils.flipped(columnSpecArray);
        for (n = 1; n <= n2; ++n) {
            formLayout.setColumnSpec(n, columnSpecArray2[n - 1]);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            jPanel = (GridView)iterator.next();
            I18NUtils.flip((GridView)jPanel);
        }
        for (int i = 1; i <= n3; ++i) {
            for (int j = 1; j <= n2; ++j) {
                GridComponent gridComponent = gridComponentArray[j - 1][i - 1];
                if (gridComponent == null) continue;
                try {
                    CellConstraints cellConstraints = gridView.getConstraints(gridComponent);
                    if (cellConstraints == null) continue;
                    CellConstraints cellConstraints2 = I18NUtils.flipHorizontally(cellConstraints, n2);
                    gridView.setConstraints(gridComponent, cellConstraints2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static ColumnSpec flipped(ColumnSpec columnSpec) {
        FormSpec.DefaultAlignment defaultAlignment = columnSpec.getDefaultAlignment();
        if (defaultAlignment == ColumnSpec.LEFT) {
            defaultAlignment = ColumnSpec.RIGHT;
        } else if (defaultAlignment == ColumnSpec.RIGHT) {
            defaultAlignment = ColumnSpec.LEFT;
        }
        return new ColumnSpec(defaultAlignment, columnSpec.getSize(), columnSpec.getResizeWeight());
    }

    private static ColumnSpec[] flipped(ColumnSpec[] columnSpecArray) {
        int n = columnSpecArray.length;
        ColumnSpec[] columnSpecArray2 = new ColumnSpec[n];
        for (int i = 0; i < n; ++i) {
            columnSpecArray2[i] = I18NUtils.flipped(columnSpecArray[n - 1 - i]);
        }
        return columnSpecArray2;
    }

    private static ColumnSpec[] flipped(String string) {
        return I18NUtils.flipped(ColumnSpec.decodeSpecs(string));
    }

    private static CellConstraints flipHorizontally(CellConstraints cellConstraints) {
        CellConstraints.Alignment alignment = cellConstraints.hAlign;
        if (alignment == CellConstraints.LEFT) {
            alignment = CellConstraints.RIGHT;
        } else if (alignment == CellConstraints.RIGHT) {
            alignment = CellConstraints.LEFT;
        }
        CellConstraints cellConstraints2 = new CellConstraints(cellConstraints.gridX, cellConstraints.gridY, cellConstraints.gridWidth, cellConstraints.gridHeight, alignment, cellConstraints.vAlign);
        if (cellConstraints.insets != null) {
            cellConstraints2.insets = new Insets(cellConstraints.insets.top, cellConstraints.insets.right, cellConstraints.insets.bottom, cellConstraints.insets.left);
        }
        return cellConstraints2;
    }

    private static CellConstraints flipHorizontally(CellConstraints cellConstraints, int n) {
        CellConstraints cellConstraints2 = I18NUtils.flipHorizontally(cellConstraints);
        cellConstraints2.gridX = n + 1 - cellConstraints.gridX - (cellConstraints2.gridWidth - 1);
        return cellConstraints2;
    }
}

