/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.service.replacement.MustachePlaceholders;
import com.xebialabs.deployit.service.replacement.ReaderChunker;
import com.xebialabs.deployit.service.replacement.ScanningMap;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MustachePlaceholderScanner {
    public Set<String> scan(String in) {
        ScanningMap context = new ScanningMap();
        MustachePlaceholders.newMustacheCompiler().compile(in).execute((Object)context, (Writer)new DiscardingWriter());
        return context.keySet();
    }

    public Set<String> scan(Reader in, String delimiters) {
        Reader reader;
        ScanningMap context = new ScanningMap();
        ReaderChunker readerChunker = new ReaderChunker(in, delimiters);
        while ((reader = readerChunker.next()) != null) {
            MustachePlaceholders.newMustacheCompiler().withDelims(delimiters).compile(reader).execute((Object)context, (Writer)new DiscardingWriter());
        }
        return context.keySet();
    }

    public static boolean hasPlaceholders(String value) {
        return !new MustachePlaceholderScanner().scan(value).isEmpty();
    }

    public static boolean hasPlaceholders(Object deployableValue, PropertyDescriptor deployablePropDesc) {
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: 
            case DATE: 
            case CI: 
            case SET_OF_CI: 
            case LIST_OF_CI: {
                break;
            }
            case STRING: {
                return MustachePlaceholderScanner.hasPlaceholders((String)deployableValue);
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                Collection collection = (Collection)deployableValue;
                return collection.stream().anyMatch(MustachePlaceholderScanner::hasPlaceholders);
            }
            case MAP_STRING_STRING: {
                Map map = (Map)deployableValue;
                return map.values().stream().anyMatch(MustachePlaceholderScanner::hasPlaceholders);
            }
            default: {
                throw new IllegalStateException("Unknown property type: " + String.valueOf(deployablePropDesc.getKind()));
            }
        }
        return false;
    }

    private static class DiscardingWriter
    extends Writer {
        private DiscardingWriter() {
        }

        @Override
        public void write(char[] chars, int i, int i1) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

