/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logmanager.ExtLogRecord;

public final class SubstituteFilter
implements Filter {
    private final Pattern pattern;
    private final String replacement;
    private final boolean replaceAll;

    public SubstituteFilter(Pattern pattern, String replacement, boolean replaceAll) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.replaceAll = replaceAll;
    }

    public SubstituteFilter(String patternString, String replacement, boolean replaceAll) {
        this(Pattern.compile(patternString), replacement, replaceAll);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        String currentMsg = record instanceof ExtLogRecord ? ((ExtLogRecord)record).getFormattedMessage() : record.getMessage();
        Matcher matcher = this.pattern.matcher(String.valueOf(currentMsg));
        String msg = this.replaceAll ? matcher.replaceAll(this.replacement) : matcher.replaceFirst(this.replacement);
        if (record instanceof ExtLogRecord) {
            ((ExtLogRecord)record).setMessage(msg, ExtLogRecord.FormatStyle.NO_FORMAT);
        } else {
            record.setMessage(msg);
        }
        return true;
    }
}

