/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.task.serdes.kryo.javakaffee.jodatime;

import ai.digital.deploy.task.serdes.kryo.javakaffee.jodatime.IdentifiableChronology;
import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class JodaDateTimeSerializer
extends Serializer<DateTime> {
    static final String MILLIS = "millis";
    static final String DATE_TIME = "dt";
    static final String CHRONOLOGY = "ch";
    static final String TIME_ZONE = "tz";

    public JodaDateTimeSerializer() {
        this.setImmutable(true);
    }

    public DateTime read(Kryo kryo, Input input, Class<? extends DateTime> type) {
        long millis = input.readLong(true);
        Chronology chronology = IdentifiableChronology.readChronology(input);
        DateTimeZone tz = this.readTimeZone(input);
        return new DateTime(millis, chronology.withZone(tz));
    }

    public void write(Kryo kryo, Output output, DateTime obj) {
        output.writeLong(obj.getMillis(), true);
        String chronologyId = IdentifiableChronology.getChronologyId(obj.getChronology());
        output.writeString(chronologyId == null ? "" : chronologyId);
        output.writeString(obj.getZone().getID());
    }

    private DateTimeZone readTimeZone(Input input) {
        String tz = input.readString();
        if ("".equals(tz)) {
            return DateTimeZone.getDefault();
        }
        return DateTimeZone.forID((String)tz);
    }
}

