/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import java.util.EnumSet;
import java.util.Set;

public class SpecVersion {
    public EnumSet<VersionFlag> getVersionFlags(long versionValue) {
        EnumSet<VersionFlag> versionFlags = EnumSet.noneOf(VersionFlag.class);
        for (VersionFlag flag : VersionFlag.values()) {
            long flagValue = flag.versionFlagValue;
            if ((flagValue & versionValue) != flagValue) continue;
            versionFlags.add(flag);
        }
        return versionFlags;
    }

    public long getVersionValue(Set<VersionFlag> flags) {
        long value = 0L;
        for (VersionFlag flag : flags) {
            value |= flag.versionFlagValue;
        }
        return value;
    }

    public static enum VersionFlag {
        V4(1L),
        V6(2L),
        V7(4L),
        V201909(8L),
        V202012(16L);

        private final long versionFlagValue;

        private VersionFlag(long versionFlagValue) {
            this.versionFlagValue = versionFlagValue;
        }

        public long getVersionFlagValue() {
            return this.versionFlagValue;
        }
    }
}

