/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.commons.vfs2.util.WeakRefFileListener;

public class DelegateFileObject<AFS extends AbstractFileSystem>
extends AbstractFileObject<AFS>
implements FileListener {
    private FileObject fileObject;
    private final Set<String> children = new HashSet<String>();
    private boolean ignoreEvent;

    public DelegateFileObject(AbstractFileName fileName, AFS fileSystem, FileObject fileObject) throws FileSystemException {
        super(fileName, fileSystem);
        this.fileObject = fileObject;
        if (fileObject != null) {
            WeakRefFileListener.installListener(fileObject, this);
        }
    }

    public void attachChild(FileName baseName, FileType type) throws Exception {
        FileType oldType = this.doGetType();
        if (this.children.add(baseName.getBaseName())) {
            this.childrenChanged(baseName, type);
        }
        this.maybeTypeChanged(oldType);
    }

    @Override
    public void close() throws FileSystemException {
        super.close();
        if (this.fileObject != null) {
            this.fileObject.close();
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        this.ignoreEvent = true;
        try {
            this.fileObject.createFolder();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    @Override
    protected void doDelete() throws Exception {
        this.ignoreEvent = true;
        try {
            this.fileObject.delete();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        return this.getFileContent().getAttributes();
    }

    @Override
    protected Certificate[] doGetCertificates() throws Exception {
        return this.getFileContent().getCertificates();
    }

    protected FileContentInfo doGetContentInfo() throws Exception {
        return this.getFileContent().getContentInfo();
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.getFileContent().getSize();
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        return this.getFileContent().getInputStream(bufferSize);
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.getFileContent().getLastModifiedTime();
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return this.getFileContent().getOutputStream(bAppend);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return this.getFileContent().getRandomAccessContent(mode);
    }

    @Override
    protected FileType doGetType() throws FileSystemException {
        if (this.fileObject != null) {
            return this.fileObject.getType();
        }
        if (this.children.isEmpty()) {
            return FileType.IMAGINARY;
        }
        return FileType.FOLDER;
    }

    @Override
    protected boolean doIsExecutable() throws FileSystemException {
        if (this.fileObject != null) {
            return this.fileObject.isExecutable();
        }
        return false;
    }

    @Override
    protected boolean doIsHidden() throws FileSystemException {
        if (this.fileObject != null) {
            return this.fileObject.isHidden();
        }
        return false;
    }

    @Override
    protected boolean doIsReadable() throws FileSystemException {
        if (this.fileObject != null) {
            return this.fileObject.isReadable();
        }
        return true;
    }

    @Override
    protected boolean doIsWriteable() throws FileSystemException {
        if (this.fileObject != null) {
            return this.fileObject.isWriteable();
        }
        return false;
    }

    @Override
    protected String[] doListChildren() throws Exception {
        if (this.fileObject != null) {
            FileObject[] children;
            try {
                children = this.fileObject.getChildren();
            }
            catch (FileNotFolderException e) {
                throw new FileNotFolderException(this.getName(), (Throwable)e);
            }
            return (String[])Stream.of(children).filter(Objects::nonNull).map(child -> child.getName().getBaseName()).toArray(String[]::new);
        }
        return this.children.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    protected void doRemoveAttribute(String attrName) throws Exception {
        this.getFileContent().removeAttribute(attrName);
    }

    @Override
    protected void doRename(FileObject newFile) throws Exception {
        this.fileObject.moveTo(((DelegateFileObject)newFile).fileObject);
    }

    @Override
    protected void doSetAttribute(String attrName, Object value) throws Exception {
        this.getFileContent().setAttribute(attrName, value);
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.getFileContent().setLastModifiedTime(modtime);
        return true;
    }

    @Override
    public void fileChanged(FileChangeEvent event) throws Exception {
        if (event.getFileObject() != this.fileObject) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleChanged();
        }
    }

    @Override
    public void fileCreated(FileChangeEvent event) throws Exception {
        if (event.getFileObject() != this.fileObject) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleCreate(this.fileObject.getType());
        }
    }

    @Override
    public void fileDeleted(FileChangeEvent event) throws Exception {
        if (event.getFileObject() != this.fileObject) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleDelete();
        }
    }

    public FileObject getDelegateFile() {
        return this.fileObject;
    }

    FileContent getFileContent() throws FileSystemException {
        return this.fileObject.getContent();
    }

    private void maybeTypeChanged(FileType oldType) throws Exception {
        FileType newType = this.doGetType();
        if (oldType == FileType.IMAGINARY && newType != FileType.IMAGINARY) {
            this.handleCreate(newType);
        } else if (oldType != FileType.IMAGINARY && newType == FileType.IMAGINARY) {
            this.handleDelete();
        }
    }

    @Override
    public void refresh() throws FileSystemException {
        super.refresh();
        if (this.fileObject != null) {
            this.fileObject.refresh();
        }
    }

    public void setFile(FileObject fileObject) throws Exception {
        FileType oldType = this.doGetType();
        if (fileObject != null) {
            WeakRefFileListener.installListener(fileObject, this);
        }
        this.fileObject = fileObject;
        this.maybeTypeChanged(oldType);
    }
}

