/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsClientBuilderConfigurer;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

public class AwsSecretsManagerEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<AwsSecretsManagerEnvironmentRepository, AwsSecretsManagerEnvironmentProperties> {
    private final ConfigServerProperties configServerProperties;

    public AwsSecretsManagerEnvironmentRepositoryFactory(ConfigServerProperties configServerProperties) {
        this.configServerProperties = configServerProperties;
    }

    @Override
    public AwsSecretsManagerEnvironmentRepository build(AwsSecretsManagerEnvironmentProperties environmentProperties) {
        SecretsManagerClientBuilder clientBuilder = SecretsManagerClient.builder();
        AwsClientBuilderConfigurer.configureClientBuilder(clientBuilder, environmentProperties.getRegion(), environmentProperties.getEndpoint());
        SecretsManagerClient client = (SecretsManagerClient)clientBuilder.build();
        return new AwsSecretsManagerEnvironmentRepository(client, this.configServerProperties, environmentProperties);
    }
}

