/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;

public class BDDMockito
extends Mockito {
    public static <T> BDDMyOngoingStubbing<T> given(T methodCall) {
        return new BDDOngoingStubbingImpl<T>(Mockito.when(methodCall));
    }

    public static <T> Then<T> then(T mock) {
        return new ThenImpl<T>(mock);
    }

    public static BDDStubber willThrow(Throwable ... toBeThrown) {
        return new BDDStubberImpl(Mockito.doThrow(toBeThrown));
    }

    public static BDDStubber willThrow(Class<? extends Throwable> toBeThrown) {
        return new BDDStubberImpl(Mockito.doThrow(toBeThrown));
    }

    public static BDDStubber willThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... throwableTypes) {
        return new BDDStubberImpl(Mockito.doThrow(toBeThrown, throwableTypes));
    }

    public static BDDStubber willAnswer(Answer<?> answer) {
        return new BDDStubberImpl(Mockito.doAnswer(answer));
    }

    public static BDDStubber will(Answer<?> answer) {
        return new BDDStubberImpl(Mockito.doAnswer(answer));
    }

    public static BDDStubber willDoNothing() {
        return new BDDStubberImpl(Mockito.doNothing());
    }

    public static BDDStubber willReturn(Object toBeReturned) {
        return new BDDStubberImpl(Mockito.doReturn(toBeReturned));
    }

    public static BDDStubber willReturn(Object toBeReturned, Object ... toBeReturnedNext) {
        return new BDDStubberImpl(Mockito.doReturn(toBeReturned, toBeReturnedNext));
    }

    public static BDDStubber willCallRealMethod() {
        return new BDDStubberImpl(Mockito.doCallRealMethod());
    }

    private static class BDDStubberImpl
    implements BDDStubber {
        private final Stubber mockitoStubber;

        public BDDStubberImpl(Stubber mockitoStubber) {
            this.mockitoStubber = mockitoStubber;
        }

        @Override
        public <T> T given(T mock) {
            return this.mockitoStubber.when(mock);
        }

        @Override
        public BDDStubber willAnswer(Answer<?> answer) {
            return new BDDStubberImpl(this.mockitoStubber.doAnswer(answer));
        }

        @Override
        public BDDStubber will(Answer<?> answer) {
            return new BDDStubberImpl(this.mockitoStubber.doAnswer(answer));
        }

        @Override
        public BDDStubber willDoNothing() {
            return new BDDStubberImpl(this.mockitoStubber.doNothing());
        }

        @Override
        public BDDStubber willReturn(Object toBeReturned) {
            return new BDDStubberImpl(this.mockitoStubber.doReturn(toBeReturned));
        }

        @Override
        public BDDStubber willReturn(Object toBeReturned, Object ... nextToBeReturned) {
            return new BDDStubberImpl(this.mockitoStubber.doReturn(toBeReturned).doReturn(nextToBeReturned));
        }

        @Override
        public BDDStubber willThrow(Throwable ... toBeThrown) {
            return new BDDStubberImpl(this.mockitoStubber.doThrow(toBeThrown));
        }

        @Override
        public BDDStubber willThrow(Class<? extends Throwable> toBeThrown) {
            return new BDDStubberImpl(this.mockitoStubber.doThrow(toBeThrown));
        }

        @Override
        public BDDStubber willThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... nextToBeThrown) {
            return new BDDStubberImpl(this.mockitoStubber.doThrow(toBeThrown, nextToBeThrown));
        }

        @Override
        public BDDStubber willCallRealMethod() {
            return new BDDStubberImpl(this.mockitoStubber.doCallRealMethod());
        }
    }

    public static interface BDDStubber {
        public BDDStubber willAnswer(Answer<?> var1);

        public BDDStubber will(Answer<?> var1);

        public BDDStubber willDoNothing();

        public BDDStubber willReturn(Object var1);

        public BDDStubber willReturn(Object var1, Object ... var2);

        public BDDStubber willThrow(Throwable ... var1);

        public BDDStubber willThrow(Class<? extends Throwable> var1);

        public BDDStubber willThrow(Class<? extends Throwable> var1, Class<? extends Throwable> ... var2);

        public BDDStubber willCallRealMethod();

        public <T> T given(T var1);
    }

    private static class ThenImpl<T>
    implements Then<T> {
        private final T mock;

        ThenImpl(T mock) {
            this.mock = mock;
        }

        @Override
        public T should() {
            return Mockito.verify(this.mock);
        }

        @Override
        public T should(VerificationMode mode) {
            return Mockito.verify(this.mock, mode);
        }

        @Override
        public T should(InOrder inOrder) {
            return inOrder.verify(this.mock);
        }

        @Override
        public T should(InOrder inOrder, VerificationMode mode) {
            return inOrder.verify(this.mock, mode);
        }

        @Override
        public void shouldHaveNoMoreInteractions() {
            Mockito.verifyNoMoreInteractions(this.mock);
        }

        @Override
        public void shouldHaveNoInteractions() {
            Mockito.verifyNoInteractions(this.mock);
        }
    }

    public static interface Then<T> {
        public T should();

        public T should(VerificationMode var1);

        public T should(InOrder var1);

        public T should(InOrder var1, VerificationMode var2);

        public void shouldHaveNoMoreInteractions();

        public void shouldHaveNoInteractions();
    }

    private static class BDDOngoingStubbingImpl<T>
    implements BDDMyOngoingStubbing<T> {
        private final OngoingStubbing<T> mockitoOngoingStubbing;

        public BDDOngoingStubbingImpl(OngoingStubbing<T> ongoingStubbing) {
            this.mockitoOngoingStubbing = ongoingStubbing;
        }

        @Override
        public BDDMyOngoingStubbing<T> willAnswer(Answer<?> answer) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenAnswer(answer));
        }

        @Override
        public BDDMyOngoingStubbing<T> will(Answer<?> answer) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.then(answer));
        }

        @Override
        public BDDMyOngoingStubbing<T> willReturn(T value) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenReturn(value));
        }

        @Override
        public BDDMyOngoingStubbing<T> willReturn(T value, T ... values) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenReturn(value, values));
        }

        @Override
        public BDDMyOngoingStubbing<T> willThrow(Throwable ... throwables) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenThrow(throwables));
        }

        @Override
        public BDDMyOngoingStubbing<T> willThrow(Class<? extends Throwable> throwableType) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenThrow(throwableType));
        }

        @Override
        public BDDMyOngoingStubbing<T> willThrow(Class<? extends Throwable> throwableType, Class<? extends Throwable> ... throwableTypes) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenThrow(throwableType, throwableTypes));
        }

        @Override
        public BDDMyOngoingStubbing<T> willCallRealMethod() {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenCallRealMethod());
        }

        @Override
        public <M> M getMock() {
            return this.mockitoOngoingStubbing.getMock();
        }
    }

    public static interface BDDMyOngoingStubbing<T> {
        public BDDMyOngoingStubbing<T> willAnswer(Answer<?> var1);

        public BDDMyOngoingStubbing<T> will(Answer<?> var1);

        public BDDMyOngoingStubbing<T> willReturn(T var1);

        public BDDMyOngoingStubbing<T> willReturn(T var1, T ... var2);

        public BDDMyOngoingStubbing<T> willThrow(Throwable ... var1);

        public BDDMyOngoingStubbing<T> willThrow(Class<? extends Throwable> var1);

        public BDDMyOngoingStubbing<T> willThrow(Class<? extends Throwable> var1, Class<? extends Throwable> ... var2);

        public BDDMyOngoingStubbing<T> willCallRealMethod();

        public <M> M getMock();
    }
}

