/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import java.io.NotSerializableException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.CompactByteString$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra!B\u0006\r\u00059!\u0002\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\t\u0011-\u0002!\u0011!Q\u0001\n\u0015BQ\u0001\f\u0001\u0005\u00025BQ\u0001\r\u0001\u0005BEBq!\u000e\u0001C\u0002\u0013\u0005c\u0007\u0003\u0004;\u0001\u0001\u0006Ia\u000e\u0005\u0006w\u0001!\t\u0005\u0010\u0005\u0006\u0019\u0002!\t%\u0014\u0005\u0006w\u0001!\t\u0005\u0018\u0005\u0006\u0019\u0002!\t\u0005\u001a\u0002\u0015\u0005f$Xm\u0015;sS:<7+\u001a:jC2L'0\u001a:\u000b\u00055q\u0011!D:fe&\fG.\u001b>bi&|gN\u0003\u0002\u0010!\u0005)\u0001/Z6l_*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h'\u0011\u0001QcG\u0010\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\r\u0013\tqBB\u0001\u0006TKJL\u0017\r\\5{KJ\u0004\"\u0001\b\u0011\n\u0005\u0005b!\u0001\u0006\"zi\u0016\u0014UO\u001a4feN+'/[1mSj,'/\u0001\u0004tsN$X-\\\u0002\u0001+\u0005)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u000f\u0003\u0015\t7\r^8s\u0013\tQsEA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\rqJg.\u001b;?)\tqs\u0006\u0005\u0002\u001d\u0001!)!e\u0001a\u0001K\u0005y\u0011N\\2mk\u0012,W*\u00198jM\u0016\u001cH/F\u00013!\t12'\u0003\u00025/\t9!i\\8mK\u0006t\u0017AC5eK:$\u0018NZ5feV\tq\u0007\u0005\u0002\u0017q%\u0011\u0011h\u0006\u0002\u0004\u0013:$\u0018aC5eK:$\u0018NZ5fe\u0002\n\u0001\u0002^8CS:\f'/\u001f\u000b\u0004{\u0001\u0013\u0005C\u0001\f?\u0013\tytC\u0001\u0003V]&$\b\"B!\b\u0001\u0004)\u0012!A8\t\u000b\r;\u0001\u0019\u0001#\u0002\u0007\t,h\r\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006\u0019a.[8\u000b\u0003%\u000bAA[1wC&\u00111J\u0012\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u00034s_6\u0014\u0015N\\1ssR\u0019QCT(\t\u000b\rC\u0001\u0019\u0001#\t\u000bAC\u0001\u0019A)\u0002\u00115\fg.\u001b4fgR\u0004\"AU-\u000f\u0005M;\u0006C\u0001+\u0018\u001b\u0005)&B\u0001,$\u0003\u0019a$o\\8u}%\u0011\u0001lF\u0001\u0007!J,G-\u001a4\n\u0005i[&AB*ue&twM\u0003\u0002Y/Q\u0011Ql\u0019\t\u0004-y\u0003\u0017BA0\u0018\u0005\u0015\t%O]1z!\t1\u0012-\u0003\u0002c/\t!!)\u001f;f\u0011\u0015\t\u0015\u00021\u0001\u0016)\r)Rm\u001a\u0005\u0006M*\u0001\r!X\u0001\u0006Ef$Xm\u001d\u0005\u0006!*\u0001\r\u0001\u001b\t\u0004-%\\\u0017B\u00016\u0018\u0005\u0019y\u0005\u000f^5p]B\u0012A.\u001d\t\u0004%6|\u0017B\u00018\\\u0005\u0015\u0019E.Y:t!\t\u0001\u0018\u000f\u0004\u0001\u0005\u0013I<\u0017\u0011!A\u0001\u0006\u0003\u0019(aA0%iE\u0011Ao\u001e\t\u0003-UL!A^\f\u0003\u000f9{G\u000f[5oOB\u0011a\u0003_\u0005\u0003s^\u00111!\u00118zQ\t\u00011\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u0005QPA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public final class ByteStringSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$(this, bytes, clazz);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        ByteString bs = (ByteString)o;
        if (bs.copyToBuffer(buf) < bs.length()) {
            throw new BufferOverflowException();
        }
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        return CompactByteString$.MODULE$.apply(buf);
    }

    @Override
    public byte[] toBinary(Object o) {
        ByteString bs = (ByteString)o;
        byte[] result = new byte[bs.length()];
        bs.copyToArray(result, 0, bs.length());
        return result;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return CompactByteString$.MODULE$.apply(bytes);
    }

    public ByteStringSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-bytestring", system);
    }
}

