/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UserDefinedArrayType;
import org.hibernate.mapping.UserDefinedObjectType;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;

public class Namespace {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Namespace.class);
    private final PhysicalNamingStrategy physicalNamingStrategy;
    private final JdbcEnvironment jdbcEnvironment;
    private final Name name;
    private final Name physicalName;
    private final Map<Identifier, Table> tables = new TreeMap<Identifier, Table>();
    private final Map<Identifier, Sequence> sequences = new TreeMap<Identifier, Sequence>();
    private final Map<Identifier, UserDefinedType> udts = new HashMap<Identifier, UserDefinedType>();

    public Namespace(PhysicalNamingStrategy physicalNamingStrategy, JdbcEnvironment jdbcEnvironment, Name name) {
        this.physicalNamingStrategy = physicalNamingStrategy;
        this.jdbcEnvironment = jdbcEnvironment;
        this.name = name;
        this.physicalName = new Name(physicalNamingStrategy.toPhysicalCatalogName(name.getCatalog(), jdbcEnvironment), physicalNamingStrategy.toPhysicalSchemaName(name.getSchema(), jdbcEnvironment));
        if (log.isDebugEnabled()) {
            log.debugf("Created database namespace [logicalName=%s, physicalName=%s]", name.toString(), this.physicalName.toString());
        }
    }

    public Name getName() {
        return this.name;
    }

    public Name getPhysicalName() {
        return this.physicalName;
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public Table locateTable(Identifier logicalTableName) {
        return this.tables.get(logicalTableName);
    }

    public void registerTable(Identifier logicalName, Table table) {
        Table previous = this.tables.put(logicalName, table);
        if (previous != null) {
            log.debugf("Replacing Table registration(%s) : %s -> %s", logicalName, previous, table);
        }
    }

    public Table createTable(Identifier logicalTableName, Function<Identifier, Table> creator) {
        Table existing = this.tables.get(logicalTableName);
        if (existing != null) {
            return existing;
        }
        Identifier physicalTableName = this.physicalNamingStrategy.toPhysicalTableName(logicalTableName, this.jdbcEnvironment);
        Table table = creator.apply(physicalTableName);
        this.tables.put(logicalTableName, table);
        return table;
    }

    public DenormalizedTable createDenormalizedTable(Identifier logicalTableName, Function<Identifier, DenormalizedTable> creator) {
        Table existing = this.tables.get(logicalTableName);
        if (existing != null) {
            return (DenormalizedTable)existing;
        }
        Identifier physicalTableName = this.physicalNamingStrategy.toPhysicalTableName(logicalTableName, this.jdbcEnvironment);
        DenormalizedTable table = creator.apply(physicalTableName);
        this.tables.put(logicalTableName, table);
        return table;
    }

    public Sequence locateSequence(Identifier name) {
        return this.sequences.get(name);
    }

    public void registerSequence(Identifier logicalName, Sequence sequence) {
        if (this.sequences.containsKey(logicalName)) {
            throw new HibernateException("Sequence was already registered with that name [" + logicalName.toString() + "]");
        }
        this.sequences.put(logicalName, sequence);
    }

    public Sequence createSequence(Identifier logicalName, Function<Identifier, Sequence> creator) {
        if (this.sequences.containsKey(logicalName)) {
            throw new HibernateException("Sequence was already registered with that name [" + logicalName.toString() + "]");
        }
        Identifier physicalName = this.physicalNamingStrategy.toPhysicalSequenceName(logicalName, this.jdbcEnvironment);
        Sequence sequence = creator.apply(physicalName);
        this.sequences.put(logicalName, sequence);
        return sequence;
    }

    @Incubating
    public Collection<UserDefinedType> getUserDefinedTypes() {
        return this.udts.values();
    }

    @Incubating
    public List<UserDefinedType> getDependencyOrderedUserDefinedTypes() {
        Set<Identifier> dependencies;
        LinkedHashMap<Identifier, UserDefinedType> orderedUdts = new LinkedHashMap<Identifier, UserDefinedType>(this.udts.size());
        HashMap<Identifier, Set<Identifier>> udtDependencies = new HashMap<Identifier, Set<Identifier>>(this.udts.size());
        for (Map.Entry<Identifier, UserDefinedType> entry : this.udts.entrySet()) {
            dependencies = new HashSet();
            UserDefinedType udt = entry.getValue();
            if (udt instanceof UserDefinedObjectType) {
                for (Column udtColumn : ((UserDefinedObjectType)udt).getColumns()) {
                    JdbcType elementJdbcType;
                    Type udtColumnType = udtColumn.getValue().getType();
                    if (!(udtColumnType instanceof BasicType)) continue;
                    JdbcType jdbcType = ((BasicType)udtColumnType).getJdbcType();
                    if (jdbcType instanceof SqlTypedJdbcType) {
                        ((HashSet)dependencies).add(Identifier.toIdentifier(((SqlTypedJdbcType)jdbcType).getSqlTypeName()));
                        continue;
                    }
                    if (!(jdbcType instanceof ArrayJdbcType) || !((elementJdbcType = ((ArrayJdbcType)jdbcType).getElementJdbcType()) instanceof SqlTypedJdbcType)) continue;
                    ((HashSet)dependencies).add(Identifier.toIdentifier(((SqlTypedJdbcType)elementJdbcType).getSqlTypeName()));
                }
                if (((HashSet)dependencies).isEmpty()) {
                    orderedUdts.put(udt.getNameIdentifier(), udt);
                    continue;
                }
                udtDependencies.put(entry.getKey(), dependencies);
                continue;
            }
            if (!(udt instanceof UserDefinedArrayType)) continue;
            Identifier elementTypeName = Identifier.toIdentifier(((UserDefinedArrayType)udt).getElementTypeName());
            if (this.udts.get(elementTypeName) instanceof UserDefinedObjectType) {
                ((HashSet)dependencies).add(elementTypeName);
                udtDependencies.put(entry.getKey(), dependencies);
                continue;
            }
            orderedUdts.put(udt.getNameIdentifier(), udt);
        }
        while (!udtDependencies.isEmpty()) {
            Iterator iterator = udtDependencies.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Identifier, UserDefinedType> entry;
                entry = iterator.next();
                dependencies = (Set)((Object)entry.getValue());
                dependencies.removeAll(orderedUdts.keySet());
                if (!dependencies.isEmpty()) continue;
                orderedUdts.put(entry.getKey(), this.udts.get(entry.getKey()));
                iterator.remove();
            }
        }
        return new ArrayList<UserDefinedType>(orderedUdts.values());
    }

    @Incubating
    public UserDefinedObjectType locateUserDefinedType(Identifier logicalTypeName) {
        return (UserDefinedObjectType)this.udts.get(logicalTypeName);
    }

    @Incubating
    public UserDefinedArrayType locateUserDefinedArrayType(Identifier logicalTypeName) {
        return (UserDefinedArrayType)this.udts.get(logicalTypeName);
    }

    @Incubating
    public UserDefinedObjectType createUserDefinedType(Identifier logicalTypeName, Function<Identifier, UserDefinedObjectType> creator) {
        UserDefinedType existing = this.udts.get(logicalTypeName);
        if (existing != null) {
            return (UserDefinedObjectType)existing;
        }
        Identifier physicalTableName = this.physicalNamingStrategy.toPhysicalTypeName(logicalTypeName, this.jdbcEnvironment);
        UserDefinedObjectType type = creator.apply(physicalTableName);
        this.udts.put(logicalTypeName, type);
        return type;
    }

    @Incubating
    public UserDefinedArrayType createUserDefinedArrayType(Identifier logicalTypeName, Function<Identifier, UserDefinedArrayType> creator) {
        UserDefinedType existing = this.udts.get(logicalTypeName);
        if (existing != null) {
            return (UserDefinedArrayType)existing;
        }
        Identifier physicalTableName = this.physicalNamingStrategy.toPhysicalTypeName(logicalTypeName, this.jdbcEnvironment);
        UserDefinedArrayType type = creator.apply(physicalTableName);
        this.udts.put(logicalTypeName, type);
        return type;
    }

    public String toString() {
        return "Schema{name=" + this.name + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace that = (Namespace)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Iterable<Sequence> getSequences() {
        return this.sequences.values();
    }

    public static class ComparableHelper {
        public static <T extends Comparable<T>> int compare(T first, T second) {
            if (first == null) {
                if (second == null) {
                    return 0;
                }
                return 1;
            }
            if (second == null) {
                return -1;
            }
            return first.compareTo(second);
        }
    }

    public static class Name
    implements Comparable<Name> {
        private final Identifier catalog;
        private final Identifier schema;

        public Name(Identifier catalog, Identifier schema) {
            this.schema = schema;
            this.catalog = catalog;
        }

        public Identifier getCatalog() {
            return this.catalog;
        }

        public Identifier getSchema() {
            return this.schema;
        }

        public String toString() {
            return "Name{catalog=" + this.catalog + ", schema=" + this.schema + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name that = (Name)o;
            return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            int result = this.catalog != null ? this.catalog.hashCode() : 0;
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(Name that) {
            int catalogCheck = ComparableHelper.compare(this.getCatalog(), that.getCatalog());
            if (catalogCheck != 0) {
                return catalogCheck;
            }
            return ComparableHelper.compare(this.getSchema(), that.getSchema());
        }
    }
}

