/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.NamedAuxiliaryDatabaseObject;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.internal.EnumHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleEnumJdbcType
implements JdbcType {
    public static final OracleEnumJdbcType INSTANCE = new OracleEnumJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 12;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 6001;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return (appender, value, dialect, wrapperOptions) -> appender.appendSql(dialect.getEnumTypeDeclaration((Class)javaType.getJavaType()) + "." + ((Enum)value).name());
    }

    @Override
    public String getFriendlyName() {
        return "ENUM";
    }

    public String toString() {
        return "EnumTypeDescriptor";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, OracleEnumJdbcType.this.getJdbcTypeCode());
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, OracleEnumJdbcType.this.getJdbcTypeCode());
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setString(index, ((Enum)value).name());
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setString(name, ((Enum)value).name());
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(rs.getString(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getString(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getString(name), options);
            }
        };
    }

    @Override
    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Size columnSize, Database database, JdbcTypeIndicators context) {
        this.addAuxiliaryDatabaseObjects(javaType, database, true);
    }

    @Override
    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Size columnSize, Database database, TypeConfiguration typeConfiguration) {
        this.addAuxiliaryDatabaseObjects(javaType, database, true);
    }

    private void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Database database, boolean sortEnumValues) {
        Dialect dialect = database.getDialect();
        Class enumClass = (Class)javaType.getJavaType();
        String enumTypeName = enumClass.getSimpleName();
        Object[] enumeratedValues = EnumHelper.getEnumeratedValues(enumClass);
        if (sortEnumValues) {
            Arrays.sort(enumeratedValues);
        }
        String[] create = this.getCreateEnumTypeCommand(javaType.getJavaTypeClass().getSimpleName(), (String[])enumeratedValues);
        String[] drop = dialect.getDropEnumTypeCommand(enumClass);
        if (create != null && create.length > 0) {
            database.addAuxiliaryDatabaseObject(new NamedAuxiliaryDatabaseObject(enumTypeName, database.getDefaultNamespace(), create, drop, Collections.emptySet(), true));
        }
    }

    public String[] getCreateEnumTypeCommand(String name, String[] values) {
        StringBuilder domain = new StringBuilder();
        domain.append("create domain ").append(name).append(" as enum (");
        String separator = "";
        for (String value : values) {
            domain.append(separator).append(value).append("='").append(value).append("'");
            separator = ", ";
        }
        domain.append(')');
        return new String[]{domain.toString()};
    }
}

