/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayArgumentValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayIncludesArgumentValidator
extends ArrayArgumentValidator {
    public static final ArgumentsValidator INSTANCE = new ArrayIncludesArgumentValidator();

    protected ArrayIncludesArgumentValidator() {
        super(0);
    }

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        BasicPluralType<?, ?> haystackType = this.getPluralType(0, arguments, functionName, typeConfiguration);
        BasicPluralType<?, ?> needleType = this.getPluralType(1, arguments, functionName, typeConfiguration);
        if (haystackType != null && needleType != null && !haystackType.equals(needleType) && !haystackType.getElementType().equals(needleType)) {
            throw new FunctionArgumentException(String.format("Parameter 1 of function '%s()' has type %s, but argument is of type '%s'", functionName, haystackType.getJavaTypeDescriptor().getTypeName(), needleType.getTypeName()));
        }
    }
}

